/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.binders;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.scanners.ClassSpaceScanner;
import org.sonatype.guice.plexus.binders.PlexusTypeBinder;
import org.sonatype.guice.plexus.config.PlexusBeanMetadata;
import org.sonatype.guice.plexus.config.PlexusBeanModule;
import org.sonatype.guice.plexus.config.PlexusBeanSource;
import org.sonatype.guice.plexus.scanners.PlexusAnnotatedMetadata;
import org.sonatype.guice.plexus.scanners.PlexusTypeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlexusAnnotatedBeanModule
implements PlexusBeanModule {
    private static final Map<String, List<Element>> CACHED_ELEMENTS = new HashMap<String, List<Element>>();
    private final ClassSpace space;
    private final Map<?, ?> variables;
    private final boolean caching;

    public PlexusAnnotatedBeanModule(ClassSpace space, Map<?, ?> variables) {
        this(space, variables, false);
    }

    public PlexusAnnotatedBeanModule(ClassSpace space, Map<?, ?> variables, boolean caching) {
        this.space = space;
        this.variables = variables;
        this.caching = caching;
    }

    @Override
    public PlexusBeanSource configure(Binder binder) {
        if (this.caching) {
            this.cachingScan(binder);
        } else {
            this.scan(binder);
        }
        return new PlexusAnnotatedBeanSource(this.variables);
    }

    void scan(Binder binder) {
        if (null != this.space) {
            new ClassSpaceScanner(this.space).accept(new PlexusTypeVisitor(new PlexusTypeBinder(binder)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cachingScan(Binder binder) {
        Map<String, List<Element>> map = CACHED_ELEMENTS;
        synchronized (map) {
            String key = String.valueOf(this.space);
            if (!CACHED_ELEMENTS.containsKey(key)) {
                CACHED_ELEMENTS.put(key, Elements.getElements(new RecordingModule()));
            }
            for (Element e : CACHED_ELEMENTS.get(key)) {
                e.applyTo(binder);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PlexusAnnotatedBeanSource
    implements PlexusBeanSource {
        private final PlexusBeanMetadata metadata;

        PlexusAnnotatedBeanSource(Map<?, ?> variables) {
            this.metadata = new PlexusAnnotatedMetadata(variables);
        }

        @Override
        public PlexusBeanMetadata getBeanMetadata(Class<?> implementation) {
            return implementation.isAnnotationPresent(Component.class) ? this.metadata : null;
        }
    }

    final class RecordingModule
    implements Module {
        RecordingModule() {
        }

        public void configure(Binder binder) {
            PlexusAnnotatedBeanModule.this.scan(binder);
        }
    }
}

