/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2;

import bbd.jportal2.Flag;
import bbd.jportal2.GeneratedFileGroup;
import bbd.jportal2.GeneratedFiles;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseGenerator {
    private static final Logger logger = LoggerFactory.getLogger(BaseGenerator.class);
    private GeneratedFiles generatedOutputFiles;

    public GeneratedFiles getGeneratedOutputFiles() {
        return this.generatedOutputFiles;
    }

    public BaseGenerator(Class inheritedGeneratorClass) {
        this.generatedOutputFiles = new GeneratedFiles(inheritedGeneratorClass.getSimpleName());
    }

    public Vector<Flag> getFlags() {
        return new Vector<Flag>();
    }

    public Boolean toBoolean(Object value) {
        String s = value.toString();
        return s.equalsIgnoreCase("true");
    }

    protected void addFileToOutputtedFilesList(String fileType, Path generatedFile) {
        GeneratedFileGroup fg = this.generatedOutputFiles.getFileGroups().stream().filter(f -> f.getFileGroupName().equalsIgnoreCase(fileType)).findFirst().orElse(new GeneratedFileGroup(fileType));
        this.generatedOutputFiles.getFileGroups().add(fg);
        fg.getFiles().add(generatedFile);
    }

    protected void addFileToOutputtedFilesList(String fileType, String generatedFile) {
        this.addFileToOutputtedFilesList(fileType, Paths.get(generatedFile, new String[0]));
    }

    protected PrintWriter openOutputFileForGeneration(String fileType, Path fileName) throws FileNotFoundException {
        logger.info("{}: {} ", (Object)fileType, (Object)fileName);
        this.addFileToOutputtedFilesList(fileType, fileName);
        return new PrintWriter(new FileOutputStream(fileName.toString()));
    }

    protected PrintWriter openOutputFileForGeneration(String fileType, String fileName) throws FileNotFoundException {
        return this.openOutputFileForGeneration(fileType, Paths.get(fileName, new String[0]));
    }
}

