/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2.generators;

import bbd.jportal2.BaseGenerator;
import bbd.jportal2.Database;
import bbd.jportal2.Enum;
import bbd.jportal2.Field;
import bbd.jportal2.Flag;
import bbd.jportal2.IBuiltInSIProcessor;
import bbd.jportal2.Proc;
import bbd.jportal2.Table;
import java.io.PrintWriter;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonCliCode
extends BaseGenerator
implements IBuiltInSIProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PythonCliCode.class);
    protected Vector<Flag> flagsVector;
    static String pymodName;
    static String pymodFront;
    static boolean dontQualify;
    static boolean useUTF8;
    static boolean useLatin1;
    private Vector<String> coverFunctions;

    public PythonCliCode() {
        super(PythonCliCode.class);
    }

    @Override
    public String description() {
        return "Generates CLI Python Code";
    }

    @Override
    public String documentation() {
        return "Generates CLI Python Code";
    }

    private static void flagDefaults() {
        pymodName = "";
        pymodFront = "";
        dontQualify = false;
        useUTF8 = false;
        useLatin1 = false;
    }

    @Override
    public Vector<Flag> getFlags() {
        if (this.flagsVector == null) {
            PythonCliCode.flagDefaults();
            this.flagsVector = new Vector();
            this.flagsVector.addElement(new Flag("use pymod", new String(pymodName), "Use pymod"));
            this.flagsVector.addElement(new Flag("dont qualify", new Boolean(dontQualify), "Dont Qualify"));
            this.flagsVector.addElement(new Flag("utf-8", new Boolean(useUTF8), "use utf-8"));
            this.flagsVector.addElement(new Flag("iso-8859-1", new Boolean(useLatin1), "use iso-8859-1"));
        }
        return this.flagsVector;
    }

    void setFlags(Database database) {
        if (this.flagsVector != null) {
            pymodName = (String)this.flagsVector.elementAt((int)0).value;
            dontQualify = this.toBoolean(this.flagsVector.elementAt((int)1).value);
            useUTF8 = this.toBoolean(this.flagsVector.elementAt((int)2).value);
            useLatin1 = this.toBoolean(this.flagsVector.elementAt((int)3).value);
        } else {
            PythonCliCode.flagDefaults();
        }
        for (int i = 0; i < database.flags.size(); ++i) {
            String flag = database.flags.elementAt(i);
            if (flag.length() > 6 && flag.substring(0, 6).equalsIgnoreCase("pymod=")) {
                pymodName = flag.substring(6);
                continue;
            }
            if (flag.equalsIgnoreCase("dont qualify")) {
                dontQualify = true;
                continue;
            }
            if (flag.equalsIgnoreCase("utf-8") || flag.equalsIgnoreCase("utf-8")) {
                useUTF8 = true;
                useLatin1 = false;
                continue;
            }
            if (!flag.equalsIgnoreCase("iso-8859-1") && !flag.equalsIgnoreCase("latin1")) continue;
            useLatin1 = true;
            useUTF8 = false;
        }
        if (pymodName.length() > 0) {
            logger.info(" (pymod=" + pymodName + ")");
            pymodFront = pymodName + "";
            if (!dontQualify) {
                pymodFront = pymodFront + pymodName.substring(0, 1).toUpperCase() + pymodName.substring(1) + "_";
            }
        }
        if (dontQualify) {
            logger.info(" (dont qualify)");
        }
        if (useUTF8) {
            logger.info(" (utf-8)");
        }
        if (useLatin1) {
            logger.info(" (iso-8859-1)");
        }
    }

    String padder(String s, int length) {
        for (int i = s.length(); i < length - 1; ++i) {
            s = s + " ";
        }
        return s + " ";
    }

    @Override
    public void generate(Database database, String output) throws Exception {
        this.setFlags(database);
        for (int i = 0; i < database.tables.size(); ++i) {
            Table table = database.tables.elementAt(i);
            this.generateTable(table, output);
        }
    }

    void generateTable(Table table, String output) throws Exception {
        try (PrintWriter outData = this.openOutputFileForGeneration("py", output + "DB_" + table.useName().toUpperCase() + ".py");){
            if (useUTF8) {
                outData.println("# -*- coding: utf-8 -*-");
            } else if (useLatin1) {
                outData.println("# -*- coding: iso-8859-1 -*-");
            }
            outData.println("# This code was generated, do not modify it, modify it at source and regenerate it.");
            outData.println("# " + table.useName().toUpperCase() + ".py");
            outData.println();
            if (pymodName.length() > 0) {
                outData.println("import " + pymodName);
            }
            outData.println();
            outData.println("_BLOB = 1;_BOOLEAN = 2;_BYTE = 3;_CHAR = 4;_DATE = 5;_DATETIME = 6");
            outData.println("_DOUBLE = 7;_DYNAMIC = 8;_FLOAT = 9;_IDENTITY = 10;_INT = 11;_LONG = 12");
            outData.println("_MONEY = 13;_SEQUENCE = 14;_SHORT = 15;_STATUS = 16;_TIME = 17");
            outData.println("_TIMESTAMP = 18;_TLOB = 19;_USERSTAMP = 20;_ANSICHAR = 21;_UID = 22;_XML = 23");
            outData.println("_BIGSEQUENCE = 24;_BIGIDENTITY = 25");
            outData.println();
            outData.println("# =i=n=d=e=n=t=a=t=i=o=n===b=y===f=o=u=r======");
            outData.println("# s    : value as a string");
            outData.println("# attr : (type, length, scale, precision)");
            outData.println("# name : name of field for reporting");
            outData.println("# =i=s===a===p=a=i=n==========================");
            outData.println();
            outData.println("def _validate(s, attr, name):");
            outData.println("    if attr[0] in (_CHAR, _ANSICHAR, _DATE, _DATETIME, _TIME, _TIMESTAMP, _USERSTAMP, _XML):");
            outData.println("        if len(s) > attr[1]: raise AssertionError('%s:Length exceeds %d' % (name, attr[1]))");
            outData.println("    elif attr[0] in (_DOUBLE, _FLOAT) and attr[2] > 15:");
            outData.println("        if len(s) > attr[2]+2: raise AssertionError('%s:Length exceeds %d' % (name, attr[2]+2))");
            outData.println("    elif attr[0] == _MONEY:");
            outData.println("        if len(s) > 20: raise AssertionError('%s:Length exceeds %d' % (name, 20))");
            outData.println("    return s");
            outData.println();
            outData.println("def _str(s, attr, name):");
            outData.println("    if s == None:");
            outData.println("        return None");
            if (useUTF8) {
                outData.println("    elif isinstance(s, unicode):");
                outData.println("        fix = s.encode('utf-8')");
                outData.println("        return _validate(str(fix), attr, name)");
            } else if (useLatin1) {
                outData.println("    elif isinstance(s, unicode):");
                outData.println("        fix = s.encode('iso-8859-1')");
                outData.println("        return _validate(str(fix), attr, name)");
            } else {
                outData.println("    elif isinstance(s, unicode):");
                outData.println("        fix = ''");
                outData.println("        for c in s: fix += chr(ord(c)%256)");
                outData.println("        return _validate(str(fix), attr, name)");
            }
            outData.println("    elif isinstance(s, float):");
            outData.println("        return '%0.15g' % (s)");
            outData.println("    return _validate(str(s), attr, name)");
            outData.println();
            this.generateEnums(table, outData);
            if (table.hasStdProcs) {
                this.generateStdOutputRec(table, outData);
            }
            this.generateUserOutputRecs(table, outData);
            outData.flush();
        }
    }

    void generateDataFields(Vector<Field> fields, String superName, String className, String tableName, PrintWriter outData) {
        Field field;
        int i;
        Field field2;
        int i2;
        outData.print("    __slots__ = [");
        for (i2 = 0; i2 < fields.size(); ++i2) {
            field2 = fields.elementAt(i2);
            if (i2 != 0) {
                outData.println(",");
                outData.print("        ");
            }
            outData.print("'" + field2.useName() + "'");
        }
        outData.println("]");
        outData.print("    __attrs__ = [");
        for (i2 = 0; i2 < fields.size(); ++i2) {
            field2 = fields.elementAt(i2);
            if (i2 != 0) {
                outData.println(",");
                outData.print("        ");
            }
            outData.print("(" + field2.type + ", " + field2.length + ", " + field2.precision + ", " + field2.scale + ")");
        }
        outData.println("]");
        outData.println("    def __init__(self):");
        if (superName.length() > 0) {
            outData.println("        " + superName + ".__init__(self) ## \\field see:" + superName);
        }
        for (i2 = 0; i2 < fields.size(); ++i2) {
            field2 = fields.elementAt(i2);
            if (this.isNull(field2)) {
                outData.println("        self." + field2.useName() + " = None ## \\field " + field2.useName() + ":" + this.varName(field2) + " nullable");
                continue;
            }
            outData.println("        self." + field2.useName() + " = '' ## \\field " + field2.useName() + ":" + this.varName(field2));
        }
        outData.println("    def _fromList(self, result):");
        String no = "";
        if (superName.length() > 0) {
            outData.println("        no = " + superName + "._fromList(self, result)");
            no = "no+";
        }
        for (i = 0; i < fields.size(); ++i) {
            field = fields.elementAt(i);
            if (field.type == 12 || field.type == 24 || field.type == 25) {
                if (this.isNull(field)) {
                    outData.println("        self." + field.useName() + " = None if result[" + no + i + "] == None else int(result[" + no + i + "])");
                    continue;
                }
                outData.println("        self." + field.useName() + " = int(result[" + no + i + "])");
                continue;
            }
            outData.println("        self." + field.useName() + " = result[" + no + i + "]");
        }
        outData.println("        return " + no + fields.size());
        outData.println("    def _toList(self):");
        outData.println("        names = " + className + ".__slots__");
        outData.println("        attrs = " + className + ".__attrs__");
        if (superName.length() > 0) {
            outData.print("        result = " + superName + "._toList(self) + [");
        } else {
            outData.print("        result = [");
        }
        for (i = 0; i < fields.size(); ++i) {
            field = fields.elementAt(i);
            if (i != 0) {
                outData.println(",");
                outData.print("            ");
            }
            outData.print("_str(self." + field.useName() + ", attrs[" + i + "], names[" + i + "])");
        }
        outData.println("]");
        outData.println("        return result");
        outData.println("    def _display(self):");
        outData.print("        names = ");
        if (superName.length() > 0) {
            outData.print(superName + ".__slots__ + ");
        }
        outData.println(className + ".__slots__");
        outData.println("        data = self._toList()");
        outData.println("        for i in range(len(data)):");
        outData.println("            print('%s: %s' % (names[i], data[i]))");
    }

    void generateStdOutputRec(Table table, PrintWriter outData) {
        int i;
        for (i = 0; i < table.comments.size(); ++i) {
            String s = table.comments.elementAt(i);
            outData.println("## " + s);
        }
        outData.println("## \\class D" + table.useName());
        outData.println("class D" + table.useName() + "(object):");
        outData.println("    def _make(self): return D" + table.useName() + "()");
        outData.println("    def _name(self): return ('D" + table.useName() + "','O" + table.useName() + "')");
        this.generateDataFields(table.fields, "", "D" + table.useName(), table.useName(), outData);
        outData.println();
        outData.println("## \\class O" + table.useName());
        outData.println("## \\field see:D" + table.useName());
        outData.println("O" + table.useName() + " = D" + table.useName());
        outData.println();
        if (pymodName.length() > 0) {
            outData.println("class " + table.useName() + "(D" + table.useName() + "):");
            outData.println("    def __init__(self): D" + table.useName() + ".__init__(self)");
            this.coverFunctions = new Vector();
            for (i = 0; i < table.procs.size(); ++i) {
                Proc proc = table.procs.elementAt(i);
                if (proc.isData || !proc.isStd && !proc.isStdExtended()) continue;
                if (proc.isMultipleInput) {
                    this.generateBulkAction(table, proc, outData);
                    continue;
                }
                if (proc.isInsert && proc.hasReturning) {
                    this.generateAction(table, proc, outData);
                    continue;
                }
                if (proc.outputs.size() > 0) {
                    if (proc.isSingle) {
                        this.generateSingle(table, proc, outData);
                        continue;
                    }
                    this.generateMultiple(table, proc, outData);
                    continue;
                }
                this.generateAction(table, proc, outData);
            }
            outData.println();
            for (i = 0; i < this.coverFunctions.size(); ++i) {
                outData.println(this.coverFunctions.elementAt(i));
            }
        }
    }

    private void generateInput(String tableName, String dataStruct, String procName, String parms, PrintWriter outData) {
        String parameters = "";
        if (parms.length() > 2) {
            parameters = parms.substring(2);
        }
        outData.println("    def _" + procName + "_dict(self, parms):");
        outData.println("        'low level call with dictionary input'");
        outData.println("        for parm in parms: setattr(self, parm, parms[parm])");
        outData.println("        return self." + procName + "()");
        outData.println("    def " + procName + "_with(self" + parms + "):");
        outData.println("        'with method - it is suggested for maintenance named parameters are used'");
        outData.println("        return self._" + procName + "_dict(vars())");
        this.coverFunctions.addElement("def " + tableName + "_" + procName + "(" + parameters + "):");
        this.coverFunctions.addElement("    'It is suggested for maintenance named parameters are used'");
        this.coverFunctions.addElement("    return " + dataStruct + "()._" + procName + "_dict(vars())");
        this.coverFunctions.addElement("");
    }

    private void generateCover(String tableName, String dataStruct, String procName, PrintWriter outData) {
        this.coverFunctions.addElement("def " + tableName + "_" + procName + "():");
        this.coverFunctions.addElement("    return " + dataStruct + "()." + procName + "()");
        this.coverFunctions.addElement("");
    }

    private void generateMultiple(Table table, Proc proc, PrintWriter outData) {
        Object field;
        int f;
        String parameters = "";
        String dataStruct = proc.isStd || proc.isStdExtended() ? table.useName() : table.useName() + proc.upperFirst();
        boolean hasInput = proc.inputs.size() > 0 || proc.dynamics.size() > 0;
        String firstParm = "";
        if (hasInput) {
            firstParm = "self, ";
        }
        outData.println("    def " + proc.name + "(self):");
        outData.println("        ''' Multiple returns count and recs");
        if (hasInput) {
            outData.println("        Input:");
            for (f = 0; f < proc.inputs.size(); ++f) {
                field = proc.inputs.elementAt(f);
                outData.println("            " + ((Field)field).useName());
                parameters = parameters + ", " + ((Field)field).useName() + "=" + this.defValue((Field)field);
            }
            for (f = 0; f < proc.dynamics.size(); ++f) {
                field = proc.dynamics.elementAt(f);
                outData.println("            " + (String)field);
                parameters = parameters + ", " + (String)field + "=''";
            }
        }
        outData.println("        Output:");
        for (f = 0; f < proc.outputs.size(); ++f) {
            field = proc.outputs.elementAt(f);
            outData.println("            " + ((Field)field).useName());
        }
        outData.println("        '''");
        outData.println("        return " + pymodFront + table.useName() + proc.upperFirst() + "(" + firstParm + "0, O" + dataStruct + "())");
        if (hasInput) {
            this.generateInput(table.useName(), dataStruct, proc.name, parameters, outData);
        } else {
            this.generateCover(table.useName(), dataStruct, proc.name, outData);
        }
    }

    private void generateSingle(Table table, Proc proc, PrintWriter outData) {
        Object field;
        int f;
        String dataStruct = proc.isStd || proc.isStdExtended() ? table.useName() : table.useName() + proc.upperFirst();
        String parameters = "";
        boolean hasInput = proc.inputs.size() > 0 || proc.dynamics.size() > 0;
        outData.println("    def " + proc.name + "(self):");
        outData.println("        ''' Single returns boolean and record");
        if (hasInput) {
            outData.println("        Input:");
            for (f = 0; f < proc.inputs.size(); ++f) {
                field = proc.inputs.elementAt(f);
                outData.println("            " + ((Field)field).useName());
                parameters = parameters + ", " + ((Field)field).useName() + "=" + this.defValue((Field)field);
            }
            for (f = 0; f < proc.dynamics.size(); ++f) {
                field = proc.dynamics.elementAt(f);
                outData.println("            " + (String)field);
                parameters = parameters + ", " + (String)field + "=''";
            }
        }
        outData.println("        Output:");
        for (f = 0; f < proc.outputs.size(); ++f) {
            field = proc.outputs.elementAt(f);
            outData.println("            " + ((Field)field).useName());
        }
        outData.println("        '''");
        outData.println("        return " + pymodFront + table.useName() + proc.upperFirst() + "(self)");
        if (hasInput) {
            this.generateInput(table.useName(), dataStruct, proc.name, parameters, outData);
        } else {
            this.generateCover(table.useName(), dataStruct, proc.name, outData);
        }
    }

    private void generateAction(Table table, Proc proc, PrintWriter outData) {
        Object field;
        int f;
        String dataStruct = proc.isStd || proc.isStdExtended() ? table.useName() : table.useName() + proc.upperFirst();
        String parameters = "";
        outData.println("    def " + proc.name + "(self):");
        outData.println("        ''' Action");
        outData.println("        Input:");
        for (f = 0; f < proc.inputs.size(); ++f) {
            field = proc.inputs.elementAt(f);
            outData.println("            " + ((Field)field).useName());
            parameters = parameters + ", " + ((Field)field).useName() + "=" + this.defValue((Field)field);
        }
        for (f = 0; f < proc.dynamics.size(); ++f) {
            field = proc.dynamics.elementAt(f);
            outData.println("            " + (String)field);
            parameters = parameters + ", " + (String)field + "=''";
        }
        outData.println("        '''");
        outData.println("        return " + pymodFront + table.useName() + proc.upperFirst() + "(self)");
        this.generateInput(table.useName(), dataStruct, proc.name, parameters, outData);
    }

    private void generateBulkAction(Table table, Proc proc, PrintWriter outData) {
        Object field;
        int f;
        outData.println("    def " + proc.name + "(self, recs):");
        outData.println("        ''' Bulk Action");
        outData.println("        Input:");
        for (f = 0; f < proc.inputs.size(); ++f) {
            field = proc.inputs.elementAt(f);
            outData.println("            " + ((Field)field).useName());
        }
        for (f = 0; f < proc.dynamics.size(); ++f) {
            field = proc.dynamics.elementAt(f);
            outData.println("            " + (String)field);
        }
        outData.println("        '''");
        outData.println("        " + pymodFront + table.useName() + proc.upperFirst() + "(len(recs), recs)");
    }

    void generateUserOutputRecs(Table table, PrintWriter outData) {
        for (int i = 0; i < table.procs.size(); ++i) {
            Proc proc = table.procs.elementAt(i);
            if (proc.isData || proc.isStd || proc.hasNoData() || proc.isStdExtended()) continue;
            String work = "(object)";
            String superName = "";
            if (proc.outputs.size() > 0) {
                for (int j = 0; j < proc.comments.size(); ++j) {
                    outData.println("##" + proc.comments.elementAt(j));
                }
                String typeChar = "D";
                if (proc.hasDiscreteInput()) {
                    typeChar = "O";
                }
                work = "(" + typeChar + table.useName() + proc.upperFirst() + ")";
                superName = typeChar + table.useName() + proc.upperFirst();
                outData.println("## \\class " + typeChar + table.useName() + proc.upperFirst());
                outData.println("class " + typeChar + table.useName() + proc.upperFirst() + "(object):");
                outData.println("    def _make(self): return " + typeChar + table.useName() + proc.upperFirst() + "()");
                if (proc.hasDiscreteInput()) {
                    outData.println("    def _name(self): return ('" + typeChar + table.useName() + proc.upperFirst() + "')");
                } else {
                    outData.println("    def _name(self): return ('D" + table.useName() + proc.upperFirst() + "', 'O" + table.useName() + proc.upperFirst() + "')");
                }
                this.generateDataFields(proc.outputs, "", typeChar + table.useName() + proc.upperFirst(), table.useName(), outData);
                outData.println();
            }
            if (proc.hasDiscreteInput()) {
                int j;
                outData.println("## \\class D" + table.useName() + proc.upperFirst());
                outData.println("class D" + table.useName() + proc.upperFirst() + work + ":");
                outData.println("    def _make(self): return D" + table.useName() + proc.upperFirst() + "()");
                outData.println("    def _name(self): return ('D" + table.useName() + proc.upperFirst() + "')");
                Vector<Field> discreteInputs = new Vector<Field>();
                for (j = 0; j < proc.inputs.size(); ++j) {
                    Field field = proc.inputs.elementAt(j);
                    if (proc.hasOutput(field.name)) continue;
                    discreteInputs.addElement(field);
                }
                for (j = 0; j < proc.dynamics.size(); ++j) {
                    Field f = new Field();
                    Integer length = proc.dynamicSizes.elementAt(j);
                    f.name = proc.dynamics.elementAt(j);
                    f.type = (byte)4;
                    f.length = length;
                    discreteInputs.addElement(f);
                }
                this.generateDataFields(discreteInputs, superName, "D" + table.useName() + proc.upperFirst(), table.useName(), outData);
                outData.println();
            } else if (proc.outputs.size() > 0) {
                outData.println("## \\class O" + table.useName() + proc.upperFirst());
                outData.println("## \\field see:O" + table.useName() + proc.upperFirst());
                outData.println("O" + table.useName() + proc.upperFirst() + " = D" + table.useName() + proc.upperFirst());
                outData.println();
            }
            if (pymodName.length() <= 0) continue;
            this.coverFunctions = new Vector();
            outData.println("class " + table.useName() + proc.upperFirst() + "(D" + table.useName() + proc.upperFirst() + "):");
            outData.println("    def __init__(self): D" + table.useName() + proc.upperFirst() + ".__init__(self)");
            if (proc.isMultipleInput) {
                this.generateBulkAction(table, proc, outData);
            } else if (proc.isInsert && proc.hasReturning) {
                this.generateAction(table, proc, outData);
            } else if (proc.outputs.size() > 0) {
                if (proc.isSingle) {
                    this.generateSingle(table, proc, outData);
                } else {
                    this.generateMultiple(table, proc, outData);
                }
            } else {
                this.generateAction(table, proc, outData);
            }
            outData.println();
            for (int j = 0; j < this.coverFunctions.size(); ++j) {
                outData.println(this.coverFunctions.elementAt(j));
            }
        }
    }

    void generateEnums(Table table, PrintWriter outData) {
        for (int i = 0; i < table.fields.size(); ++i) {
            Field field = table.fields.elementAt(i);
            this.generateEnums(table.useName() + field.useName(), field, outData);
        }
    }

    void generateEnums(String baseName, Field field, PrintWriter outData) {
        if (field.enums.size() > 0) {
            Enum entry;
            int j;
            outData.println("class " + field.useName() + "Enum(object):");
            for (j = 0; j < field.enums.size(); ++j) {
                entry = field.enums.elementAt(j);
                String entryName = entry.name;
                if (entryName.equals("None")) {
                    entryName = "None_";
                }
                if (this.varName(field) == "int") {
                    outData.println("    " + entryName + " = " + entry.value);
                    continue;
                }
                outData.println("    " + entryName + " = '" + entry.value + "'");
            }
            outData.println();
            outData.println(baseName + " = {}");
            for (j = 0; j < field.enums.size(); ++j) {
                entry = field.enums.elementAt(j);
                outData.println(baseName + "['" + entry.name + "'] = " + entry.value);
            }
            for (j = 0; j < field.enums.size(); ++j) {
                entry = field.enums.elementAt(j);
                outData.println(baseName + "[" + entry.value + "] = '" + entry.name + "'");
            }
            outData.println();
        } else if (field.valueList.size() > 0) {
            String entry;
            int j;
            outData.println("class " + baseName + "():");
            for (j = 0; j < field.valueList.size(); ++j) {
                entry = field.valueList.elementAt(j);
                outData.println("    " + entry + " = " + j);
            }
            outData.print("    lookup = (");
            for (j = 0; j < field.valueList.size(); ++j) {
                entry = field.valueList.elementAt(j);
                outData.print((j == 0 ? "" : ", ") + "'" + entry + "'");
            }
            outData.println(")");
            outData.println();
        }
    }

    String varName(Field field) {
        switch (field.type) {
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                return "int";
            }
            case 12: 
            case 24: 
            case 25: {
                return "long";
            }
            case 4: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                return "char";
            }
            case 1: {
                return "BLOB";
            }
            case 5: 
            case 6: 
            case 17: 
            case 18: {
                return "char";
            }
            case 7: 
            case 9: 
            case 13: {
                return "double";
            }
        }
        return "<unsupported>";
    }

    String defValue(Field field) {
        if (this.isNull(field)) {
            return "None";
        }
        switch (field.type) {
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                return "'0'";
            }
            case 12: 
            case 24: 
            case 25: {
                return "'0'";
            }
            case 4: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                return "''";
            }
            case 1: {
                return "'BLOB'";
            }
            case 5: 
            case 6: 
            case 17: 
            case 18: {
                return "''";
            }
            case 7: 
            case 9: 
            case 13: {
                return "'0.0'";
            }
        }
        return "<unsupported>";
    }

    boolean isNull(Field field) {
        if (!field.isNull) {
            return false;
        }
        switch (field.type) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 25: {
                return true;
            }
        }
        return false;
    }
}

