/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.Iterator;
import java.util.Set;
import net.sf.extcos.filter.ChainedFilter;
import net.sf.extcos.filter.Filter;
import net.sf.extcos.filter.MultiplexingConnector;
import net.sf.extcos.filter.ResultSetProvider;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.util.Assert;
import net.sf.extcos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChainedFilter
implements ChainedFilter {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<Filter> filters;
    private MultiplexingConnector resourceDispatcher;
    private ResultSetProvider resultSetProvider;

    @Override
    public void setChildFilters(Set<Filter> filters) {
        try {
            Assert.notEmpty(filters, IllegalArgumentException.class, "filters must not be null or empty");
            this.filters = filters;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("successfully set filters");
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("couldn't set filters", e);
        }
    }

    @Override
    public void setResourceDispatcher(MultiplexingConnector resourceDispatcher) {
        try {
            Assert.notNull(resourceDispatcher, IllegalArgumentException.class, "resourceDispatcher must not be null");
            this.resourceDispatcher = resourceDispatcher;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(StringUtils.append("successfully set resource dispatcher to ", resourceDispatcher));
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("couldn't set resource dispatcher", e);
        }
    }

    @Override
    public void setResultSetProvider(ResultSetProvider resultSetProvider) {
        try {
            Assert.notNull(resultSetProvider, IllegalArgumentException.class, "resultSetProvider must not be null");
            this.resultSetProvider = resultSetProvider;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(StringUtils.append("successfully set result set provider to ", resultSetProvider));
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("couldn't set result set provider", e);
        }
    }

    @Override
    public final void filter(Iterable<Resource> resources) {
        if (resources == null) {
            this.logger.debug("resources must not be null, nothing to filter");
            return;
        }
        if (this.resourceDispatcher == null && this.filters == null) {
            this.logger.warn("no resource dispatcher or filters are set, hence no filtering will take place");
            return;
        }
        if (this.resourceDispatcher == null && this.filters != null) {
            if (this.resultSetProvider == null) {
                this.invokeFilters(resources);
            } else {
                this.invokeFilters(this.filter(resources.iterator(), this.resultSetProvider.getResultSet()));
            }
        } else if (this.resourceDispatcher != null && this.filters == null) {
            this.filter(resources.iterator(), this.resourceDispatcher);
        } else if (this.resultSetProvider == null) {
            this.filter(resources.iterator(), this.resourceDispatcher);
            this.invokeFilters(resources);
        } else {
            this.invokeFilters(this.filter(resources.iterator(), this.resourceDispatcher, this.resultSetProvider.getResultSet()));
        }
    }

    private void invokeFilters(Iterable<Resource> resources) {
        for (Filter filter : this.filters) {
            filter.filter(resources);
        }
    }

    protected abstract Iterable<Resource> filter(Iterator<Resource> var1, Set<Resource> var2);

    protected abstract void filter(Iterator<Resource> var1, MultiplexingConnector var2);

    protected abstract Iterable<Resource> filter(Iterator<Resource> var1, MultiplexingConnector var2, Set<Resource> var3);
}

