/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.lang.annotation.Annotation;
import net.sf.extcos.exception.ConcurrentInspectionException;
import net.sf.extcos.filter.ResourceMatcher;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.util.Assert;

public class AnnotatedWithResourceMatcher
implements ResourceMatcher {
    private final Class<? extends Annotation> annotation;

    public AnnotatedWithResourceMatcher(Class<? extends Annotation> annotation) {
        Assert.notNull(annotation, IllegalArgumentException.class, "annotation must not be null");
        this.annotation = annotation;
    }

    @Override
    public boolean matches(Resource resource) throws ConcurrentInspectionException {
        Assert.notNull(resource, IllegalArgumentException.class);
        return resource.getAnnotationMetadata(this.annotation) != null;
    }

    @Override
    public boolean isMatcherFor(Object obj) {
        return this.annotation.equals(obj);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotation == null ? 0 : this.annotation.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotatedWithResourceMatcher other = (AnnotatedWithResourceMatcher)obj;
        return !(this.annotation == null ? other.annotation != null : !this.annotation.equals(other.annotation));
    }
}

