/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import net.sf.extcos.selector.annotation.ArgumentKey;
import net.sf.extcos.selector.annotation.ArgumentMapping;
import net.sf.extcos.selector.annotation.ArgumentValue;
import net.sf.extcos.spi.AnnotationMetadata;
import net.sf.extcos.util.Assert;

public class ArgumentMappingImpl
implements ArgumentMapping {
    private final String key;
    private final ArgumentValue value;

    public ArgumentMappingImpl(ArgumentKey key, ArgumentValue value) {
        Assert.notNull(key, IllegalArgumentException.class);
        Assert.notNull(value, IllegalArgumentException.class);
        this.key = key.getKey();
        this.value = value;
    }

    @Override
    public boolean isSetIn(AnnotationMetadata annotation) {
        Object value;
        if (annotation.hasKey(this.key) && (value = annotation.getValue(this.key)) != null) {
            return this.value.matches(value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArgumentMappingImpl other = (ArgumentMappingImpl)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

