/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.sf.extcos.filter.ChainedFilter;
import net.sf.extcos.filter.Filter;
import net.sf.extcos.filter.FilterInterceptor;
import net.sf.extcos.filter.ImmediateConnector;
import net.sf.extcos.filter.MergableConnector;
import net.sf.extcos.filter.ResourceMatcher;
import net.sf.extcos.internal.AnnotatedWithResourceMatcher;
import net.sf.extcos.internal.AnnotationArgumentResourceMatcher;
import net.sf.extcos.internal.ArraySet;
import net.sf.extcos.internal.ExtendingResourceMatcher;
import net.sf.extcos.internal.FilterObjects;
import net.sf.extcos.internal.ImplementingResourceMatcher;
import net.sf.extcos.internal.TypeFilterConjunction;
import net.sf.extcos.internal.TypeFilterDisjunction;
import net.sf.extcos.internal.factory.FilterInterceptorsFactory;
import net.sf.extcos.selector.AnnotatedWithTypeFilter;
import net.sf.extcos.selector.ExtendingTypeFilter;
import net.sf.extcos.selector.ImplementingTypeFilter;
import net.sf.extcos.selector.TypeFilter;
import net.sf.extcos.util.Assert;
import net.sf.extcos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildContext {
    private static Logger logger = LoggerFactory.getLogger(BuildContext.class);
    private static BuildContext instance;
    private final Map<TypeFilter, MergableConnector> annotatedConnectors = new HashMap<TypeFilter, MergableConnector>();
    private final Map<TypeFilter, MergableConnector> extendingConnectors = new HashMap<TypeFilter, MergableConnector>();
    private final Map<TypeFilter, MergableConnector> implementingConnectors = new HashMap<TypeFilter, MergableConnector>();
    private final Map<TypeFilter, MergableConnector> conjunctionConnectors = new HashMap<TypeFilter, MergableConnector>();
    private final Map<TypeFilter, MergableConnector> disjunctionConnectors = new HashMap<TypeFilter, MergableConnector>();
    private final Set<FilterObjects> annotatedWithFilterObjects = new ArraySet<FilterObjects>();
    private final Set<FilterObjects> annotationArgumentFilterObjects = new ArraySet<FilterObjects>();
    private final Set<FilterObjects> extendingFilterObjects = new ArraySet<FilterObjects>();
    private final Set<FilterObjects> implementingFilterObjects = new ArraySet<FilterObjects>();
    private final Set<ImmediateConnector> immediateConnectorRegistry = new ArraySet<ImmediateConnector>();
    private final Set<Class<? extends FilterInterceptor>> filterInterceptors = FilterInterceptorsFactory.buildFilterInterceptors();

    private BuildContext() {
    }

    public static BuildContext getInstance() {
        if (instance == null) {
            instance = new BuildContext();
        }
        return instance;
    }

    public void addImmediateConnector(ImmediateConnector connector) {
        Assert.notNull(connector, Assert.iae());
        this.immediateConnectorRegistry.add(connector);
    }

    public Set<FilterObjects> getAllFilterObjects() {
        LinkedHashSet<FilterObjects> all = new LinkedHashSet<FilterObjects>();
        all.addAll(this.annotatedWithFilterObjects);
        all.addAll(this.extendingFilterObjects);
        all.addAll(this.implementingFilterObjects);
        return all;
    }

    public MergableConnector getConnector(TypeFilter typeFilter) {
        Assert.notNull(typeFilter, Assert.iae());
        if (typeFilter instanceof AnnotatedWithTypeFilter) {
            return this.annotatedConnectors.get(typeFilter);
        }
        if (typeFilter instanceof ImplementingTypeFilter) {
            return this.implementingConnectors.get(typeFilter);
        }
        if (typeFilter instanceof ExtendingTypeFilter) {
            return this.extendingConnectors.get(typeFilter);
        }
        if (typeFilter instanceof TypeFilterConjunction) {
            return this.conjunctionConnectors.get(typeFilter);
        }
        if (typeFilter instanceof TypeFilterDisjunction) {
            return this.disjunctionConnectors.get(typeFilter);
        }
        return null;
    }

    public Set<FilterObjects> getExtendingFilterObjects() {
        return this.extendingFilterObjects;
    }

    public FilterObjects getFilterObjects(ResourceMatcher resourceMatcher) {
        Assert.notNull(resourceMatcher, Assert.iae());
        if (resourceMatcher instanceof AnnotatedWithResourceMatcher) {
            return this.getFilterObjects(this.annotatedWithFilterObjects, resourceMatcher);
        }
        if (resourceMatcher instanceof AnnotationArgumentResourceMatcher) {
            return this.getFilterObjects(this.annotationArgumentFilterObjects, resourceMatcher);
        }
        if (resourceMatcher instanceof ExtendingResourceMatcher) {
            return this.getFilterObjects(this.extendingFilterObjects, resourceMatcher);
        }
        if (resourceMatcher instanceof ImplementingResourceMatcher) {
            return this.getFilterObjects(this.implementingFilterObjects, resourceMatcher);
        }
        return null;
    }

    private FilterObjects getFilterObjects(Set<FilterObjects> filterObjectss, ResourceMatcher resourceMatcher) {
        for (FilterObjects filterObjects : filterObjectss) {
            if (!((Object)filterObjects.getResourceMatcher()).equals(resourceMatcher)) continue;
            return filterObjects;
        }
        return null;
    }

    public Iterable<ImmediateConnector> getImmediateConnectors() {
        return this.immediateConnectorRegistry;
    }

    public Set<FilterObjects> getImplementingFilterObjects() {
        return this.implementingFilterObjects;
    }

    public boolean isRegistered(TypeFilter typeFilter) {
        Assert.notNull(typeFilter, Assert.iae());
        if (typeFilter instanceof AnnotatedWithTypeFilter) {
            return this.annotatedConnectors.containsKey(typeFilter);
        }
        if (typeFilter instanceof ImplementingTypeFilter) {
            return this.implementingConnectors.containsKey(typeFilter);
        }
        if (typeFilter instanceof ExtendingTypeFilter) {
            return this.extendingConnectors.containsKey(typeFilter);
        }
        if (typeFilter instanceof TypeFilterConjunction) {
            return this.conjunctionConnectors.containsKey(typeFilter);
        }
        if (typeFilter instanceof TypeFilterDisjunction) {
            return this.disjunctionConnectors.containsKey(typeFilter);
        }
        return false;
    }

    public boolean isRegistered(ResourceMatcher resourceMatcher) {
        Assert.notNull(resourceMatcher, Assert.iae());
        if (resourceMatcher instanceof AnnotatedWithResourceMatcher) {
            return this.getFilterObjects(this.annotatedWithFilterObjects, resourceMatcher) != null;
        }
        if (resourceMatcher instanceof AnnotationArgumentResourceMatcher) {
            return this.getFilterObjects(this.annotationArgumentFilterObjects, resourceMatcher) != null;
        }
        if (resourceMatcher instanceof ExtendingResourceMatcher) {
            return this.getFilterObjects(this.extendingFilterObjects, resourceMatcher) != null;
        }
        if (resourceMatcher instanceof ImplementingResourceMatcher) {
            return this.getFilterObjects(this.implementingFilterObjects, resourceMatcher) != null;
        }
        return false;
    }

    public void register(TypeFilter typeFilter, MergableConnector connector) {
        Assert.notNull(typeFilter, Assert.iae());
        Assert.notNull(connector, Assert.iae());
        if (typeFilter instanceof AnnotatedWithTypeFilter) {
            this.annotatedConnectors.put(typeFilter, connector);
        } else if (typeFilter instanceof ImplementingTypeFilter) {
            this.implementingConnectors.put(typeFilter, connector);
        } else if (typeFilter instanceof ExtendingTypeFilter) {
            this.extendingConnectors.put(typeFilter, connector);
        } else if (typeFilter instanceof TypeFilterConjunction) {
            this.conjunctionConnectors.put(typeFilter, connector);
        } else if (typeFilter instanceof TypeFilterDisjunction) {
            this.disjunctionConnectors.put(typeFilter, connector);
        }
    }

    public void register(FilterObjects filterObjects) {
        Assert.notNull(filterObjects, Assert.iae());
        ResourceMatcher resourceMatcher = filterObjects.getResourceMatcher();
        if (resourceMatcher instanceof AnnotatedWithResourceMatcher) {
            this.annotatedWithFilterObjects.add(filterObjects);
        } else if (resourceMatcher instanceof AnnotationArgumentResourceMatcher) {
            this.annotationArgumentFilterObjects.add(filterObjects);
        } else if (resourceMatcher instanceof ExtendingResourceMatcher) {
            this.extendingFilterObjects.add(filterObjects);
        } else if (resourceMatcher instanceof ImplementingResourceMatcher) {
            this.implementingFilterObjects.add(filterObjects);
        }
    }

    public Filter prependInterceptors(ChainedFilter filter) {
        if (this.filterInterceptors.isEmpty()) {
            return filter;
        }
        LinkedHashSet<FilterInterceptor> filterInterceptors = new LinkedHashSet<FilterInterceptor>();
        for (Class<? extends FilterInterceptor> clazz : this.filterInterceptors) {
            try {
                filterInterceptors.add(clazz.newInstance());
            }
            catch (Exception e) {
                logger.debug(StringUtils.append("Creating a new filter interceptor of ", clazz, " caused an exception"), e);
            }
        }
        if (filterInterceptors.isEmpty()) {
            return filter;
        }
        FilterInterceptor firstInterceptor = null;
        FilterInterceptor currentInterceptor = null;
        for (FilterInterceptor nextInterceptor : filterInterceptors) {
            if (firstInterceptor == null) {
                currentInterceptor = firstInterceptor = nextInterceptor;
                continue;
            }
            currentInterceptor.setInterceptedFilter(nextInterceptor);
            currentInterceptor = nextInterceptor;
        }
        currentInterceptor.setInterceptedFilter(filter);
        return firstInterceptor;
    }

    public void reset() {
        this.annotatedConnectors.clear();
        this.annotatedWithFilterObjects.clear();
        this.annotationArgumentFilterObjects.clear();
        this.conjunctionConnectors.clear();
        this.disjunctionConnectors.clear();
        this.extendingConnectors.clear();
        this.extendingFilterObjects.clear();
        this.filterInterceptors.clear();
        this.immediateConnectorRegistry.clear();
        this.implementingConnectors.clear();
        this.implementingFilterObjects.clear();
    }
}

