/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import net.sf.extcos.internal.URLResource;
import net.sf.extcos.internal.vfs.VfsResourceResolver;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.selector.Package;
import net.sf.extcos.spi.QueryContext;
import net.sf.extcos.spi.ResourceResolver;
import net.sf.extcos.spi.ResourceType;
import net.sf.extcos.util.ReflectionUtils;
import net.sf.extcos.util.ResourceUtils;
import net.sf.extcos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceResolver
implements ResourceResolver {
    private static Logger logger = LoggerFactory.getLogger(DefaultResourceResolver.class);
    private final ClassLoader classLoader = QueryContext.getInstance().getClassLoader();
    private Method equinoxResolveMethod;
    private boolean attemptedToLoadEquinoxResolveMethod = false;

    private Method getEquinoxResolveMethod() {
        if (!this.attemptedToLoadEquinoxResolveMethod && this.equinoxResolveMethod == null) {
            try {
                try {
                    Class<?> fileLocatorClass = this.getClass().getClassLoader().loadClass("org.eclipse.core.runtime.FileLocator");
                    this.equinoxResolveMethod = fileLocatorClass.getMethod("resolve", URL.class);
                    logger.debug("Found Equinox FileLocator for OSGi bundle URL resolution");
                }
                catch (Throwable ex) {
                    this.equinoxResolveMethod = null;
                    this.attemptedToLoadEquinoxResolveMethod = true;
                }
            }
            finally {
                this.attemptedToLoadEquinoxResolveMethod = true;
            }
        }
        return this.equinoxResolveMethod;
    }

    @Override
    public Set<Resource> getResources(Set<ResourceType> resourceTypes, Package basePackage) {
        try {
            Set<URL> rootDirectories = this.getRootDirectories(basePackage);
            HashSet<Resource> resources = new HashSet<Resource>();
            String subPathPattern = basePackage.getSubPathPattern();
            for (URL rootDirectory : rootDirectories) {
                if (ResourceUtils.isJarURL(rootDirectory = this.resolveRootDirectory(rootDirectory))) {
                    resources.addAll(this.findJarResources(resourceTypes, rootDirectory, subPathPattern));
                    continue;
                }
                if (ResourceUtils.isVirtualFileSystemURL(rootDirectory)) {
                    resources.addAll(this.findVFSResources(resourceTypes, rootDirectory, subPathPattern));
                    continue;
                }
                resources.addAll(this.findFileResources(resourceTypes, rootDirectory, subPathPattern));
            }
            return resources;
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    private Set<URL> getRootDirectories(Package basePackage) {
        try {
            Enumeration<URL> urlEnum = this.getClassLoader().getResources(basePackage.getBasePath());
            LinkedHashSet<URL> rootDirectories = new LinkedHashSet<URL>();
            while (urlEnum.hasMoreElements()) {
                rootDirectories.add(urlEnum.nextElement());
            }
            if (logger.isDebugEnabled()) {
                logger.debug(StringUtils.append("Found root directories for base package [", basePackage.getName(), "]: ", rootDirectories));
            }
            return rootDirectories;
        }
        catch (IOException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(StringUtils.append("IOException occurred while trying", " to get the root directories for base package [", basePackage.getName(), "]"), e);
            }
            return Collections.emptySet();
        }
    }

    private ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private URL resolveRootDirectory(URL original) {
        if (this.getEquinoxResolveMethod() != null && original.getProtocol().startsWith("bundle")) {
            return (URL)ReflectionUtils.invokeMethod(this.equinoxResolveMethod, null, new Object[]{original});
        }
        return original;
    }

    private Set<Resource> findJarResources(Set<ResourceType> resourceTypes, URL rootDirectory, String subPathPattern) throws IOException {
        URLConnection con = rootDirectory.openConnection();
        JarFile jarFile = null;
        String jarFileUrl = null;
        String rootEntryPath = null;
        boolean newJarFile = false;
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            jarCon.setUseCaches(false);
            jarFile = jarCon.getJarFile();
            jarFileUrl = jarCon.getJarFileURL().toExternalForm();
            JarEntry jarEntry = jarCon.getJarEntry();
            rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
        } else {
            String urlFile = rootDirectory.getFile();
            int separatorIndex = urlFile.indexOf("!/");
            if (separatorIndex != -1) {
                jarFileUrl = urlFile.substring(0, separatorIndex);
                rootEntryPath = urlFile.substring(separatorIndex + "!/".length());
                jarFile = this.getJarFile(jarFileUrl);
            } else {
                jarFile = new JarFile(urlFile);
                jarFileUrl = urlFile;
                rootEntryPath = "";
            }
            newJarFile = true;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Looking for matching resources in jar file [" + jarFileUrl + "]");
            }
            if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith("/")) {
                rootEntryPath = String.valueOf(rootEntryPath) + "/";
            }
            LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
            Enumeration<JarEntry> entries = jarFile.entries();
            block3: while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!this.isCandidate(entry, rootEntryPath, subPathPattern)) continue;
                String entryPath = entry.getName();
                for (ResourceType resourceType : resourceTypes) {
                    if (!this.matches(entryPath, resourceType)) continue;
                    String relativePath = entryPath.substring(rootEntryPath.length());
                    URL resourceUrl = new URL(rootDirectory, relativePath);
                    resources.add(new URLResource(resourceType, resourceUrl));
                    continue block3;
                }
            }
            LinkedHashSet<Resource> linkedHashSet = resources;
            return linkedHashSet;
        }
        finally {
            if (newJarFile) {
                jarFile.close();
            }
        }
    }

    private JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith("file:")) {
            try {
                return new JarFile(ResourceUtils.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring("file:".length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    private boolean isCandidate(JarEntry entry, String rootEntryPath, String subPathPattern) {
        return !entry.isDirectory() && entry.getName().matches("^" + rootEntryPath + subPathPattern + ".*$");
    }

    private boolean matches(String path, ResourceType resourceType) {
        return path.endsWith(resourceType.getFileSuffix());
    }

    private Set<Resource> findVFSResources(Set<ResourceType> resourceTypes, URL rootDirectory, String subPathPattern) throws IOException {
        return new VfsResourceResolver().findResources(resourceTypes, rootDirectory, subPathPattern);
    }

    private Set<Resource> findFileResources(Set<ResourceType> resourceTypes, URL rootDirectory, String subPathPattern) {
        try {
            File file = ResourceUtils.getFile(rootDirectory).getAbsoluteFile();
            if (file.isDirectory()) {
                String pathPattern = String.valueOf(file.getAbsolutePath().replaceAll("\\\\", "/")) + "/" + subPathPattern;
                return this.doFindFileResources(resourceTypes, file, pathPattern, new HashMap<ResourceType, Pattern>(), new LinkedHashSet<Resource>());
            }
            throw new IOException();
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(StringUtils.append("Cannot search for matching files underneath ", rootDirectory, " because it does not correspond to a directory in the file system"), e);
            }
            return Collections.emptySet();
        }
    }

    private Set<Resource> doFindFileResources(Set<ResourceType> resourceTypes, File root, String pathPattern, HashMap<ResourceType, Pattern> patternCache, Set<Resource> resources) {
        File[] files;
        File[] fileArray = files = root.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Iterator<ResourceType> iterator;
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.doFindFileResources(resourceTypes, file, pathPattern, patternCache, resources);
            } else if (file.isFile() && (iterator = resourceTypes.iterator()).hasNext()) {
                Resource resource;
                ResourceType resourceType = iterator.next();
                Pattern filePattern = patternCache.get(resourceType);
                if (filePattern == null) {
                    filePattern = Pattern.compile("^" + pathPattern + ".*" + resourceType.getFileSuffix() + "$");
                    patternCache.put(resourceType, filePattern);
                }
                if ((resource = this.createResource(file, filePattern, resourceType)) != null) {
                    resources.add(resource);
                }
            }
            ++n2;
        }
        return resources;
    }

    private Resource createResource(File file, Pattern filePattern, ResourceType resourceType) {
        URL resourceUrl;
        if (this.matches(file, filePattern) && (resourceUrl = this.toURL(file)) != null) {
            return new URLResource(resourceType, resourceUrl);
        }
        return null;
    }

    private boolean matches(File file, Pattern filePattern) {
        String filePath = file.getAbsolutePath().replaceAll("\\\\", "/");
        return filePattern.matcher(filePath).matches();
    }

    private URL toURL(File file) {
        try {
            return ResourceUtils.toURL(file);
        }
        catch (MalformedURLException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(StringUtils.append("URL creation failed for: ", file.getAbsolutePath()), e);
            }
            return null;
        }
    }
}

