/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.Set;
import net.sf.extcos.internal.AbstractChainedConnector;
import net.sf.extcos.internal.ArraySet;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.util.StringUtils;

public class DisjunctiveChainedConnector
extends AbstractChainedConnector {
    private final Set<Resource> receivedResources = new ArraySet<Resource>();

    @Override
    public synchronized void connect(Resource resource) {
        if (this.connector == null) {
            this.logger.debug("can't connect: parent connector is not set");
            return;
        }
        if (!this.receivedResources.contains(resource)) {
            this.receivedResources.add(resource);
            this.connector.connect(resource);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(StringUtils.append("successfully dispatched resource ", resource));
            }
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace(StringUtils.append("stopped previously dispatched resource ", resource));
        }
    }
}

