/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.Set;
import net.sf.extcos.filter.Filter;
import net.sf.extcos.filter.MatchingChainedFilter;
import net.sf.extcos.filter.MultiplexingConnector;
import net.sf.extcos.filter.ResourceMatcher;
import net.sf.extcos.filter.ResultSetProvider;
import net.sf.extcos.internal.ArraySet;
import net.sf.extcos.internal.BuildContext;
import net.sf.extcos.util.Assert;

public class FilterObjects {
    private final BuildContext buildContext = BuildContext.getInstance();
    private final Set<FilterObjects> children = new ArraySet<FilterObjects>();
    private final Set<Filter> filters = new ArraySet<Filter>();
    private MatchingChainedFilter filter;
    private MultiplexingConnector dispatcher;
    private ResourceMatcher matcher;
    private ResultSetProvider provider;

    public void addFilterObjects(FilterObjects filterObjects) {
        Assert.notNull(filterObjects, Assert.iae());
        this.children.add(filterObjects);
    }

    public void addAllFilterObjects(Set<FilterObjects> filterObjects) {
        Assert.notEmpty(filterObjects, Assert.iae());
        this.children.addAll(filterObjects);
    }

    public Filter buildFilter() {
        this.filter.setResourceDispatcher(this.dispatcher);
        this.filter.setResourceMatcher(this.matcher);
        if (!this.children.isEmpty()) {
            this.filters.clear();
            for (FilterObjects filterObjects : this.children) {
                this.filters.add(filterObjects.buildFilter());
            }
            this.filter.setChildFilters(this.filters);
            this.filter.setResultSetProvider(this.provider);
        }
        return this.buildContext.prependInterceptors(this.filter);
    }

    public MultiplexingConnector getResourceDispatcher() {
        return this.dispatcher;
    }

    public ResourceMatcher getResourceMatcher() {
        return this.matcher;
    }

    public void setFilter(MatchingChainedFilter filter) {
        Assert.notNull(filter, Assert.iae());
        this.filter = filter;
    }

    public void setResourceDispatcher(MultiplexingConnector dispatcher) {
        Assert.notNull(dispatcher, Assert.iae());
        this.dispatcher = dispatcher;
    }

    public void setResourceMatcher(ResourceMatcher matcher) {
        Assert.notNull(matcher, Assert.iae());
        this.matcher = matcher;
    }

    public void setResultSetProvider(ResultSetProvider provider) {
        Assert.notNull(provider, Assert.iae());
        this.provider = provider;
    }
}

