/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.extcos.util.Assert;
import net.sf.extcos.util.StringUtils;

public class ThreadManager {
    private static ThreadManager instance;
    private final AtomicInteger registered = new AtomicInteger();
    private final AtomicInteger invoked = new AtomicInteger();
    private final AtomicInteger finished = new AtomicInteger();
    private ThreadPoolExecutor executor;
    private final Object sync = new Object();

    private ThreadManager() {
    }

    public static ThreadManager getInstance() {
        if (instance == null) {
            instance = new ThreadManager();
        }
        return instance;
    }

    public void register() {
        this.registered.incrementAndGet();
    }

    public void invoke(Runnable runnable) {
        Assert.isTrue(this.invoked.get() < this.registered.get(), Assert.ise());
        Assert.notNull(runnable, Assert.iae());
        this.invoked.incrementAndGet();
        if (this.invoked.get() == 1) {
            this.invokeBlocking(runnable);
        } else {
            this.invokeNonBlocking(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeBlocking(Runnable runnable) {
        Thread t = new Thread(runnable, StringUtils.append("eXtcos managed thread ", this.invoked));
        t.setDaemon(true);
        t.start();
        while (t.isAlive()) {
            try {
                t.join();
            }
            catch (InterruptedException ignored) {}
        }
        this.finished.incrementAndGet();
        while (this.finished.get() < this.registered.get()) {
            try {
                Object ignored = this.sync;
                synchronized (ignored) {
                    this.sync.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    private void invokeNonBlocking(final Runnable runnable) {
        this.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                runnable.run();
                ThreadManager.this.finished.incrementAndGet();
                Object object = ThreadManager.this.sync;
                synchronized (object) {
                    ThreadManager.this.sync.notify();
                }
            }
        });
    }

    private ThreadPoolExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
            this.executor.setCorePoolSize(5 > this.registered.get() ? this.registered.get() : 5);
            this.executor.setMaximumPoolSize(10);
            this.executor.setThreadFactory(new ThreadFactory(){
                private ThreadGroup threadGroup;

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(this.getThreadGroup(), runnable, StringUtils.append("eXtcos managed thread ", ThreadManager.this.getInvoked()));
                    thread.setDaemon(true);
                    return thread;
                }

                private ThreadGroup getThreadGroup() {
                    if (this.threadGroup == null) {
                        this.threadGroup = new ThreadGroup("eXtcos Thread Group");
                        this.threadGroup.setDaemon(true);
                    }
                    return this.threadGroup;
                }
            });
            this.executor.prestartCoreThread();
        }
        return this.executor;
    }

    private int getInvoked() {
        return this.invoked.get();
    }
}

