/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal.vfs;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.extcos.internal.URLResource;
import net.sf.extcos.internal.vfs.VfsUtils;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.spi.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VfsResourceResolver
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(VfsResourceResolver.class);
    private String rootPath;
    private Set<ResourceType> resourceTypes;
    private String subPathPattern;
    private final Set<Resource> resources = new LinkedHashSet<Resource>();

    public Set<Resource> findResources(Set<ResourceType> resourceTypes, URL rootDirectory, String subPathPattern) throws IOException {
        Object root = VfsUtils.getRoot(rootDirectory);
        this.setRootPath(VfsUtils.getPath(root));
        this.resourceTypes = resourceTypes;
        this.subPathPattern = subPathPattern;
        VfsUtils.visit(root, this);
        return this.resources;
    }

    private void setRootPath(String path) {
        this.rootPath = path.length() == 0 || path.endsWith("/") ? path : path + "/";
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (Object.class.equals(method.getDeclaringClass())) {
            if (methodName.equals("equals")) {
                return proxy == args[0];
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
        } else {
            if ("getAttributes".equals(methodName)) {
                return this.getAttributes();
            }
            if ("visit".equals(methodName)) {
                this.visit(args[0]);
                return null;
            }
            if ("toString".equals(methodName)) {
                return this.toString();
            }
        }
        throw new IllegalStateException("Unexpected method invocation: " + method);
    }

    private Object getAttributes() {
        return VfsUtils.getVisitorAttribute();
    }

    private void visit(Object vfsResource) {
        String resourcePath = this.getResourcePath(vfsResource);
        if (!resourcePath.matches("^" + this.rootPath + this.subPathPattern + ".*$")) {
            return;
        }
        for (ResourceType resourceType : this.resourceTypes) {
            if (!resourcePath.endsWith(resourceType.getFileSuffix())) continue;
            try {
                URL resourceUrl = VfsUtils.getURL(vfsResource);
                this.resources.add(new URLResource(resourceType, resourceUrl));
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("couldn't resolve the URL for " + vfsResource, e);
            }
        }
    }

    private String getResourcePath(Object vfsResource) {
        return VfsUtils.getPath(vfsResource);
    }
}

