/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.selector;

import java.util.Set;
import net.sf.extcos.internal.ArraySet;
import net.sf.extcos.selector.ForwardingBuilder;
import net.sf.extcos.selector.Package;
import net.sf.extcos.util.Assert;

public class BasePackageSelector {
    private final Set<Package> basePackages = new ArraySet<Package>();
    private final ForwardingBuilder forwardingBuilder = new ForwardingBuilder();
    private Boolean includingEnums;

    public ForwardingBuilder from(String ... basePackages) {
        Assert.notEmpty(basePackages, IllegalArgumentException.class, "there must be at least one basePackage set");
        String[] stringArray = basePackages;
        int n = basePackages.length;
        int n2 = 0;
        while (n2 < n) {
            String basePackage = stringArray[n2];
            this.basePackages.add(new Package(basePackage));
            ++n2;
        }
        if (this.includingEnums == null) {
            this.includingEnums = false;
        }
        return this.forwardingBuilder;
    }

    public BasePackageSelector includingEnums() {
        if (this.includingEnums == null) {
            this.includingEnums = true;
            return this;
        }
        throw new IllegalStateException("includingEnums must not be called more than once!");
    }

    public Set<Package> getBasePackages() {
        return this.basePackages;
    }

    public ForwardingBuilder getForwardingBuilder() {
        return this.forwardingBuilder;
    }

    public boolean isIncludingEnums() {
        return this.includingEnums != null && this.includingEnums != false;
    }
}

