/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;

public class AppendingTransformer
implements ResourceTransformer {
    String resource;
    ByteArrayOutputStream data = new ByteArrayOutputStream();

    @Override
    public boolean canTransformResource(String r) {
        return this.resource != null && this.resource.equalsIgnoreCase(r);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        IOUtil.copy(is, (OutputStream)this.data);
        this.data.write(10);
    }

    @Override
    public boolean hasTransformedResource() {
        return this.data.size() > 0;
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        jos.putNextEntry(new JarEntry(this.resource));
        IOUtil.copy((InputStream)new ByteArrayInputStream(this.data.toByteArray()), (OutputStream)jos);
        this.data.reset();
    }
}

