/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.project.deploy.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.transfer.artifact.deploy.ArtifactDeployer;
import org.apache.maven.shared.transfer.artifact.deploy.ArtifactDeployerException;
import org.apache.maven.shared.transfer.project.NoFileAssignedException;
import org.apache.maven.shared.transfer.project.deploy.ProjectDeployer;
import org.apache.maven.shared.transfer.project.deploy.ProjectDeployerRequest;
import org.apache.maven.shared.transfer.project.deploy.internal.DualDigester;
import org.apache.maven.shared.transfer.repository.RepositoryManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ProjectDeployer.class)
class DefaultProjectDeployer
implements ProjectDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProjectDeployer.class);
    @Requirement
    private ArtifactDeployer deployer;
    @Requirement
    private RepositoryManager repositoryManager;
    private final DualDigester digester = new DualDigester();

    DefaultProjectDeployer() {
    }

    @Override
    public void deploy(ProjectBuildingRequest buildingRequest, ProjectDeployerRequest projectDeployerRequest, ArtifactRepository artifactRepository) throws NoFileAssignedException, IllegalArgumentException, ArtifactDeployerException {
        this.validateParameters(buildingRequest, projectDeployerRequest, artifactRepository);
        Artifact artifact = projectDeployerRequest.getProject().getArtifact();
        String packaging = projectDeployerRequest.getProject().getPackaging();
        File pomFile = projectDeployerRequest.getProject().getFile();
        List<Artifact> attachedArtifacts = projectDeployerRequest.getProject().getAttachedArtifacts();
        boolean isPomArtifact = "pom".equals(packaging);
        if (isPomArtifact) {
            artifact.setFile(pomFile);
        } else {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pomFile);
            artifact.addMetadata(metadata);
        }
        artifact.setRepository(artifactRepository);
        int retryFailedDeploymentCount = projectDeployerRequest.getRetryFailedDeploymentCount();
        ArrayList<Artifact> deployableArtifacts = new ArrayList<Artifact>();
        if (isPomArtifact) {
            deployableArtifacts.add(artifact);
        } else {
            File file = artifact.getFile();
            if (file != null && file.isFile()) {
                deployableArtifacts.add(artifact);
            } else {
                if (!attachedArtifacts.isEmpty()) {
                    throw new NoFileAssignedException("The packaging plugin for this project did not assign a main file to the project but it has attachments. Change packaging to 'pom'.");
                }
                throw new NoFileAssignedException("The packaging for this project did not assign a file to the build artifact");
            }
        }
        for (Artifact attached : attachedArtifacts) {
            deployableArtifacts.add(attached);
        }
        this.installChecksumsForAllArtifacts(buildingRequest, deployableArtifacts);
        this.deploy(buildingRequest, deployableArtifacts, artifactRepository, retryFailedDeploymentCount);
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, ProjectDeployerRequest projectDeployerRequest, ArtifactRepository artifactRepository) {
        if (buildingRequest == null) {
            throw new IllegalArgumentException("The parameter buildingRequest is not allowed to be null.");
        }
        if (projectDeployerRequest == null) {
            throw new IllegalArgumentException("The parameter projectDeployerRequest is not allowed to be null.");
        }
        if (artifactRepository == null) {
            throw new IllegalArgumentException("The parameter artifactRepository is not allowed to be null.");
        }
    }

    private void installChecksumsForAllArtifacts(ProjectBuildingRequest request, Collection<Artifact> artifacts) {
        for (Artifact item : artifacts) {
            try {
                LOGGER.debug("Installing checksum for " + item.getId());
                this.installChecksums(request, item);
            }
            catch (IOException e) {
                LOGGER.error("Failure during checksum generation for " + item.getId());
            }
        }
    }

    private void deploy(ProjectBuildingRequest request, Collection<Artifact> artifacts, ArtifactRepository deploymentRepository, int retryFailedDeploymentCount) throws ArtifactDeployerException {
        int retryFailedDeploymentCounter = Math.max(1, Math.min(10, retryFailedDeploymentCount));
        ArtifactDeployerException exception = null;
        for (int count = 0; count < retryFailedDeploymentCounter; ++count) {
            try {
                if (count > 0) {
                    LOGGER.info("Retrying deployment attempt " + (count + 1) + " of " + retryFailedDeploymentCounter);
                }
                this.deployer.deploy(request, deploymentRepository, artifacts);
                exception = null;
                break;
            }
            catch (ArtifactDeployerException e) {
                if (count + 1 < retryFailedDeploymentCounter) {
                    LOGGER.warn("Encountered issue during deployment: " + e.getLocalizedMessage());
                    LOGGER.debug(e.getMessage());
                }
                if (exception != null) continue;
                exception = e;
                continue;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void installChecksums(ProjectBuildingRequest buildingRequest, Artifact artifact) throws IOException {
        File artifactFile = this.getLocalRepoFile(buildingRequest, artifact);
        this.installChecksums(artifactFile);
    }

    private void installChecksums(Collection<File> metadataFiles) throws IOException {
        for (File metadataFile : metadataFiles) {
            this.installChecksums(metadataFile);
        }
    }

    private void installChecksums(File installedFile) throws IOException {
        boolean signatureFile = installedFile.getName().endsWith(".asc");
        if (installedFile.isFile() && !signatureFile) {
            LOGGER.debug("Calculating checksums for " + installedFile);
            this.digester.calculate(installedFile);
            this.installChecksum(installedFile, ".md5", this.digester.getMd5());
            this.installChecksum(installedFile, ".sha1", this.digester.getSha1());
        }
    }

    private void installChecksum(File installedFile, String ext, String checksum) throws IOException {
        File checksumFile = new File(installedFile.getAbsolutePath() + ext);
        LOGGER.debug("Installing checksum to " + checksumFile);
        try {
            checksumFile.getParentFile().mkdirs();
            FileUtils.fileWrite(checksumFile.getAbsolutePath(), "UTF-8", checksum);
        }
        catch (IOException e) {
            throw new IOException("Failed to install checksum to " + checksumFile, e);
        }
    }

    private File getLocalRepoFile(ProjectBuildingRequest buildingRequest, Artifact artifact) {
        String path = this.repositoryManager.getPathForLocalArtifact(buildingRequest, artifact);
        return new File(this.repositoryManager.getLocalRepositoryBasedir(buildingRequest), path);
    }

    private File getLocalRepoFile(ProjectBuildingRequest buildingRequest, ArtifactMetadata metadata) {
        String path = this.repositoryManager.getPathForLocalMetadata(buildingRequest, metadata);
        return new File(this.repositoryManager.getLocalRepositoryBasedir(buildingRequest), path);
    }
}

