/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.lang.annotation.Annotation;
import java.util.Set;
import net.sf.extcos.filter.Connector;
import net.sf.extcos.filter.ResultSetProvider;
import net.sf.extcos.internal.AbstractFilterObjectsBuilder;
import net.sf.extcos.internal.AnnotatedWithResourceMatcher;
import net.sf.extcos.internal.AnnotatedWithTypeFilterImpl;
import net.sf.extcos.internal.AnnotationArgumentResourceMatcher;
import net.sf.extcos.internal.ConjunctiveChainedConnector;
import net.sf.extcos.internal.DisjunctiveChainedConnector;
import net.sf.extcos.internal.FilterObjects;
import net.sf.extcos.internal.StandardMultiplexingConnector;
import net.sf.extcos.internal.StandardResultSetProvider;
import net.sf.extcos.selector.AnnotatedWithTypeFilter;
import net.sf.extcos.selector.TypeFilter;
import net.sf.extcos.selector.annotation.AnnotationArgument;
import net.sf.extcos.selector.annotation.ArgumentMapping;
import net.sf.extcos.selector.annotation.ArgumentMappingConjunction;
import net.sf.extcos.selector.annotation.ArgumentMappingJunction;
import net.sf.extcos.selector.annotation.ArgumentsDescriptor;
import net.sf.extcos.util.Assert;

public class AnnotatedWithFilterObjectsBuilder
extends AbstractFilterObjectsBuilder {
    private final ResultSetProvider provider = new StandardResultSetProvider();

    @Override
    public void buildFilterObjects(TypeFilter filter, Connector connector) {
        Assert.notNull(filter, Assert.iae());
        Assert.isTrue(filter instanceof AnnotatedWithTypeFilter, Assert.iae());
        Assert.notNull(connector, Assert.iae());
        AnnotatedWithTypeFilter awtf = (AnnotatedWithTypeFilter)filter;
        ArgumentsDescriptor arguments = awtf.getArguments();
        if (arguments == null) {
            this.buildFilterObjects(awtf.getAnnotation(), connector);
        } else {
            this.buildFilterObjects(awtf.getAnnotation(), arguments, connector);
        }
    }

    private void buildFilterObjects(Class<? extends Annotation> annotation, Connector connector) {
        AnnotatedWithResourceMatcher matcher = new AnnotatedWithResourceMatcher(annotation);
        if (this.buildContext.isRegistered(matcher)) {
            FilterObjects fo = this.buildContext.getFilterObjects(matcher);
            fo.getResourceDispatcher().addConnector(connector);
        } else {
            StandardMultiplexingConnector dispatcher = new StandardMultiplexingConnector();
            dispatcher.addConnector(connector);
            FilterObjects filterObjects = this.createFilterObjects(dispatcher, matcher, this.provider);
            AnnotatedWithTypeFilterImpl filter = new AnnotatedWithTypeFilterImpl(annotation, null);
            this.buildContext.register(filter, dispatcher);
            this.buildContext.register(filterObjects);
        }
    }

    private void buildFilterObjects(Class<? extends Annotation> annotation, ArgumentsDescriptor arguments, Connector connector) {
        ConjunctiveChainedConnector conjunction = new ConjunctiveChainedConnector();
        conjunction.setParentConnector(connector);
        conjunction.setChildCount(2);
        this.buildFilterObjects(annotation, (Connector)conjunction);
        ArgumentMapping mapping = arguments.getArgumentMapping();
        if (mapping instanceof ArgumentMappingConjunction) {
            this.buildFilterObjects(annotation, (ArgumentMappingConjunction)mapping, (Connector)conjunction);
        } else if (mapping instanceof ArgumentMappingJunction) {
            this.buildFilterObjects(annotation, (ArgumentMappingJunction)mapping, (Connector)conjunction);
        } else {
            this.buildFilterObjects(annotation, mapping, connector);
        }
    }

    private void buildFilterObjects(Class<? extends Annotation> annotation, ArgumentMapping mapping, Connector connector) {
        AnnotatedWithTypeFilterImpl filter = new AnnotatedWithTypeFilterImpl(annotation, new ArgumentsDescriptor(mapping));
        if (this.buildContext.isRegistered(filter)) {
            this.buildContext.getConnector(filter).merge(connector);
            return;
        }
        AnnotationArgumentResourceMatcher matcher = new AnnotationArgumentResourceMatcher(new AnnotationArgument(annotation, mapping));
        if (this.buildContext.isRegistered(matcher)) {
            FilterObjects fo = this.buildContext.getFilterObjects(matcher);
            fo.getResourceDispatcher().addConnector(connector);
        } else {
            StandardMultiplexingConnector dispatcher = new StandardMultiplexingConnector();
            dispatcher.addConnector(connector);
            FilterObjects filterObjects = this.createFilterObjects(dispatcher, matcher, this.provider);
            this.buildContext.register(filter, dispatcher);
            this.buildContext.register(filterObjects);
        }
    }

    private void buildFilterObjects(Class<? extends Annotation> annotation, ArgumentMappingConjunction mappingConjunction, Connector connector) {
        AnnotatedWithTypeFilterImpl filter = new AnnotatedWithTypeFilterImpl(annotation, new ArgumentsDescriptor(mappingConjunction));
        if (this.buildContext.isRegistered(filter)) {
            this.buildContext.getConnector(filter).merge(connector);
            return;
        }
        Set<ArgumentMapping> mappings = mappingConjunction.getMappings();
        ConjunctiveChainedConnector conjunction = new ConjunctiveChainedConnector();
        conjunction.setParentConnector(connector);
        conjunction.setChildCount(mappings.size());
        for (ArgumentMapping mapping : mappings) {
            if (mapping instanceof ArgumentMappingConjunction) {
                this.buildFilterObjects(annotation, (ArgumentMappingConjunction)mapping, (Connector)conjunction);
                continue;
            }
            if (mapping instanceof ArgumentMappingJunction) {
                this.buildFilterObjects(annotation, (ArgumentMappingJunction)mapping, (Connector)conjunction);
                continue;
            }
            this.buildFilterObjects(annotation, mapping, connector);
        }
        this.buildContext.register(filter, conjunction);
    }

    private void buildFilterObjects(Class<? extends Annotation> annotation, ArgumentMappingJunction mappingDisjunction, Connector connector) {
        AnnotatedWithTypeFilterImpl filter = new AnnotatedWithTypeFilterImpl(annotation, new ArgumentsDescriptor(mappingDisjunction));
        if (this.buildContext.isRegistered(filter)) {
            this.buildContext.getConnector(filter).merge(connector);
            return;
        }
        Set<ArgumentMapping> mappings = mappingDisjunction.getMappings();
        DisjunctiveChainedConnector disjunction = new DisjunctiveChainedConnector();
        disjunction.setParentConnector(connector);
        disjunction.setChildCount(mappings.size());
        for (ArgumentMapping mapping : mappings) {
            if (mapping instanceof ArgumentMappingConjunction) {
                this.buildFilterObjects(annotation, (ArgumentMappingConjunction)mapping, (Connector)disjunction);
                continue;
            }
            if (mapping instanceof ArgumentMappingJunction) {
                this.buildFilterObjects(annotation, (ArgumentMappingJunction)mapping, (Connector)disjunction);
                continue;
            }
            this.buildFilterObjects(annotation, mapping, connector);
        }
        this.buildContext.register(filter, disjunction);
    }
}

