/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import net.sf.extcos.exception.ConcurrentInspectionException;
import net.sf.extcos.filter.ResourceMatcher;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.util.Assert;

public class ImplementingResourceMatcher
implements ResourceMatcher {
    private final Class<?> interfaze;

    public ImplementingResourceMatcher(Class<?> interfaze) {
        Assert.notNull(interfaze, IllegalArgumentException.class);
        Assert.isTrue(interfaze.isInterface(), IllegalArgumentException.class);
        this.interfaze = interfaze;
    }

    @Override
    public boolean matches(Resource resource) throws ConcurrentInspectionException {
        Assert.notNull(resource, IllegalArgumentException.class);
        return resource.hasInterface(this.interfaze);
    }

    @Override
    public boolean isMatcherFor(Object obj) {
        return this.interfaze.equals(obj);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.interfaze == null ? 0 : this.interfaze.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImplementingResourceMatcher other = (ImplementingResourceMatcher)obj;
        return !(this.interfaze == null ? other.interfaze != null : !this.interfaze.equals(other.interfaze));
    }
}

