/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.selector;

import net.sf.extcos.util.Assert;
import net.sf.extcos.util.StringUtils;

public class PackagePatternBuilder {
    private String subPackagePattern;

    public PackagePatternBuilder(String subPackagePattern) {
        Assert.isTrue(StringUtils.isJavaPackageWithWildcards(subPackagePattern), Assert.iae(), "subPackagePattern must be a valid Java Package name which may include wildcards, but [" + subPackagePattern + "] isn't!");
        this.subPackagePattern = subPackagePattern;
    }

    public String[] in(String ... rootPackages) {
        Assert.notEmpty(rootPackages, Assert.iae(), "rootPackages must not be empty");
        String[] packagePatterns = new String[rootPackages.length];
        int i = 0;
        for (String rootPackage : rootPackages) {
            Assert.isTrue(StringUtils.isJavaPackage(rootPackage), Assert.iae(), "Any string contained in rootPackages must be a valid Java Package, but [" + rootPackage + "] isn't!");
            packagePatterns[i++] = rootPackage + "." + this.subPackagePattern;
        }
        return packagePatterns;
    }
}

