/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.util;

import java.lang.reflect.Field;

public class PropertyInjector {
    private Object target;

    public void inject(String name, Object value) throws NoSuchFieldException {
        if (this.target == null) {
            throw new IllegalStateException("The target has not been set");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name must have one character at least");
        }
        if (value == null) {
            throw new IllegalArgumentException("The value must not be null");
        }
        for (Class<?> clazz = this.target.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!field.getName().equals(name)) continue;
                try {
                    boolean accessible = field.isAccessible();
                    field.setAccessible(true);
                    field.set(this.target, value);
                    field.setAccessible(accessible);
                    return;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        throw new NoSuchFieldException("For the current target " + this.target + " no property called " + name + " could be found for which the " + "reference " + value + " could be set");
    }

    public void injectIfPossible(String name, Object value) {
        try {
            this.inject(name, value);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public void setTarget(Object target) {
        this.target = target;
    }
}

