/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Authentication {
    private final String username;
    private final String password;
    private final String privateKeyFile;
    private final String passphrase;

    public Authentication(String username, String password, String privateKeyFile, String passphrase) {
        this.username = username;
        this.password = password;
        this.privateKeyFile = privateKeyFile;
        this.passphrase = passphrase;
    }

    public Authentication(String username, String password) {
        this(username, password, null, null);
    }

    public String getUsername() {
        return this.username;
    }

    public Authentication setUsername(String username) {
        if (Authentication.eq(this.username, username)) {
            return this;
        }
        return new Authentication(username, this.password, this.privateKeyFile, this.passphrase);
    }

    public String getPassword() {
        return this.password;
    }

    public Authentication setPassword(String password) {
        if (Authentication.eq(this.password, password)) {
            return this;
        }
        return new Authentication(this.username, password, this.privateKeyFile, this.passphrase);
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public Authentication setPrivateKeyFile(String privateKeyFile) {
        if (Authentication.eq(this.privateKeyFile, privateKeyFile)) {
            return this;
        }
        return new Authentication(this.username, this.password, privateKeyFile, this.passphrase);
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public Authentication setPassphrase(String passphrase) {
        if (Authentication.eq(this.passphrase, passphrase)) {
            return this;
        }
        return new Authentication(this.username, this.password, this.privateKeyFile, passphrase);
    }

    public String toString() {
        return this.getUsername();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Authentication that = (Authentication)obj;
        return Authentication.eq(this.username, that.username) && Authentication.eq(this.password, that.password) && Authentication.eq(this.privateKeyFile, that.privateKeyFile) && Authentication.eq(this.passphrase, this.passphrase);
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + Authentication.hash(this.username);
        hash = hash * 31 + Authentication.hash(this.password);
        hash = hash * 31 + Authentication.hash(this.privateKeyFile);
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

