/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.versioning.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArtifactUtils {
    public static boolean isSnapshot(String version) {
        if (version != null) {
            if (version.regionMatches(true, version.length() - "SNAPSHOT".length(), "SNAPSHOT", 0, "SNAPSHOT".length())) {
                return true;
            }
            if (Artifact.VERSION_FILE_PATTERN.matcher(version).matches()) {
                return true;
            }
        }
        return false;
    }

    public static String toSnapshotVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("version: null");
        }
        Matcher m3 = Artifact.VERSION_FILE_PATTERN.matcher(version);
        if (m3.matches()) {
            return m3.group(1) + "-" + "SNAPSHOT";
        }
        return version;
    }

    public static String versionlessKey(Artifact artifact) {
        return ArtifactUtils.versionlessKey(artifact.getGroupId(), artifact.getArtifactId());
    }

    public static String versionlessKey(String groupId, String artifactId) {
        if (groupId == null) {
            throw new NullPointerException("groupId is null");
        }
        if (artifactId == null) {
            throw new NullPointerException("artifactId is null");
        }
        return groupId + ":" + artifactId;
    }

    public static String key(Artifact artifact) {
        return ArtifactUtils.key(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    public static String key(String groupId, String artifactId, String version) {
        if (groupId == null) {
            throw new NullPointerException("groupId is null");
        }
        if (artifactId == null) {
            throw new NullPointerException("artifactId is null");
        }
        if (version == null) {
            throw new NullPointerException("version is null");
        }
        return groupId + ":" + artifactId + ":" + version;
    }

    public static Map<String, Artifact> artifactMapByVersionlessId(Collection<Artifact> artifacts) {
        LinkedHashMap<String, Artifact> artifactMap = new LinkedHashMap<String, Artifact>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                artifactMap.put(ArtifactUtils.versionlessKey(artifact), artifact);
            }
        }
        return artifactMap;
    }

    public static Artifact copyArtifactSafe(Artifact artifact) {
        return artifact != null ? ArtifactUtils.copyArtifact(artifact) : null;
    }

    public static Artifact copyArtifact(Artifact artifact) {
        VersionRange range = artifact.getVersionRange();
        if (range == null) {
            range = VersionRange.createFromVersion(artifact.getVersion());
        }
        DefaultArtifact clone = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), range.cloneOf(), artifact.getScope(), artifact.getType(), artifact.getClassifier(), artifact.getArtifactHandler(), artifact.isOptional());
        clone.setRelease(artifact.isRelease());
        clone.setResolvedVersion(artifact.getVersion());
        clone.setResolved(artifact.isResolved());
        clone.setFile(artifact.getFile());
        clone.setAvailableVersions(ArtifactUtils.copyList(artifact.getAvailableVersions()));
        if (artifact.getVersion() != null) {
            clone.setBaseVersion(artifact.getBaseVersion());
        }
        clone.setDependencyFilter(artifact.getDependencyFilter());
        clone.setDependencyTrail(ArtifactUtils.copyList(artifact.getDependencyTrail()));
        clone.setDownloadUrl(artifact.getDownloadUrl());
        clone.setRepository(artifact.getRepository());
        return clone;
    }

    public static <T extends Collection<Artifact>> T copyArtifacts(Collection<Artifact> from, T to) {
        for (Artifact artifact : from) {
            to.add((Artifact)ArtifactUtils.copyArtifact(artifact));
        }
        return to;
    }

    public static <K, T extends Map<K, Artifact>> T copyArtifacts(Map<K, ? extends Artifact> from, T to) {
        if (from != null) {
            for (Map.Entry<K, Artifact> entry : from.entrySet()) {
                to.put(entry.getKey(), (Artifact)ArtifactUtils.copyArtifact(entry.getValue()));
            }
        }
        return to;
    }

    private static <T> List<T> copyList(List<T> original) {
        ArrayList<T> copy = null;
        if (original != null) {
            copy = new ArrayList<T>();
            if (!original.isEmpty()) {
                copy.addAll(original);
            }
        }
        return copy;
    }
}

