/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import java.util.Arrays;
import java.util.List;
import org.sonatype.guice.bean.binders.ElementAnalyzer;
import org.sonatype.guice.bean.binders.ImportBinder;
import org.sonatype.guice.bean.converters.FileTypeConverter;
import org.sonatype.guice.bean.converters.URLTypeConverter;
import org.sonatype.guice.bean.locators.HiddenSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WireModule
implements Module {
    private static final HiddenSource HIDDEN_SOURCE = new HiddenSource(){

        public String toString() {
            return ImportBinder.class.getName();
        }
    };
    private final List<Module> modules;

    public WireModule(Module ... modules) {
        this.modules = Arrays.asList(modules);
    }

    public WireModule(List<Module> modules) {
        this.modules = modules;
    }

    @Override
    public void configure(Binder binder) {
        binder.install(new FileTypeConverter());
        binder.install(new URLTypeConverter());
        ElementAnalyzer analyzer = new ElementAnalyzer(binder);
        for (Module m3 : this.modules) {
            for (Element e : Elements.getElements(m3)) {
                e.acceptVisitor(analyzer);
            }
        }
        new ImportBinder(binder.withSource(HIDDEN_SOURCE)).bind(analyzer.getImportedKeys());
    }
}

