/*
 * Decompiled with CFR 0.152.
 */
package cfjapa.parser.ast.visitor;

import cfjapa.parser.ast.BlockComment;
import cfjapa.parser.ast.CompilationUnit;
import cfjapa.parser.ast.ImportDeclaration;
import cfjapa.parser.ast.IndexUnit;
import cfjapa.parser.ast.LineComment;
import cfjapa.parser.ast.Node;
import cfjapa.parser.ast.PackageDeclaration;
import cfjapa.parser.ast.TypeParameter;
import cfjapa.parser.ast.body.AnnotationDeclaration;
import cfjapa.parser.ast.body.AnnotationMemberDeclaration;
import cfjapa.parser.ast.body.ClassOrInterfaceDeclaration;
import cfjapa.parser.ast.body.ConstructorDeclaration;
import cfjapa.parser.ast.body.EmptyMemberDeclaration;
import cfjapa.parser.ast.body.EmptyTypeDeclaration;
import cfjapa.parser.ast.body.EnumConstantDeclaration;
import cfjapa.parser.ast.body.EnumDeclaration;
import cfjapa.parser.ast.body.FieldDeclaration;
import cfjapa.parser.ast.body.InitializerDeclaration;
import cfjapa.parser.ast.body.JavadocComment;
import cfjapa.parser.ast.body.MethodDeclaration;
import cfjapa.parser.ast.body.Parameter;
import cfjapa.parser.ast.body.VariableDeclarator;
import cfjapa.parser.ast.body.VariableDeclaratorId;
import cfjapa.parser.ast.expr.ArrayAccessExpr;
import cfjapa.parser.ast.expr.ArrayCreationExpr;
import cfjapa.parser.ast.expr.ArrayInitializerExpr;
import cfjapa.parser.ast.expr.AssignExpr;
import cfjapa.parser.ast.expr.BinaryExpr;
import cfjapa.parser.ast.expr.BooleanLiteralExpr;
import cfjapa.parser.ast.expr.CastExpr;
import cfjapa.parser.ast.expr.CharLiteralExpr;
import cfjapa.parser.ast.expr.ClassExpr;
import cfjapa.parser.ast.expr.ConditionalExpr;
import cfjapa.parser.ast.expr.DoubleLiteralExpr;
import cfjapa.parser.ast.expr.EnclosedExpr;
import cfjapa.parser.ast.expr.FieldAccessExpr;
import cfjapa.parser.ast.expr.InstanceOfExpr;
import cfjapa.parser.ast.expr.IntegerLiteralExpr;
import cfjapa.parser.ast.expr.IntegerLiteralMinValueExpr;
import cfjapa.parser.ast.expr.LongLiteralExpr;
import cfjapa.parser.ast.expr.LongLiteralMinValueExpr;
import cfjapa.parser.ast.expr.MarkerAnnotationExpr;
import cfjapa.parser.ast.expr.MemberValuePair;
import cfjapa.parser.ast.expr.MethodCallExpr;
import cfjapa.parser.ast.expr.NameExpr;
import cfjapa.parser.ast.expr.NormalAnnotationExpr;
import cfjapa.parser.ast.expr.NullLiteralExpr;
import cfjapa.parser.ast.expr.ObjectCreationExpr;
import cfjapa.parser.ast.expr.QualifiedNameExpr;
import cfjapa.parser.ast.expr.SingleMemberAnnotationExpr;
import cfjapa.parser.ast.expr.StringLiteralExpr;
import cfjapa.parser.ast.expr.SuperExpr;
import cfjapa.parser.ast.expr.ThisExpr;
import cfjapa.parser.ast.expr.UnaryExpr;
import cfjapa.parser.ast.expr.VariableDeclarationExpr;
import cfjapa.parser.ast.stmt.AssertStmt;
import cfjapa.parser.ast.stmt.BlockStmt;
import cfjapa.parser.ast.stmt.BreakStmt;
import cfjapa.parser.ast.stmt.CatchClause;
import cfjapa.parser.ast.stmt.ContinueStmt;
import cfjapa.parser.ast.stmt.DoStmt;
import cfjapa.parser.ast.stmt.EmptyStmt;
import cfjapa.parser.ast.stmt.ExplicitConstructorInvocationStmt;
import cfjapa.parser.ast.stmt.ExpressionStmt;
import cfjapa.parser.ast.stmt.ForStmt;
import cfjapa.parser.ast.stmt.ForeachStmt;
import cfjapa.parser.ast.stmt.IfStmt;
import cfjapa.parser.ast.stmt.LabeledStmt;
import cfjapa.parser.ast.stmt.ReturnStmt;
import cfjapa.parser.ast.stmt.SwitchEntryStmt;
import cfjapa.parser.ast.stmt.SwitchStmt;
import cfjapa.parser.ast.stmt.SynchronizedStmt;
import cfjapa.parser.ast.stmt.ThrowStmt;
import cfjapa.parser.ast.stmt.TryStmt;
import cfjapa.parser.ast.stmt.TypeDeclarationStmt;
import cfjapa.parser.ast.stmt.WhileStmt;
import cfjapa.parser.ast.type.ClassOrInterfaceType;
import cfjapa.parser.ast.type.PrimitiveType;
import cfjapa.parser.ast.type.ReferenceType;
import cfjapa.parser.ast.type.VoidType;
import cfjapa.parser.ast.type.WildcardType;
import cfjapa.parser.ast.visitor.GenericVisitor;
import java.util.List;

public class EqualsVisitor
implements GenericVisitor<Boolean, Node> {
    private static final EqualsVisitor SINGLETON = new EqualsVisitor();

    public static boolean equals(Node node, Node node2) {
        return SINGLETON.nodeEquals(node, node2);
    }

    private EqualsVisitor() {
    }

    private <T extends Node> boolean nodesEquals(List<T> list, List<T> list2) {
        if (list == null) {
            return list2 == null;
        }
        if (list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (this.nodeEquals((Node)list.get(i), (Node)list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private <T extends Node> boolean nodeEquals(T t, T t2) {
        if (t == t2) {
            return true;
        }
        if (t == null) {
            return t2 == null;
        }
        if (t2 == null) {
            return false;
        }
        if (t.getClass() != t2.getClass()) {
            return false;
        }
        return t.accept(this, t2);
    }

    private boolean objEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    @Override
    public Boolean visit(CompilationUnit compilationUnit, Node node) {
        CompilationUnit compilationUnit2 = (CompilationUnit)node;
        if (!this.nodeEquals(compilationUnit.getPackage(), compilationUnit2.getPackage())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(compilationUnit.getImports(), compilationUnit2.getImports())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(compilationUnit.getTypes(), compilationUnit2.getTypes())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(compilationUnit.getComments(), compilationUnit2.getComments())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(PackageDeclaration packageDeclaration, Node node) {
        PackageDeclaration packageDeclaration2 = (PackageDeclaration)node;
        if (!this.nodeEquals(packageDeclaration.getName(), packageDeclaration2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(packageDeclaration.getAnnotations(), packageDeclaration2.getAnnotations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ImportDeclaration importDeclaration, Node node) {
        ImportDeclaration importDeclaration2 = (ImportDeclaration)node;
        if (!this.nodeEquals(importDeclaration.getName(), importDeclaration2.getName())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(TypeParameter typeParameter, Node node) {
        TypeParameter typeParameter2 = (TypeParameter)node;
        if (!this.objEquals(typeParameter.getName(), typeParameter2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(typeParameter.getTypeBound(), typeParameter2.getTypeBound())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LineComment lineComment, Node node) {
        LineComment lineComment2 = (LineComment)node;
        if (!this.objEquals(lineComment.getContent(), lineComment2.getContent())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BlockComment blockComment, Node node) {
        BlockComment blockComment2 = (BlockComment)node;
        if (!this.objEquals(blockComment.getContent(), blockComment2.getContent())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, Node node) {
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration2 = (ClassOrInterfaceDeclaration)node;
        if (classOrInterfaceDeclaration.getModifiers() != classOrInterfaceDeclaration2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (classOrInterfaceDeclaration.isInterface() != classOrInterfaceDeclaration2.isInterface()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(classOrInterfaceDeclaration.getName(), classOrInterfaceDeclaration2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(classOrInterfaceDeclaration.getAnnotations(), classOrInterfaceDeclaration2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(classOrInterfaceDeclaration.getTypeParameters(), classOrInterfaceDeclaration2.getTypeParameters())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(classOrInterfaceDeclaration.getExtends(), classOrInterfaceDeclaration2.getExtends())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(classOrInterfaceDeclaration.getImplements(), classOrInterfaceDeclaration2.getImplements())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(classOrInterfaceDeclaration.getMembers(), classOrInterfaceDeclaration2.getMembers())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(EnumDeclaration enumDeclaration, Node node) {
        EnumDeclaration enumDeclaration2 = (EnumDeclaration)node;
        if (enumDeclaration.getModifiers() != enumDeclaration2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(enumDeclaration.getName(), enumDeclaration2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(enumDeclaration.getAnnotations(), enumDeclaration2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(enumDeclaration.getImplements(), enumDeclaration2.getImplements())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(enumDeclaration.getEntries(), enumDeclaration2.getEntries())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(enumDeclaration.getMembers(), enumDeclaration2.getMembers())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(EmptyTypeDeclaration emptyTypeDeclaration, Node node) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(EnumConstantDeclaration enumConstantDeclaration, Node node) {
        EnumConstantDeclaration enumConstantDeclaration2 = (EnumConstantDeclaration)node;
        if (!this.objEquals(enumConstantDeclaration.getName(), enumConstantDeclaration2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(enumConstantDeclaration.getAnnotations(), enumConstantDeclaration2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(enumConstantDeclaration.getArgs(), enumConstantDeclaration2.getArgs())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(enumConstantDeclaration.getClassBody(), enumConstantDeclaration2.getClassBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(AnnotationDeclaration annotationDeclaration, Node node) {
        AnnotationDeclaration annotationDeclaration2 = (AnnotationDeclaration)node;
        if (annotationDeclaration.getModifiers() != annotationDeclaration2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(annotationDeclaration.getName(), annotationDeclaration2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(annotationDeclaration.getAnnotations(), annotationDeclaration2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(annotationDeclaration.getMembers(), annotationDeclaration2.getMembers())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(AnnotationMemberDeclaration annotationMemberDeclaration, Node node) {
        AnnotationMemberDeclaration annotationMemberDeclaration2 = (AnnotationMemberDeclaration)node;
        if (annotationMemberDeclaration.getModifiers() != annotationMemberDeclaration2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(annotationMemberDeclaration.getName(), annotationMemberDeclaration2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(annotationMemberDeclaration.getAnnotations(), annotationMemberDeclaration2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(annotationMemberDeclaration.getDefaultValue(), annotationMemberDeclaration2.getDefaultValue())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(annotationMemberDeclaration.getType(), annotationMemberDeclaration2.getType())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(FieldDeclaration fieldDeclaration, Node node) {
        FieldDeclaration fieldDeclaration2 = (FieldDeclaration)node;
        if (fieldDeclaration.getModifiers() != fieldDeclaration2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(fieldDeclaration.getAnnotations(), fieldDeclaration2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(fieldDeclaration.getType(), fieldDeclaration2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(fieldDeclaration.getVariables(), fieldDeclaration2.getVariables())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(VariableDeclarator variableDeclarator, Node node) {
        VariableDeclarator variableDeclarator2 = (VariableDeclarator)node;
        if (!this.nodeEquals(variableDeclarator.getId(), variableDeclarator2.getId())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(variableDeclarator.getInit(), variableDeclarator2.getInit())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(VariableDeclaratorId variableDeclaratorId, Node node) {
        VariableDeclaratorId variableDeclaratorId2 = (VariableDeclaratorId)node;
        if (variableDeclaratorId.getArrayCount() != variableDeclaratorId2.getArrayCount()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(variableDeclaratorId.getName(), variableDeclaratorId2.getName())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ConstructorDeclaration constructorDeclaration, Node node) {
        ConstructorDeclaration constructorDeclaration2 = (ConstructorDeclaration)node;
        if (constructorDeclaration.getModifiers() != constructorDeclaration2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(constructorDeclaration.getName(), constructorDeclaration2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(constructorDeclaration.getAnnotations(), constructorDeclaration2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(constructorDeclaration.getBlock(), constructorDeclaration2.getBlock())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(constructorDeclaration.getParameters(), constructorDeclaration2.getParameters())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(constructorDeclaration.getThrows(), constructorDeclaration2.getThrows())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(constructorDeclaration.getTypeParameters(), constructorDeclaration2.getTypeParameters())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(MethodDeclaration methodDeclaration, Node node) {
        MethodDeclaration methodDeclaration2 = (MethodDeclaration)node;
        if (methodDeclaration.getModifiers() != methodDeclaration2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (methodDeclaration.getArrayCount() != methodDeclaration2.getArrayCount()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(methodDeclaration.getName(), methodDeclaration2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(methodDeclaration.getType(), methodDeclaration2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(methodDeclaration.getAnnotations(), methodDeclaration2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(methodDeclaration.getBody(), methodDeclaration2.getBody())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(methodDeclaration.getParameters(), methodDeclaration2.getParameters())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(methodDeclaration.getThrows(), methodDeclaration2.getThrows())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(methodDeclaration.getTypeParameters(), methodDeclaration2.getTypeParameters())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(Parameter parameter, Node node) {
        Parameter parameter2 = (Parameter)node;
        if (parameter.getModifiers() != parameter2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(parameter.getId(), parameter2.getId())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(parameter.getType(), parameter2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(parameter.getAnnotations(), parameter2.getAnnotations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(EmptyMemberDeclaration emptyMemberDeclaration, Node node) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(InitializerDeclaration initializerDeclaration, Node node) {
        InitializerDeclaration initializerDeclaration2 = (InitializerDeclaration)node;
        if (!this.nodeEquals(initializerDeclaration.getBlock(), initializerDeclaration2.getBlock())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(initializerDeclaration.getAnnotations(), initializerDeclaration2.getAnnotations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(JavadocComment javadocComment, Node node) {
        JavadocComment javadocComment2 = (JavadocComment)node;
        if (!this.objEquals(javadocComment.getContent(), javadocComment2.getContent())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ClassOrInterfaceType classOrInterfaceType, Node node) {
        ClassOrInterfaceType classOrInterfaceType2 = (ClassOrInterfaceType)node;
        if (!this.objEquals(classOrInterfaceType.getName(), classOrInterfaceType2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(classOrInterfaceType.getScope(), classOrInterfaceType2.getScope())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(classOrInterfaceType.getTypeArgs(), classOrInterfaceType2.getTypeArgs())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(PrimitiveType primitiveType, Node node) {
        PrimitiveType primitiveType2 = (PrimitiveType)node;
        if (primitiveType.getType() != primitiveType2.getType()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ReferenceType referenceType, Node node) {
        ReferenceType referenceType2 = (ReferenceType)node;
        if (referenceType.getArrayCount() != referenceType2.getArrayCount()) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(referenceType.getType(), referenceType2.getType())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(VoidType voidType, Node node) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(WildcardType wildcardType, Node node) {
        WildcardType wildcardType2 = (WildcardType)node;
        if (!this.nodeEquals(wildcardType.getExtends(), wildcardType2.getExtends())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(wildcardType.getSuper(), wildcardType2.getSuper())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ArrayAccessExpr arrayAccessExpr, Node node) {
        ArrayAccessExpr arrayAccessExpr2 = (ArrayAccessExpr)node;
        if (!this.nodeEquals(arrayAccessExpr.getName(), arrayAccessExpr2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(arrayAccessExpr.getIndex(), arrayAccessExpr2.getIndex())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ArrayCreationExpr arrayCreationExpr, Node node) {
        ArrayCreationExpr arrayCreationExpr2 = (ArrayCreationExpr)node;
        if (arrayCreationExpr.getArrayCount() != arrayCreationExpr2.getArrayCount()) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(arrayCreationExpr.getType(), arrayCreationExpr2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(arrayCreationExpr.getInitializer(), arrayCreationExpr2.getInitializer())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(arrayCreationExpr.getDimensions(), arrayCreationExpr2.getDimensions())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ArrayInitializerExpr arrayInitializerExpr, Node node) {
        ArrayInitializerExpr arrayInitializerExpr2 = (ArrayInitializerExpr)node;
        if (!this.nodesEquals(arrayInitializerExpr.getValues(), arrayInitializerExpr2.getValues())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(AssignExpr assignExpr, Node node) {
        AssignExpr assignExpr2 = (AssignExpr)node;
        if (assignExpr.getOperator() != assignExpr2.getOperator()) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(assignExpr.getTarget(), assignExpr2.getTarget())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(assignExpr.getValue(), assignExpr2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BinaryExpr binaryExpr, Node node) {
        BinaryExpr binaryExpr2 = (BinaryExpr)node;
        if (binaryExpr.getOperator() != binaryExpr2.getOperator()) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(binaryExpr.getLeft(), binaryExpr2.getLeft())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(binaryExpr.getRight(), binaryExpr2.getRight())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(CastExpr castExpr, Node node) {
        CastExpr castExpr2 = (CastExpr)node;
        if (!this.nodeEquals(castExpr.getType(), castExpr2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(castExpr.getExpr(), castExpr2.getExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ClassExpr classExpr, Node node) {
        ClassExpr classExpr2 = (ClassExpr)node;
        if (!this.nodeEquals(classExpr.getType(), classExpr2.getType())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ConditionalExpr conditionalExpr, Node node) {
        ConditionalExpr conditionalExpr2 = (ConditionalExpr)node;
        if (!this.nodeEquals(conditionalExpr.getCondition(), conditionalExpr2.getCondition())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(conditionalExpr.getThenExpr(), conditionalExpr2.getThenExpr())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(conditionalExpr.getElseExpr(), conditionalExpr2.getElseExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(EnclosedExpr enclosedExpr, Node node) {
        EnclosedExpr enclosedExpr2 = (EnclosedExpr)node;
        if (!this.nodeEquals(enclosedExpr.getInner(), enclosedExpr2.getInner())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(FieldAccessExpr fieldAccessExpr, Node node) {
        FieldAccessExpr fieldAccessExpr2 = (FieldAccessExpr)node;
        if (!this.nodeEquals(fieldAccessExpr.getScope(), fieldAccessExpr2.getScope())) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(fieldAccessExpr.getField(), fieldAccessExpr2.getField())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(fieldAccessExpr.getTypeArgs(), fieldAccessExpr2.getTypeArgs())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(InstanceOfExpr instanceOfExpr, Node node) {
        InstanceOfExpr instanceOfExpr2 = (InstanceOfExpr)node;
        if (!this.nodeEquals(instanceOfExpr.getExpr(), instanceOfExpr2.getExpr())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(instanceOfExpr.getType(), instanceOfExpr2.getType())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(StringLiteralExpr stringLiteralExpr, Node node) {
        StringLiteralExpr stringLiteralExpr2 = (StringLiteralExpr)node;
        if (!this.objEquals(stringLiteralExpr.getValue(), stringLiteralExpr2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(IntegerLiteralExpr integerLiteralExpr, Node node) {
        IntegerLiteralExpr integerLiteralExpr2 = (IntegerLiteralExpr)node;
        if (!this.objEquals(integerLiteralExpr.getValue(), integerLiteralExpr2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LongLiteralExpr longLiteralExpr, Node node) {
        LongLiteralExpr longLiteralExpr2 = (LongLiteralExpr)node;
        if (!this.objEquals(longLiteralExpr.getValue(), longLiteralExpr2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(IntegerLiteralMinValueExpr integerLiteralMinValueExpr, Node node) {
        IntegerLiteralMinValueExpr integerLiteralMinValueExpr2 = (IntegerLiteralMinValueExpr)node;
        if (!this.objEquals(integerLiteralMinValueExpr.getValue(), integerLiteralMinValueExpr2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LongLiteralMinValueExpr longLiteralMinValueExpr, Node node) {
        LongLiteralMinValueExpr longLiteralMinValueExpr2 = (LongLiteralMinValueExpr)node;
        if (!this.objEquals(longLiteralMinValueExpr.getValue(), longLiteralMinValueExpr2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(CharLiteralExpr charLiteralExpr, Node node) {
        CharLiteralExpr charLiteralExpr2 = (CharLiteralExpr)node;
        if (!this.objEquals(charLiteralExpr.getValue(), charLiteralExpr2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(DoubleLiteralExpr doubleLiteralExpr, Node node) {
        DoubleLiteralExpr doubleLiteralExpr2 = (DoubleLiteralExpr)node;
        if (!this.objEquals(doubleLiteralExpr.getValue(), doubleLiteralExpr2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BooleanLiteralExpr booleanLiteralExpr, Node node) {
        BooleanLiteralExpr booleanLiteralExpr2 = (BooleanLiteralExpr)node;
        if (booleanLiteralExpr.getValue() != booleanLiteralExpr2.getValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(NullLiteralExpr nullLiteralExpr, Node node) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(MethodCallExpr methodCallExpr, Node node) {
        MethodCallExpr methodCallExpr2 = (MethodCallExpr)node;
        if (!this.nodeEquals(methodCallExpr.getScope(), methodCallExpr2.getScope())) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(methodCallExpr.getName(), methodCallExpr2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(methodCallExpr.getArgs(), methodCallExpr2.getArgs())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(methodCallExpr.getTypeArgs(), methodCallExpr2.getTypeArgs())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(NameExpr nameExpr, Node node) {
        NameExpr nameExpr2 = (NameExpr)node;
        if (!this.objEquals(nameExpr.getName(), nameExpr2.getName())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ObjectCreationExpr objectCreationExpr, Node node) {
        ObjectCreationExpr objectCreationExpr2 = (ObjectCreationExpr)node;
        if (!this.nodeEquals(objectCreationExpr.getScope(), objectCreationExpr2.getScope())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(objectCreationExpr.getType(), objectCreationExpr2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(objectCreationExpr.getAnonymousClassBody(), objectCreationExpr2.getAnonymousClassBody())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(objectCreationExpr.getArgs(), objectCreationExpr2.getArgs())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(objectCreationExpr.getTypeArgs(), objectCreationExpr2.getTypeArgs())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(QualifiedNameExpr qualifiedNameExpr, Node node) {
        QualifiedNameExpr qualifiedNameExpr2 = (QualifiedNameExpr)node;
        if (!this.nodeEquals(qualifiedNameExpr.getQualifier(), qualifiedNameExpr2.getQualifier())) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(qualifiedNameExpr.getName(), qualifiedNameExpr2.getName())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ThisExpr thisExpr, Node node) {
        ThisExpr thisExpr2 = (ThisExpr)node;
        if (!this.nodeEquals(thisExpr.getClassExpr(), thisExpr2.getClassExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SuperExpr superExpr, Node node) {
        SuperExpr superExpr2 = (SuperExpr)node;
        if (!this.nodeEquals(superExpr.getClassExpr(), superExpr2.getClassExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(UnaryExpr unaryExpr, Node node) {
        UnaryExpr unaryExpr2 = (UnaryExpr)node;
        if (unaryExpr.getOperator() != unaryExpr2.getOperator()) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(unaryExpr.getExpr(), unaryExpr2.getExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(VariableDeclarationExpr variableDeclarationExpr, Node node) {
        VariableDeclarationExpr variableDeclarationExpr2 = (VariableDeclarationExpr)node;
        if (variableDeclarationExpr.getModifiers() != variableDeclarationExpr2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(variableDeclarationExpr.getAnnotations(), variableDeclarationExpr2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(variableDeclarationExpr.getType(), variableDeclarationExpr2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(variableDeclarationExpr.getVars(), variableDeclarationExpr2.getVars())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(MarkerAnnotationExpr markerAnnotationExpr, Node node) {
        MarkerAnnotationExpr markerAnnotationExpr2 = (MarkerAnnotationExpr)node;
        if (!this.nodeEquals(markerAnnotationExpr.getName(), markerAnnotationExpr2.getName())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SingleMemberAnnotationExpr singleMemberAnnotationExpr, Node node) {
        SingleMemberAnnotationExpr singleMemberAnnotationExpr2 = (SingleMemberAnnotationExpr)node;
        if (!this.nodeEquals(singleMemberAnnotationExpr.getName(), singleMemberAnnotationExpr2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(singleMemberAnnotationExpr.getMemberValue(), singleMemberAnnotationExpr2.getMemberValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(NormalAnnotationExpr normalAnnotationExpr, Node node) {
        NormalAnnotationExpr normalAnnotationExpr2 = (NormalAnnotationExpr)node;
        if (!this.nodeEquals(normalAnnotationExpr.getName(), normalAnnotationExpr2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(normalAnnotationExpr.getPairs(), normalAnnotationExpr2.getPairs())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(MemberValuePair memberValuePair, Node node) {
        MemberValuePair memberValuePair2 = (MemberValuePair)node;
        if (!this.objEquals(memberValuePair.getName(), memberValuePair2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(memberValuePair.getValue(), memberValuePair2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt, Node node) {
        ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt2 = (ExplicitConstructorInvocationStmt)node;
        if (!this.nodeEquals(explicitConstructorInvocationStmt.getExpr(), explicitConstructorInvocationStmt2.getExpr())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(explicitConstructorInvocationStmt.getArgs(), explicitConstructorInvocationStmt2.getArgs())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(explicitConstructorInvocationStmt.getTypeArgs(), explicitConstructorInvocationStmt2.getTypeArgs())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(TypeDeclarationStmt typeDeclarationStmt, Node node) {
        TypeDeclarationStmt typeDeclarationStmt2 = (TypeDeclarationStmt)node;
        if (!this.nodeEquals(typeDeclarationStmt.getTypeDeclaration(), typeDeclarationStmt2.getTypeDeclaration())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(AssertStmt assertStmt, Node node) {
        AssertStmt assertStmt2 = (AssertStmt)node;
        if (!this.nodeEquals(assertStmt.getCheck(), assertStmt2.getCheck())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(assertStmt.getMessage(), assertStmt2.getMessage())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BlockStmt blockStmt, Node node) {
        BlockStmt blockStmt2 = (BlockStmt)node;
        if (!this.nodesEquals(blockStmt.getStmts(), blockStmt2.getStmts())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LabeledStmt labeledStmt, Node node) {
        LabeledStmt labeledStmt2 = (LabeledStmt)node;
        if (!this.nodeEquals(labeledStmt.getStmt(), labeledStmt2.getStmt())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(EmptyStmt emptyStmt, Node node) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ExpressionStmt expressionStmt, Node node) {
        ExpressionStmt expressionStmt2 = (ExpressionStmt)node;
        if (!this.nodeEquals(expressionStmt.getExpression(), expressionStmt2.getExpression())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SwitchStmt switchStmt, Node node) {
        SwitchStmt switchStmt2 = (SwitchStmt)node;
        if (!this.nodeEquals(switchStmt.getSelector(), switchStmt2.getSelector())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(switchStmt.getEntries(), switchStmt2.getEntries())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SwitchEntryStmt switchEntryStmt, Node node) {
        SwitchEntryStmt switchEntryStmt2 = (SwitchEntryStmt)node;
        if (!this.nodeEquals(switchEntryStmt.getLabel(), switchEntryStmt2.getLabel())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(switchEntryStmt.getStmts(), switchEntryStmt2.getStmts())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BreakStmt breakStmt, Node node) {
        BreakStmt breakStmt2 = (BreakStmt)node;
        if (!this.objEquals(breakStmt.getId(), breakStmt2.getId())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ReturnStmt returnStmt, Node node) {
        ReturnStmt returnStmt2 = (ReturnStmt)node;
        if (!this.nodeEquals(returnStmt.getExpr(), returnStmt2.getExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(IfStmt ifStmt, Node node) {
        IfStmt ifStmt2 = (IfStmt)node;
        if (!this.nodeEquals(ifStmt.getCondition(), ifStmt2.getCondition())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(ifStmt.getThenStmt(), ifStmt2.getThenStmt())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(ifStmt.getElseStmt(), ifStmt2.getElseStmt())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(WhileStmt whileStmt, Node node) {
        WhileStmt whileStmt2 = (WhileStmt)node;
        if (!this.nodeEquals(whileStmt.getCondition(), whileStmt2.getCondition())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(whileStmt.getBody(), whileStmt2.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ContinueStmt continueStmt, Node node) {
        ContinueStmt continueStmt2 = (ContinueStmt)node;
        if (!this.objEquals(continueStmt.getId(), continueStmt2.getId())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(DoStmt doStmt, Node node) {
        DoStmt doStmt2 = (DoStmt)node;
        if (!this.nodeEquals(doStmt.getBody(), doStmt2.getBody())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(doStmt.getCondition(), doStmt2.getCondition())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ForeachStmt foreachStmt, Node node) {
        ForeachStmt foreachStmt2 = (ForeachStmt)node;
        if (!this.nodeEquals(foreachStmt.getVariable(), foreachStmt2.getVariable())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(foreachStmt.getIterable(), foreachStmt2.getIterable())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(foreachStmt.getBody(), foreachStmt2.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ForStmt forStmt, Node node) {
        ForStmt forStmt2 = (ForStmt)node;
        if (!this.nodesEquals(forStmt.getInit(), forStmt2.getInit())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(forStmt.getCompare(), forStmt2.getCompare())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(forStmt.getUpdate(), forStmt2.getUpdate())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(forStmt.getBody(), forStmt2.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ThrowStmt throwStmt, Node node) {
        ThrowStmt throwStmt2 = (ThrowStmt)node;
        if (!this.nodeEquals(throwStmt.getExpr(), throwStmt2.getExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SynchronizedStmt synchronizedStmt, Node node) {
        SynchronizedStmt synchronizedStmt2 = (SynchronizedStmt)node;
        if (!this.nodeEquals(synchronizedStmt.getExpr(), synchronizedStmt2.getExpr())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(synchronizedStmt.getBlock(), synchronizedStmt2.getBlock())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(TryStmt tryStmt, Node node) {
        TryStmt tryStmt2 = (TryStmt)node;
        if (!this.nodeEquals(tryStmt.getTryBlock(), tryStmt2.getTryBlock())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(tryStmt.getCatchs(), tryStmt2.getCatchs())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(tryStmt.getFinallyBlock(), tryStmt2.getFinallyBlock())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(CatchClause catchClause, Node node) {
        CatchClause catchClause2 = (CatchClause)node;
        if (!this.nodeEquals(catchClause.getExcept(), catchClause2.getExcept())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(catchClause.getCatchBlock(), catchClause2.getCatchBlock())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(IndexUnit indexUnit, Node node) {
        throw new RuntimeException("Not Supported!");
    }
}

