/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.diags;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import org.codehaus.plexus.util.StringUtils;

public class TrackingArchiver
implements Archiver {
    private File destFile;
    public final List<Addition> added = new ArrayList<Addition>();
    private boolean useJvmChmod;
    private boolean ignorePermissions;
    private Date lastModified;
    private Comparator<String> filenameComparator;

    @Override
    public void createArchive() throws ArchiverException, IOException {
    }

    @Override
    public void addDirectory(@Nonnull File directory) throws ArchiverException {
        this.added.add(new Addition(directory, null, null, null, -1));
    }

    @Override
    public void addDirectory(@Nonnull File directory, String prefix) throws ArchiverException {
        this.added.add(new Addition(directory, prefix, null, null, -1));
    }

    @Override
    public void addDirectory(@Nonnull File directory, String[] includes, String[] excludes) throws ArchiverException {
        this.added.add(new Addition(directory, null, includes, excludes, -1));
    }

    @Override
    public void addDirectory(@Nonnull File directory, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        this.added.add(new Addition(directory, prefix, includes, excludes, -1));
    }

    @Override
    public void addFileSet(@Nonnull FileSet fileSet) throws ArchiverException {
        this.added.add(new Addition(fileSet, null, null, null, -1));
    }

    @Override
    public void addFile(@Nonnull File inputFile, @Nonnull String destFileName) throws ArchiverException {
        this.added.add(new Addition(inputFile, destFileName, null, null, -1));
    }

    @Override
    public void addFile(@Nonnull File inputFile, @Nonnull String destFileName, int permissions) throws ArchiverException {
        this.added.add(new Addition(inputFile, destFileName, null, null, permissions));
    }

    @Override
    public void addArchivedFileSet(@Nonnull File archiveFile) throws ArchiverException {
        this.added.add(new Addition(archiveFile, null, null, null, -1));
    }

    @Override
    public void addArchivedFileSet(@Nonnull File archiveFile, String prefix) throws ArchiverException {
        this.added.add(new Addition(archiveFile, prefix, null, null, -1));
    }

    @Override
    public void addSymlink(String s2, String s22) throws ArchiverException {
        this.added.add(new Addition(s2, null, null, null, -1));
    }

    @Override
    public void addSymlink(String s2, int i, String s22) throws ArchiverException {
        this.added.add(new Addition(s2, null, null, null, -1));
    }

    @Override
    public void addArchivedFileSet(File archiveFile, String[] includes, String[] excludes) throws ArchiverException {
        this.added.add(new Addition(archiveFile, null, includes, excludes, -1));
    }

    @Override
    public void addArchivedFileSet(@Nonnull File archiveFile, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        this.added.add(new Addition(archiveFile, prefix, includes, excludes, -1));
    }

    @Override
    public void addArchivedFileSet(ArchivedFileSet fileSet) throws ArchiverException {
        this.added.add(new Addition(fileSet, null, null, null, -1));
    }

    @Override
    public void addArchivedFileSet(ArchivedFileSet fileSet, Charset charset) throws ArchiverException {
        this.added.add(new Addition(fileSet, null, null, null, -1));
    }

    @Override
    public void addResource(PlexusIoResource resource, String destFileName, int permissions) throws ArchiverException {
        this.added.add(new Addition(resource, destFileName, null, null, permissions));
    }

    @Override
    public void addResources(PlexusIoResourceCollection resources) throws ArchiverException {
        this.added.add(new Addition(resources, null, null, null, -1));
    }

    @Override
    public File getDestFile() {
        return this.destFile;
    }

    @Override
    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    @Override
    public void setFileMode(int mode) {
    }

    @Override
    public int getFileMode() {
        return Integer.parseInt("0644", 8);
    }

    @Override
    public int getOverrideFileMode() {
        return Integer.parseInt("0644", 8);
    }

    @Override
    public void setDefaultFileMode(int mode) {
    }

    @Override
    public int getDefaultFileMode() {
        return Integer.parseInt("0644", 8);
    }

    @Override
    public void setDirectoryMode(int mode) {
    }

    @Override
    public int getDirectoryMode() {
        return Integer.parseInt("0755", 8);
    }

    @Override
    public int getOverrideDirectoryMode() {
        return Integer.parseInt("0755", 8);
    }

    @Override
    public void setDefaultDirectoryMode(int mode) {
    }

    @Override
    public int getDefaultDirectoryMode() {
        return Integer.parseInt("0755", 8);
    }

    @Override
    public boolean getIncludeEmptyDirs() {
        return false;
    }

    @Override
    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
    }

    @Override
    public void setDotFileDirectory(File dotFileDirectory) {
    }

    @Override
    @Nonnull
    public ResourceIterator getResources() throws ArchiverException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Map<String, ArchiveEntry> getFiles() {
        return new HashMap<String, ArchiveEntry>();
    }

    @Override
    public boolean isForced() {
        return false;
    }

    @Override
    public void setForced(boolean forced) {
    }

    @Override
    public boolean isSupportingForced() {
        return true;
    }

    @Override
    public String getDuplicateBehavior() {
        return null;
    }

    @Override
    public void setDuplicateBehavior(String duplicate) {
    }

    @Override
    public boolean isUseJvmChmod() {
        return this.useJvmChmod;
    }

    @Override
    public void setUseJvmChmod(boolean useJvmChmod) {
        this.useJvmChmod = useJvmChmod;
    }

    @Override
    public boolean isIgnorePermissions() {
        return this.ignorePermissions;
    }

    @Override
    public void setIgnorePermissions(boolean ignorePermissions) {
        this.ignorePermissions = ignorePermissions;
    }

    @Override
    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModified = lastModifiedDate;
    }

    @Override
    public Date getLastModifiedDate() {
        return this.lastModified;
    }

    @Override
    public void setFilenameComparator(Comparator<String> filenameComparator) {
        this.filenameComparator = filenameComparator;
    }

    @Override
    public void setOverrideUid(int uid) {
    }

    @Override
    public void setOverrideUserName(String userName) {
    }

    @Override
    public int getOverrideUid() {
        return 0;
    }

    @Override
    public String getOverrideUserName() {
        return null;
    }

    @Override
    public void setOverrideGid(int gid) {
    }

    @Override
    public void setOverrideGroupName(String groupName) {
    }

    @Override
    public int getOverrideGid() {
        return 0;
    }

    @Override
    public String getOverrideGroupName() {
        return null;
    }

    @Override
    public void configureReproducible(Date lastModifiedDate) {
    }

    public class Addition {
        public final Object resource;
        public final File directory;
        public final String destination;
        public final int permissions;
        public final String[] includes;
        public final String[] excludes;

        public String toString() {
            return "Addition (\n    resource= " + this.resource + "\n    directory= " + this.directory + "\n    destination= " + this.destination + "\n    permissions= " + this.permissions + "\n    includes= " + (this.includes == null ? "-none-" : StringUtils.join(this.includes, ", ")) + "\n    excludes= " + (this.excludes == null ? "-none-" : StringUtils.join(this.excludes, ", ")) + "\n)";
        }

        public Addition(Object resource, String destination, String[] includes, String[] excludes, int permissions) {
            this.resource = resource;
            if (resource instanceof FileSet) {
                FileSet fs = (FileSet)resource;
                this.directory = fs.getDirectory();
                this.destination = fs.getPrefix();
                this.includes = fs.getIncludes();
                this.excludes = fs.getExcludes();
                this.permissions = permissions;
            } else {
                this.directory = resource instanceof File && ((File)resource).isDirectory() ? (File)resource : null;
                this.destination = destination;
                this.includes = includes;
                this.excludes = excludes;
                this.permissions = permissions;
            }
        }
    }
}

