/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2.generators;

import bbd.jportal2.BaseGenerator;
import bbd.jportal2.Database;
import bbd.jportal2.Enum;
import bbd.jportal2.Field;
import bbd.jportal2.Flag;
import bbd.jportal2.Grant;
import bbd.jportal2.IBuiltInSIProcessor;
import bbd.jportal2.Key;
import bbd.jportal2.Line;
import bbd.jportal2.Link;
import bbd.jportal2.PlaceHolder;
import bbd.jportal2.Proc;
import bbd.jportal2.Sequence;
import bbd.jportal2.Table;
import bbd.jportal2.View;
import java.io.PrintWriter;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonTreeCode
extends BaseGenerator
implements IBuiltInSIProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PythonTreeCode.class);

    public PythonTreeCode() {
        super(PythonTreeCode.class);
    }

    @Override
    public String description() {
        return "Generates Python Tree Code";
    }

    @Override
    public String documentation() {
        return "Generates Python Tree Code";
    }

    public String stringTrip(String var, String value, boolean trip) {
        return var + " = _escape(''' " + value + " ''')";
    }

    public String string(String var, String value) {
        if (value.length() > 0 && value.charAt(0) == '\'') {
            return var + " = \"" + value + "\"";
        }
        if (value.length() > 0) {
            return var + " = '" + value + "'";
        }
        return var + " = ''";
    }

    public String string(String var, boolean value) {
        if (value) {
            return var + " = True";
        }
        return var + " = False";
    }

    public String string(String var, int value) {
        return var + " = " + value;
    }

    public String string(String var, long value) {
        if (value <= 999999999L) {
            return var + " = " + value;
        }
        return var + " = long(" + value + ")";
    }

    public void out(PrintWriter outData, String data) {
        if (data.length() > 0) {
            outData.println(data);
        }
    }

    @Override
    public void generate(Database database, String output) throws Exception {
        database = database.doImports();
        try (PrintWriter outData = this.openOutputFileForGeneration("py", output + database.output + ".py");){
            int i;
            outData.println("# This code was generated, do not modify it, modify it at source and regenerate it.");
            outData.println("# " + database.output + ".py");
            outData.println("class _class: pass");
            outData.println("def _strings(data):");
            outData.println("  return data.strip().splitlines() if isinstance(data, str) else []");
            outData.println("def _integers(data):");
            outData.println("  return data.strip().splitlines() if isinstance(data, str) else []");
            outData.println("def _escape(data):");
            outData.println("  return data[1:-1] if isinstance(data, str) and len(data) > 1 else ''");
            outData.println("database = _db = _class()");
            this.out(outData, this.string("_db.name", database.name));
            this.out(outData, this.string("_db.output", database.output));
            this.out(outData, this.string("_db.server", database.server));
            this.out(outData, this.string("_db.userid", database.userid));
            this.out(outData, this.string("_db.password", database.password));
            this.out(outData, this.string("_db.packageName", database.packageName));
            if (database.flags.size() > 0) {
                outData.print("_db.getFlags = ");
                this.generateString(database.flags, outData);
            } else {
                outData.println("_db.getFlags = ''");
            }
            if (database.imports.size() > 0) {
                outData.print("_db.imports = ");
                this.generateString(database.imports, outData);
            } else {
                outData.println("_db.imports = ''");
            }
            outData.println("_db.tables = []");
            for (i = 0; i < database.tables.size(); ++i) {
                Table table = database.tables.elementAt(i);
                this.generateTable(table, outData);
                outData.println(this.lowerFirst(table.useName()) + " = _tb");
                outData.println("_db.tables.append(_tb)");
            }
            outData.println("_db.views = []");
            for (i = 0; i < database.views.size(); ++i) {
                View view = database.views.elementAt(i);
                this.generateView(view, outData);
                outData.println("_db.views.append(_vw)");
            }
            outData.println("_db.sequences = []");
            for (i = 0; i < database.sequences.size(); ++i) {
                Sequence sequence = database.sequences.elementAt(i);
                this.generateSequence(sequence, outData);
                outData.println("_db.sequences.append(_sq)");
            }
        }
    }

    void generateTable(Table table, PrintWriter outData) {
        int i;
        outData.println("_tb = _class()");
        this.out(outData, this.string("_tb.name", table.name));
        this.out(outData, this.string("_tb.alias", table.alias));
        this.out(outData, this.string("_tb.check", table.check));
        this.out(outData, this.string("_tb.hasPrimaryKey", table.hasPrimaryKey));
        this.out(outData, this.string("_tb.hasSequence", table.hasSequence));
        this.out(outData, this.string("_tb.hasTimeStamp", table.hasTimeStamp));
        this.out(outData, this.string("_tb.hasUserStamp", table.hasUserStamp));
        this.out(outData, this.string("_tb.hasExecute", table.hasExecute));
        this.out(outData, this.string("_tb.hasSelect", table.hasSelect));
        this.out(outData, this.string("_tb.hasInsert", table.hasInsert));
        this.out(outData, this.string("_tb.hasDelete", table.hasDelete));
        this.out(outData, this.string("_tb.hasUpdate", table.hasUpdate));
        this.out(outData, this.string("_tb.hasStdProcs", table.hasStdProcs));
        this.out(outData, this.string("_tb.hasIdentity", table.hasIdentity));
        this.out(outData, this.string("_tb.start", table.start));
        if (table.comments.size() > 0) {
            outData.print("_tb.comments = ");
            this.generateString(table.comments, outData);
        } else {
            outData.println("_tb.comments = ''");
        }
        if (table.options.size() > 0) {
            outData.print("_tb.options = ");
            this.generateString(table.options, outData);
        } else {
            outData.println("_tb.options = ''");
        }
        if (table.allUsers.size() > 0) {
            outData.print("_tb.allUsers = ");
            this.generateString(table.allUsers, outData);
        } else {
            outData.println("_tb.allUsers = ''");
        }
        outData.println("_tb.fields = []");
        for (i = 0; i < table.fields.size(); ++i) {
            this.generateField(table.fields.elementAt(i), outData);
            outData.println("_tb.fields.append(_fd)");
        }
        outData.println("_tb.keys = []");
        for (i = 0; i < table.keys.size(); ++i) {
            this.generateKey(table.keys.elementAt(i), outData);
            outData.println("_tb.keys.append(_ky)");
        }
        outData.println("_tb.links = []");
        for (i = 0; i < table.links.size(); ++i) {
            this.generateLink(table.links.elementAt(i), outData);
            outData.println("_tb.links.append(_ln)");
        }
        outData.println("_tb.grants = []");
        for (i = 0; i < table.grants.size(); ++i) {
            this.generateGrant(table.grants.elementAt(i), outData);
            outData.println("_tb.grants.append(_gr)");
        }
        outData.println("_tb.views = []");
        for (i = 0; i < table.views.size(); ++i) {
            this.generateView(table.views.elementAt(i), outData);
            outData.println("_tb.views.append(_vw)");
        }
        outData.println("_tb.procs = []");
        for (i = 0; i < table.procs.size(); ++i) {
            Proc proc = table.procs.elementAt(i);
            if (proc.isData) continue;
            this.generateProc(proc, outData);
            outData.println(this.lowerFirst(table.useName()) + proc.name + " = _pr");
            outData.println("_tb.procs.append(_pr)");
        }
    }

    String lowerFirst(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    void generateProc(Proc proc, PrintWriter outData) {
        int i;
        outData.println("_pr = _class()");
        this.out(outData, this.string("_pr.name", proc.name));
        this.out(outData, this.string("_pr.noRows", proc.noRows));
        this.out(outData, this.string("_pr.isData", proc.isData));
        this.out(outData, this.string("_pr.isSql", proc.isSql));
        this.out(outData, this.string("_pr.isSingle", proc.isSingle));
        this.out(outData, this.string("_pr.isStd", proc.isStd));
        this.out(outData, this.string("_pr.useStd", proc.useStd));
        this.out(outData, this.string("_pr.useKey", proc.useKey));
        this.out(outData, this.string("_pr.hasImage", proc.hasImage));
        this.out(outData, this.string("_pr.isInsert", proc.isInsert));
        this.out(outData, this.string("_pr.isSProc", proc.isSProc));
        this.out(outData, this.string("_pr.isMultipleInput", proc.isMultipleInput));
        this.out(outData, this.string("_pr.hasReturning", proc.hasReturning));
        this.out(outData, this.string("_pr.start", proc.start));
        if (proc.comments.size() > 0) {
            outData.print("_pr.comments = ");
            this.generateString(proc.comments, outData);
        } else {
            outData.println("_pr.comments = ''");
        }
        if (proc.options.size() > 0) {
            outData.print("_pr.options = ");
            this.generateString(proc.options, outData);
        } else {
            outData.println("_pr.options = ''");
        }
        outData.println("_pr.inputs = []");
        for (i = 0; i < proc.inputs.size(); ++i) {
            this.generateField(proc.inputs.elementAt(i), outData);
            outData.println("_pr.inputs.append(_fd)");
        }
        outData.println("_pr.outputs = []");
        for (i = 0; i < proc.outputs.size(); ++i) {
            this.generateField(proc.outputs.elementAt(i), outData);
            outData.println("_pr.outputs.append(_fd)");
        }
        PlaceHolder holder = new PlaceHolder(proc, 0, "&");
        Vector<String> lines = holder.getLines();
        if (lines.size() > 0) {
            outData.print("_pr.lines = ");
            this.generateString(lines, outData);
        } else {
            outData.println("_pr.lines = ''");
        }
        if (proc.dynamics.size() > 0) {
            outData.print("_pr.dynamics = ");
            this.generateString(proc.dynamics, outData);
        } else {
            outData.println("_pr.dynamics = ''");
        }
        if (proc.dynamicSizes.size() > 0) {
            outData.print("_pr.dynamicSizes = ");
            this.generateInteger(proc.dynamicSizes, outData);
        } else {
            outData.println("_pr.dynamicSizes = ''");
        }
    }

    String fieldType(byte type) {
        switch (type) {
            case 25: {
                return "BIGIDENTITY";
            }
            case 24: {
                return "BIGSEQUENCE";
            }
            case 1: {
                return "BLOB";
            }
            case 2: {
                return "BOOLEAN";
            }
            case 3: {
                return "BYTE";
            }
            case 4: {
                return "CHAR";
            }
            case 5: {
                return "DATE";
            }
            case 6: {
                return "DATETIME";
            }
            case 7: {
                return "DOUBLE";
            }
            case 8: {
                return "DYNAMIC";
            }
            case 9: {
                return "FLOAT";
            }
            case 10: {
                return "IDENTITY";
            }
            case 11: {
                return "INT";
            }
            case 12: {
                return "LONG";
            }
            case 13: {
                return "MONEY";
            }
            case 14: {
                return "_sq";
            }
            case 15: {
                return "SHORT";
            }
            case 16: {
                return "STATUS";
            }
            case 17: {
                return "TIME";
            }
            case 18: {
                return "TIMESTAMP";
            }
            case 19: {
                return "TLOB";
            }
            case 20: {
                return "USERSTAMP";
            }
            case 21: {
                return "ANSICHAR";
            }
            case 22: {
                return "UID";
            }
            case 23: {
                return "XML";
            }
        }
        return "0";
    }

    void generateField(Field field, PrintWriter outData) {
        int i;
        outData.println("_fd = _class()");
        this.out(outData, this.string("_fd.name", field.name));
        this.out(outData, this.string("_fd.alias", field.alias));
        this.out(outData, this.stringTrip("_fd.checkValue", field.checkValue, true));
        this.out(outData, this.stringTrip("_fd.defaultValue", field.defaultValue, true));
        this.out(outData, this.string("_fd.enumLink", field.enumLink));
        this.out(outData, this.string("_fd.type", this.fieldType(field.type)));
        this.out(outData, this.string("_fd.length", field.length));
        this.out(outData, this.string("_fd.precision", field.precision));
        this.out(outData, this.string("_fd.scale", field.scale));
        this.out(outData, this.string("_fd.bindPos", field.bindPos));
        this.out(outData, this.string("_fd.definePos", field.definePos));
        this.out(outData, this.string("_fd.isPrimaryKey", field.isPrimaryKey));
        this.out(outData, this.string("_fd.isSequence", field.isSequence));
        this.out(outData, this.string("_fd.isNull", field.isNull));
        this.out(outData, this.string("_fd.isIn", field.isIn));
        this.out(outData, this.string("_fd.isOut", field.isOut));
        if (field.comments.size() > 0) {
            outData.print("_fd.comments = ");
            this.generateString(field.comments, outData);
        } else {
            outData.println("_fd.comments = ''");
        }
        outData.println("_fd.enums = []");
        for (i = 0; i < field.enums.size(); ++i) {
            this.generateEnum(field.enums.elementAt(i), outData);
            outData.println("_fd.enums.append(_en)");
        }
        outData.println("_fd.valueList = []");
        for (i = 0; i < field.valueList.size(); ++i) {
            this.out(outData, this.string("_val", field.valueList.elementAt(i)));
            outData.println("_fd.valueList.append(_val)");
        }
    }

    void generateLine(Line line, PrintWriter outData) {
        if (line.line.trim().length() > 0) {
            outData.println((line.isVar ? "&" : "") + line.line);
        }
    }

    void generateEnum(Enum entry, PrintWriter outData) {
        outData.println("_en = _class()");
        this.out(outData, this.string("_en.name", entry.name));
        this.out(outData, this.string("_en.value", entry.value));
    }

    void generateGrant(Grant grant, PrintWriter outData) {
        outData.println("_gr = _class()");
        if (grant.perms.size() > 0) {
            outData.print("_gr.perms = ");
            this.generateString(grant.perms, outData);
        } else {
            outData.println("_gr.perms = ''");
        }
        if (grant.users.size() > 0) {
            outData.print("_gr.users = ");
            this.generateString(grant.users, outData);
        } else {
            outData.println("_gr.users = ''");
        }
    }

    void generateKey(Key key, PrintWriter outData) {
        outData.println("_ky = _class()");
        this.out(outData, this.string("_ky.name", key.name));
        this.out(outData, this.string("_ky.isPrimary", key.isPrimary));
        this.out(outData, this.string("_ky.isUnique", key.isUnique));
        if (key.fields.size() > 0) {
            outData.print("_ky.fields = ");
            this.generateString(key.fields, outData);
        } else {
            outData.println("_ky.fields = ''");
        }
        if (key.options.size() > 0) {
            outData.print("_ky.options = ");
            this.generateString(key.options, outData);
        } else {
            outData.println("_ky.options = ''");
        }
    }

    void generateLink(Link link, PrintWriter outData) {
        outData.println("_ln = _class()");
        this.out(outData, this.string("_ln.name", link.name));
        this.out(outData, this.string("_ln.linkName", link.linkName));
        if (link.fields.size() > 0) {
            outData.print("_ln.fields = ");
            this.generateString(link.fields, outData);
        } else {
            outData.println("_ln.fields = ");
        }
    }

    void generateFlag(Flag flag, PrintWriter outData) {
        outData.println("_fg = _class()");
        this.out(outData, this.string("_fg.name", flag.name));
        this.out(outData, this.string("_fg.value", this.toBoolean(flag.value)));
        outData.println("_fg.description = '" + flag.description + "'");
    }

    void generateString(Vector<String> allUsers, PrintWriter outData) {
        outData.println("_strings('''\\");
        for (int i = 0; i < allUsers.size(); ++i) {
            String string = allUsers.elementAt(i);
            if (string.length() > 2 && string.charAt(0) == '\"') {
                outData.println(string.substring(1, string.length() - 1));
                continue;
            }
            outData.println(string);
        }
        outData.println("''')");
    }

    void generateInteger(Vector<Integer> integers, PrintWriter outData) {
        outData.println("_integers('''\\");
        for (int i = 0; i < integers.size(); ++i) {
            Integer integer = integers.elementAt(i);
            outData.println(integer);
        }
        outData.println("''')");
    }

    void generateSequence(Sequence sequence, PrintWriter outData) {
        outData.println("_sq = _class()");
        this.out(outData, this.string("_sq.name", sequence.name));
        this.out(outData, this.string("_sq.minValue", sequence.minValue));
        this.out(outData, this.string("_sq.maxValue", sequence.maxValue));
        this.out(outData, this.string("_sq.increment", sequence.increment));
        this.out(outData, this.string("_sq.cycleFlag", sequence.cycleFlag));
        this.out(outData, this.string("_sq.orderFlag", sequence.orderFlag));
        this.out(outData, this.string("_sq.startWith", sequence.startWith));
        this.out(outData, this.string("_sq.start", sequence.start));
    }

    void generateView(View view, PrintWriter outData) {
        outData.println("_vw = _class()");
        this.out(outData, this.string("_vw.name", view.name));
        this.out(outData, this.string("_vw.start", view.start));
        if (view.aliases.size() > 0) {
            outData.print("_vw.aliases = ");
            this.generateString(view.aliases, outData);
        } else {
            outData.println("_vw.aliases = ''");
        }
        if (view.lines.size() > 0) {
            outData.print("_vw.lines = ");
            this.generateString(view.lines, outData);
        } else {
            outData.println("_vw.lines = ''");
        }
        if (view.users.size() > 0) {
            outData.print("_vw.users = ");
            this.generateString(view.users, outData);
        } else {
            outData.println("_vw.users = ''");
        }
    }
}

