/*
 * Decompiled with CFR 0.152.
 */
package javacutils;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.model.JavacTypes;
import javacutils.ErrorReporter;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public final class TypesUtils {
    private TypesUtils() {
        throw new AssertionError((Object)"Class TypesUtils cannot be instantiated.");
    }

    public static Name getQualifiedName(DeclaredType type) {
        TypeElement element = (TypeElement)type.asElement();
        return element.getQualifiedName();
    }

    public static boolean isObject(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, "java.lang.Object");
    }

    public static boolean isClass(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, "java.lang.Class");
    }

    public static boolean isString(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, "java.lang.String");
    }

    public static boolean isBooleanType(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, "java.lang.Boolean") || type.getKind().equals((Object)TypeKind.BOOLEAN);
    }

    public static boolean isDeclaredOfName(TypeMirror type, CharSequence qualifiedName) {
        return (type = ((Type)type).unannotatedType()).getKind() == TypeKind.DECLARED && TypesUtils.getQualifiedName((DeclaredType)type).contentEquals(qualifiedName);
    }

    public static boolean isBoxedPrimitive(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        String qualifiedName = TypesUtils.getQualifiedName((DeclaredType)type).toString();
        return qualifiedName.equals("java.lang.Boolean") || qualifiedName.equals("java.lang.Byte") || qualifiedName.equals("java.lang.Character") || qualifiedName.equals("java.lang.Short") || qualifiedName.equals("java.lang.Integer") || qualifiedName.equals("java.lang.Long") || qualifiedName.equals("java.lang.Double") || qualifiedName.equals("java.lang.Float");
    }

    public static boolean isThrowable(TypeMirror type) {
        while (type != null && type.getKind() == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)type;
            TypeElement elem = (TypeElement)dt.asElement();
            Name name = elem.getQualifiedName();
            if ("java.lang.Throwable".contentEquals(name)) {
                return true;
            }
            type = elem.getSuperclass();
        }
        return false;
    }

    public static boolean isPrimitive(TypeMirror type) {
        type = ((Type)type).unannotatedType();
        switch (type.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return true;
            }
        }
        return false;
    }

    public static boolean areSamePrimitiveTypes(TypeMirror left, TypeMirror right) {
        if (!TypesUtils.isPrimitive(left) || !TypesUtils.isPrimitive(right)) {
            return false;
        }
        return left.getKind() == right.getKind();
    }

    public static boolean isNumeric(TypeMirror type) {
        type = ((Type)type).unannotatedType();
        switch (type.getKind()) {
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntegral(TypeMirror type) {
        type = ((Type)type).unannotatedType();
        switch (type.getKind()) {
            case BYTE: 
            case CHAR: 
            case INT: 
            case LONG: 
            case SHORT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFloating(TypeMirror type) {
        type = ((Type)type).unannotatedType();
        switch (type.getKind()) {
            case DOUBLE: 
            case FLOAT: {
                return true;
            }
        }
        return false;
    }

    public static TypeKind widenedNumericType(TypeMirror left, TypeMirror right) {
        if (!TypesUtils.isNumeric(left) || !TypesUtils.isNumeric(right)) {
            return TypeKind.NONE;
        }
        TypeKind leftKind = left.getKind();
        TypeKind rightKind = right.getKind();
        if (leftKind == TypeKind.DOUBLE || rightKind == TypeKind.DOUBLE) {
            return TypeKind.DOUBLE;
        }
        if (leftKind == TypeKind.FLOAT || rightKind == TypeKind.FLOAT) {
            return TypeKind.FLOAT;
        }
        if (leftKind == TypeKind.LONG || rightKind == TypeKind.LONG) {
            return TypeKind.LONG;
        }
        return TypeKind.INT;
    }

    public static TypeMirror upperBound(TypeMirror type) {
        while (true) {
            WildcardType wc;
            if (type instanceof TypeVariable) {
                TypeVariable tvar = (TypeVariable)type;
                if (tvar.getUpperBound() == null) break;
                type = tvar.getUpperBound();
                continue;
            }
            if (!(type instanceof WildcardType) || (wc = (WildcardType)type).getExtendsBound() == null) break;
            type = wc.getExtendsBound();
        }
        return type;
    }

    public static TypeMirror typeFromClass(Types types, Elements elements, Class<?> clazz) {
        if (clazz == Void.TYPE) {
            return types.getNoType(TypeKind.VOID);
        }
        if (clazz.isPrimitive()) {
            String primitiveName = clazz.getName().toUpperCase();
            TypeKind primitiveKind = TypeKind.valueOf(primitiveName);
            return types.getPrimitiveType(primitiveKind);
        }
        if (clazz.isArray()) {
            TypeMirror componentType = TypesUtils.typeFromClass(types, elements, clazz.getComponentType());
            return types.getArrayType(componentType);
        }
        TypeElement element = elements.getTypeElement(clazz.getCanonicalName());
        if (element == null) {
            ErrorReporter.errorAbort("Unrecognized class: " + clazz);
            return null;
        }
        return element.asType();
    }

    public static ArrayType createArrayType(Types types, TypeMirror componentType) {
        JavacTypes t = (JavacTypes)types;
        return t.getArrayType(componentType);
    }
}

