/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.AbstractCompatibilityTransformer;
import org.codehaus.plexus.util.IOUtil;

public class AppendingTransformer
extends AbstractCompatibilityTransformer {
    String resource;
    ByteArrayOutputStream data = new ByteArrayOutputStream();
    private long time = Long.MIN_VALUE;

    @Override
    public boolean canTransformResource(String r) {
        return this.resource != null && this.resource.equalsIgnoreCase(r);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        IOUtil.copy(is, (OutputStream)this.data);
        this.data.write(10);
        if (time > this.time) {
            this.time = time;
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return this.data.size() > 0;
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        JarEntry jarEntry = new JarEntry(this.resource);
        jarEntry.setTime(this.time);
        jos.putNextEntry(jarEntry);
        jos.write(this.data.toByteArray());
        this.data.reset();
    }
}

