/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.flow.CFAbstractAnalysis;
import checkers.flow.CFAbstractStore;
import checkers.initialization.InitializationStore;
import checkers.nullness.NullnessValue;

public class NullnessStore
extends InitializationStore<NullnessValue, NullnessStore> {
    protected boolean isPolyNullNull;

    public NullnessStore(CFAbstractAnalysis<NullnessValue, NullnessStore, ?> analysis, boolean sequentialSemantics) {
        super(analysis, sequentialSemantics);
        this.isPolyNullNull = false;
    }

    public NullnessStore(NullnessStore s2) {
        super(s2);
        this.isPolyNullNull = s2.isPolyNullNull;
    }

    @Override
    public NullnessStore leastUpperBound(NullnessStore other) {
        NullnessStore lub = super.leastUpperBound(other);
        lub.isPolyNullNull = this.isPolyNullNull == other.isPolyNullNull ? this.isPolyNullNull : false;
        return lub;
    }

    @Override
    protected boolean supersetOf(CFAbstractStore<NullnessValue, NullnessStore> o) {
        if (!(o instanceof InitializationStore)) {
            return false;
        }
        NullnessStore other = (NullnessStore)o;
        if (other.isPolyNullNull != this.isPolyNullNull) {
            return false;
        }
        return super.supersetOf(other);
    }

    @Override
    protected void internalDotOutput(StringBuilder result) {
        super.internalDotOutput(result);
        result.append("  isPolyNonNull = " + this.isPolyNullNull + "\\n");
    }

    public boolean isPolyNullNull() {
        return this.isPolyNullNull;
    }

    public void setPolyNullNull(boolean isPolyNullNull) {
        this.isPolyNullNull = isPolyNullNull;
    }
}

