/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.scanners;

import java.lang.annotation.Annotation;
import java.net.URL;
import org.sonatype.guice.asm.AnnotationVisitor;
import org.sonatype.guice.asm.ClassVisitor;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.scanners.ClassSpaceVisitor;
import org.sonatype.guice.bean.scanners.EmptyClassVisitor;
import org.sonatype.guice.bean.scanners.QualifiedTypeListener;
import org.sonatype.guice.bean.scanners.QualifierCache;

public final class QualifiedTypeVisitor
extends EmptyClassVisitor
implements ClassSpaceVisitor {
    private final QualifierCache qualifierCache = new QualifierCache();
    private final QualifiedTypeListener listener;
    private ClassSpace space;
    private URL location;
    private String clazzName;
    private Class<?> clazz;

    public QualifiedTypeVisitor(QualifiedTypeListener listener) {
        this.listener = listener;
    }

    public void visit(ClassSpace _space) {
        this.space = _space;
    }

    public ClassVisitor visitClass(URL url) {
        this.location = url;
        this.clazzName = null;
        this.clazz = null;
        return this;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & (0x200 | access & 0x400 | 0x1000)) == 0) {
            this.clazzName = name;
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Class<Annotation> qualifierType;
        if (null != this.clazzName && null != (qualifierType = this.qualifierCache.qualify(this.space, desc))) {
            if (null == this.clazz) {
                this.clazz = this.space.loadClass(this.clazzName.replace('/', '.'));
            }
            this.listener.hear(this.clazz.getAnnotation(qualifierType), this.clazz, this.location.toString());
        }
        return null;
    }
}

