/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.binders;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import java.util.List;
import org.sonatype.guice.bean.inject.BeanBinder;
import org.sonatype.guice.bean.inject.PropertyBinder;
import org.sonatype.guice.plexus.binders.PlexusBeanManager;
import org.sonatype.guice.plexus.binders.PlexusPropertyBinder;
import org.sonatype.guice.plexus.config.PlexusBeanMetadata;
import org.sonatype.guice.plexus.config.PlexusBeanSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlexusBeanBinder
implements BeanBinder,
InjectionListener<Object> {
    private final PlexusBeanManager manager;
    private final PlexusBeanSource[] sources;

    PlexusBeanBinder(PlexusBeanManager manager, List<PlexusBeanSource> sources) {
        this.manager = manager;
        this.sources = sources.toArray(new PlexusBeanSource[sources.size()]);
    }

    @Override
    public <B> PropertyBinder bindBean(TypeLiteral<B> type, TypeEncounter<B> encounter) {
        Class<B> clazz = type.getRawType();
        if (null != this.manager && this.manager.manage(clazz)) {
            encounter.register(this);
        }
        for (PlexusBeanSource source : this.sources) {
            PlexusBeanMetadata metadata = source.getBeanMetadata(clazz);
            if (metadata == null) continue;
            return new PlexusPropertyBinder(this.manager, encounter, metadata);
        }
        return null;
    }

    @Override
    public void afterInjection(Object bean) {
        this.manager.manage(bean);
    }
}

