/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg;

import dataflow.analysis.AbstractValue;
import dataflow.analysis.Analysis;
import dataflow.analysis.Store;
import dataflow.analysis.TransferFunction;
import dataflow.analysis.TransferInput;
import dataflow.cfg.block.Block;
import dataflow.cfg.block.ConditionalBlock;
import dataflow.cfg.block.ExceptionBlock;
import dataflow.cfg.block.RegularBlock;
import dataflow.cfg.block.SingleSuccessorBlock;
import dataflow.cfg.block.SpecialBlock;
import dataflow.cfg.node.Node;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;

public class CFGDOTVisualizer {
    public static String visualize(Block entry) {
        return CFGDOTVisualizer.visualize(entry, null);
    }

    public static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> String visualize(Block entry, Analysis<A, S, T> analysis) {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        HashSet<Block> visited = new HashSet<Block>();
        LinkedList<Block> worklist = new LinkedList<Block>();
        Block cur = entry;
        visited.add(entry);
        sb1.append("digraph {\n");
        sb1.append("    node [shape=rectangle];\n\n");
        while (cur != null) {
            if (cur.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                ConditionalBlock ccur = (ConditionalBlock)cur;
                Block block = ccur.getThenSuccessor();
                sb2.append("    " + ccur.getId() + " -> " + block.getId());
                sb2.append(" [label=\"then\\n" + (Object)((Object)ccur.getThenFlowRule()) + "\"];\n");
                if (!visited.contains(block)) {
                    visited.add(block);
                    worklist.add(block);
                }
                Block block2 = ccur.getElseSuccessor();
                sb2.append("    " + ccur.getId() + " -> " + block2.getId());
                sb2.append(" [label=\"else\\n" + (Object)((Object)ccur.getElseFlowRule()) + "\"];\n");
                if (!visited.contains(block2)) {
                    visited.add(block2);
                    worklist.add(block2);
                }
            } else {
                assert (cur instanceof SingleSuccessorBlock);
                Block b = ((SingleSuccessorBlock)cur).getSuccessor();
                if (b != null) {
                    sb2.append("    " + cur.getId() + " -> " + b.getId());
                    sb2.append(" [label=\"" + (Object)((Object)((SingleSuccessorBlock)cur).getFlowRule()) + "\"];\n");
                    if (!visited.contains(b)) {
                        visited.add(b);
                        worklist.add(b);
                    }
                }
            }
            if (cur.getType() == Block.BlockType.EXCEPTION_BLOCK) {
                ExceptionBlock ecur = (ExceptionBlock)cur;
                for (Map.Entry<TypeMirror, Set<Block>> entry2 : ecur.getExceptionalSuccessors().entrySet()) {
                    Set<Block> blocks = entry2.getValue();
                    TypeMirror cause = entry2.getKey();
                    String exception = cause.toString();
                    if (exception.startsWith("java.lang.")) {
                        exception = exception.replace("java.lang.", "");
                    }
                    for (Block b : blocks) {
                        sb2.append("    " + cur.getId() + " -> " + b.getId());
                        sb2.append(" [label=\"" + exception + "\"];\n");
                        if (visited.contains(b)) continue;
                        visited.add(b);
                        worklist.add(b);
                    }
                }
            }
            cur = (Block)worklist.poll();
        }
        for (Block block : visited) {
            sb1.append("    " + block.getId() + " [");
            if (block.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                sb1.append("shape=polygon sides=8 ");
            } else if (block.getType() == Block.BlockType.SPECIAL_BLOCK) {
                sb1.append("shape=oval ");
            }
            sb1.append("label=\"" + CFGDOTVisualizer.visualizeContent(block, analysis).replace("\\n", "\\l") + "\",];\n");
        }
        sb1.append("\n");
        sb1.append((CharSequence)sb2);
        sb1.append("}\n");
        return sb1.toString();
    }

    protected static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> String visualizeContent(Block bb, Analysis<A, S, T> analysis) {
        StringBuilder sb = new StringBuilder();
        LinkedList<Node> contents = new LinkedList<Node>();
        switch (bb.getType()) {
            case REGULAR_BLOCK: {
                contents.addAll(((RegularBlock)bb).getContents());
                break;
            }
            case EXCEPTION_BLOCK: {
                contents.add(((ExceptionBlock)bb).getNode());
                break;
            }
            case CONDITIONAL_BLOCK: {
                break;
            }
            case SPECIAL_BLOCK: {
                break;
            }
            default: {
                assert (false) : "All types of basic blocks covered";
                break;
            }
        }
        boolean notFirst = false;
        for (Node t : contents) {
            if (notFirst) {
                sb.append("\\n");
            }
            notFirst = true;
            sb.append(CFGDOTVisualizer.prepareString(CFGDOTVisualizer.visualizeNode(t, analysis)));
        }
        boolean centered = false;
        if (sb.length() == 0) {
            centered = true;
            if (bb.getType() == Block.BlockType.SPECIAL_BLOCK) {
                SpecialBlock sbb = (SpecialBlock)bb;
                switch (sbb.getSpecialType()) {
                    case ENTRY: {
                        sb.append("<entry>");
                        break;
                    }
                    case EXIT: {
                        sb.append("<exit>");
                        break;
                    }
                    case EXCEPTIONAL_EXIT: {
                        sb.append("<exceptional-exit>");
                    }
                }
            } else {
                if (bb.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                    return "";
                }
                return "?? empty ??";
            }
        }
        if (analysis != null) {
            TransferInput<A, S> input = analysis.getInput(bb);
            StringBuilder sb2 = new StringBuilder();
            String s2 = input.toDOToutput().replace("}, else={", "}\\nelse={");
            sb2.append(s2.subSequence(1, s2.length() - 1));
            sb2.append("\\n~~~~~~~~~\\n");
            sb2.append((CharSequence)sb);
            sb = sb2;
        }
        return sb.toString() + (centered ? "" : "\\n");
    }

    protected static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> String visualizeNode(Node t, Analysis<A, S, T> analysis) {
        A value = analysis.getValue(t);
        String valueInfo = "";
        if (value != null) {
            valueInfo = "    > " + value.toString();
        }
        return t.toString() + "   [ " + CFGDOTVisualizer.visualizeType(t) + " ]" + valueInfo;
    }

    protected static String visualizeType(Node t) {
        String name = t.getClass().getSimpleName();
        return name.replace("Node", "");
    }

    protected static String prepareString(String s2) {
        return s2.replace("\"", "\\\"");
    }
}

