/*
 * Decompiled with CFR 0.152.
 */
package checkers.util;

import checkers.quals.ConditionalPostconditionAnnotation;
import checkers.quals.EnsuresQualifier;
import checkers.quals.EnsuresQualifierIf;
import checkers.quals.EnsuresQualifiers;
import checkers.quals.EnsuresQualifiersIf;
import checkers.quals.PostconditionAnnotation;
import checkers.quals.PreconditionAnnotation;
import checkers.quals.RequiresQualifier;
import checkers.quals.RequiresQualifiers;
import checkers.types.AbstractBasicAnnotatedTypeFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javacutils.AnnotationUtils;
import javacutils.Pair;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;

public class ContractsUtils {
    protected static ContractsUtils instance;
    protected AbstractBasicAnnotatedTypeFactory<?, ?, ?, ?> factory;

    public static ContractsUtils getInstance(AbstractBasicAnnotatedTypeFactory<?, ?, ?, ?> factory) {
        if (instance == null || ContractsUtils.instance.factory != factory) {
            instance = new ContractsUtils(factory);
        }
        return instance;
    }

    public Set<Pair<String, String>> getPreconditions(ExecutableElement methodElement) {
        HashSet<Pair<String, String>> result = new HashSet<Pair<String, String>>();
        AnnotationMirror requiresAnnotation = this.factory.getDeclAnnotation(methodElement, RequiresQualifier.class);
        result.addAll(this.getPrecondition(requiresAnnotation));
        AnnotationMirror requiresAnnotations = this.factory.getDeclAnnotation(methodElement, RequiresQualifiers.class);
        if (requiresAnnotations != null) {
            List<AnnotationMirror> annotations = AnnotationUtils.getElementValueArray(requiresAnnotations, "value", AnnotationMirror.class, false);
            for (AnnotationMirror a : annotations) {
                result.addAll(this.getPrecondition(a));
            }
        }
        Class<PreconditionAnnotation> metaAnnotation = PreconditionAnnotation.class;
        List<Pair<AnnotationMirror, AnnotationMirror>> declAnnotations = this.factory.getDeclAnnotationWithMetaAnnotation(methodElement, metaAnnotation);
        for (Pair<AnnotationMirror, AnnotationMirror> r : declAnnotations) {
            AnnotationMirror anno = (AnnotationMirror)r.first;
            AnnotationMirror metaAnno = (AnnotationMirror)r.second;
            List<String> expressions = AnnotationUtils.getElementValueArray(anno, "value", String.class, false);
            String annotationString = AnnotationUtils.getElementValueClassName(metaAnno, "qualifier", false).toString();
            for (String expr : expressions) {
                result.add(Pair.of(expr, annotationString));
            }
        }
        return result;
    }

    private Set<Pair<String, String>> getPrecondition(AnnotationMirror requiresAnnotation) {
        if (requiresAnnotation == null) {
            return Collections.emptySet();
        }
        HashSet<Pair<String, String>> result = new HashSet<Pair<String, String>>();
        List<String> expressions = AnnotationUtils.getElementValueArray(requiresAnnotation, "expression", String.class, false);
        String annotation = AnnotationUtils.getElementValueClassName(requiresAnnotation, "qualifier", false).toString();
        for (String expr : expressions) {
            result.add(Pair.of(expr, annotation));
        }
        return result;
    }

    public Set<Pair<String, String>> getPostconditions(ExecutableElement methodElement) {
        HashSet<Pair<String, String>> result = new HashSet<Pair<String, String>>();
        AnnotationMirror ensuresAnnotation = this.factory.getDeclAnnotation(methodElement, EnsuresQualifier.class);
        result.addAll(this.getPostcondition(ensuresAnnotation));
        AnnotationMirror ensuresAnnotations = this.factory.getDeclAnnotation(methodElement, EnsuresQualifiers.class);
        if (ensuresAnnotations != null) {
            List<AnnotationMirror> annotations = AnnotationUtils.getElementValueArray(ensuresAnnotations, "value", AnnotationMirror.class, false);
            for (AnnotationMirror a : annotations) {
                result.addAll(this.getPostcondition(a));
            }
        }
        Class<PostconditionAnnotation> metaAnnotation = PostconditionAnnotation.class;
        List<Pair<AnnotationMirror, AnnotationMirror>> declAnnotations = this.factory.getDeclAnnotationWithMetaAnnotation(methodElement, metaAnnotation);
        for (Pair<AnnotationMirror, AnnotationMirror> r : declAnnotations) {
            AnnotationMirror anno = (AnnotationMirror)r.first;
            AnnotationMirror metaAnno = (AnnotationMirror)r.second;
            List<String> expressions = AnnotationUtils.getElementValueArray(anno, "value", String.class, false);
            String annotationString = AnnotationUtils.getElementValueClassName(metaAnno, "qualifier", false).toString();
            for (String expr : expressions) {
                result.add(Pair.of(expr, annotationString));
            }
        }
        return result;
    }

    private Set<Pair<String, String>> getPostcondition(AnnotationMirror ensuresAnnotation) {
        if (ensuresAnnotation == null) {
            return Collections.emptySet();
        }
        HashSet<Pair<String, String>> result = new HashSet<Pair<String, String>>();
        List<String> expressions = AnnotationUtils.getElementValueArray(ensuresAnnotation, "expression", String.class, false);
        String annotation = AnnotationUtils.getElementValueClassName(ensuresAnnotation, "qualifier", false).toString();
        for (String expr : expressions) {
            result.add(Pair.of(expr, annotation));
        }
        return result;
    }

    public Set<Pair<String, Pair<Boolean, String>>> getConditionalPostconditions(ExecutableElement methodElement) {
        HashSet<Pair<String, Pair<Boolean, String>>> result = new HashSet<Pair<String, Pair<Boolean, String>>>();
        AnnotationMirror ensuresAnnotationIf = this.factory.getDeclAnnotation(methodElement, EnsuresQualifierIf.class);
        result.addAll(this.getConditionalPostcondition(ensuresAnnotationIf));
        AnnotationMirror ensuresAnnotationsIf = this.factory.getDeclAnnotation(methodElement, EnsuresQualifiersIf.class);
        if (ensuresAnnotationsIf != null) {
            List<AnnotationMirror> annotations = AnnotationUtils.getElementValueArray(ensuresAnnotationsIf, "value", AnnotationMirror.class, false);
            for (AnnotationMirror a : annotations) {
                result.addAll(this.getConditionalPostcondition(a));
            }
        }
        Class<ConditionalPostconditionAnnotation> metaAnnotation = ConditionalPostconditionAnnotation.class;
        List<Pair<AnnotationMirror, AnnotationMirror>> declAnnotations = this.factory.getDeclAnnotationWithMetaAnnotation(methodElement, metaAnnotation);
        for (Pair<AnnotationMirror, AnnotationMirror> r : declAnnotations) {
            AnnotationMirror anno = (AnnotationMirror)r.first;
            AnnotationMirror metaAnno = (AnnotationMirror)r.second;
            List<String> expressions = AnnotationUtils.getElementValueArray(anno, "expression", String.class, false);
            String annotationString = AnnotationUtils.getElementValueClassName(metaAnno, "qualifier", false).toString();
            boolean annoResult = AnnotationUtils.getElementValue(anno, "result", Boolean.class, false);
            for (String expr : expressions) {
                result.add(Pair.of(expr, Pair.of(annoResult, annotationString)));
            }
        }
        return result;
    }

    private Set<Pair<String, Pair<Boolean, String>>> getConditionalPostcondition(AnnotationMirror ensuresAnnotationIf) {
        if (ensuresAnnotationIf == null) {
            return Collections.emptySet();
        }
        HashSet<Pair<String, Pair<Boolean, String>>> result = new HashSet<Pair<String, Pair<Boolean, String>>>();
        List<String> expressions = AnnotationUtils.getElementValueArray(ensuresAnnotationIf, "expression", String.class, false);
        String annotation = AnnotationUtils.getElementValueClassName(ensuresAnnotationIf, "qualifier", false).toString();
        boolean annoResult = AnnotationUtils.getElementValue(ensuresAnnotationIf, "result", Boolean.class, false);
        for (String expr : expressions) {
            result.add(Pair.of(expr, Pair.of(annoResult, annotation)));
        }
        return result;
    }

    private ContractsUtils(AbstractBasicAnnotatedTypeFactory<?, ?, ?, ?> factory) {
        this.factory = factory;
    }
}

