/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2;

import bbd.jportal2.Database;
import bbd.jportal2.IBuiltInGenerator;
import bbd.jportal2.JPortal;
import bbd.jportal2.PathHelpers;
import bbd.jportal2.SingleFileCompilerException;
import bbd.jportal2.Table;
import bbd.jportal2.generators.FreeMarker.FreeMarker;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFileCompiler {
    private static final Logger logger = LoggerFactory.getLogger(SingleFileCompiler.class);
    private List<String> templateLocations;

    public int compile(String source, List<String> compilerFlags, List<String> builtinSIProcessors, List<String> templateBasedSIProcessors, List<String> builtinPostProcessors, List<String> templateBasedPostProcessors, List<String> templateLocations, Boolean preCompile) throws Exception {
        this.templateLocations = templateLocations;
        String[] pieces = source.split("\\+");
        Database database = JPortal.database;
        boolean hasErrors = false;
        for (String piece : pieces) {
            String nubDir = "";
            database = JPortal.run(piece, nubDir);
            if (database != null) continue;
            logger.error("::>" + piece + "<:: compile has errors");
            hasErrors = true;
        }
        if (hasErrors) {
            logger.error("Error while parsing DB...");
            return 1;
        }
        for (String flag : compilerFlags) {
            if (database.flags.contains(flag)) continue;
            database.flags.addElement(flag);
        }
        if (preCompile.booleanValue()) {
            return 0;
        }
        for (String generator : builtinSIProcessors) {
            if (this.ExecuteBuiltinGenerator(database, JPortal.table, generator)) continue;
            return 1;
        }
        for (String templateGenerator : templateBasedSIProcessors) {
            if (this.ExecuteTemplateGenerator(database, JPortal.table, templateGenerator)) continue;
            return 1;
        }
        for (String generator : builtinPostProcessors) {
            if (this.ExecuteBuiltinGenerator(database, JPortal.table, generator)) continue;
            return 1;
        }
        for (String templateGenerator : templateBasedPostProcessors) {
            if (this.ExecuteTemplateGenerator(database, JPortal.table, templateGenerator)) continue;
            return 1;
        }
        return 0;
    }

    private boolean ExecuteTemplateGenerator(Database database, Table table, String templateGenerator) throws Exception {
        if (!templateGenerator.contains(":") || templateGenerator.split(":").length < 2) {
            logger.error("Error in template-generator parameter. The correct format is --template-generator=<name>:<output_directory>, but --template-generator='{}' was specified instead.", (Object)templateGenerator);
            return false;
        }
        GeneratorParameters generatorParameters = new GeneratorParameters(templateGenerator).extractParametersFromOption();
        String generatorName = generatorParameters.getGeneratorName();
        String generatorDirectory = generatorParameters.getGeneratorDirectory();
        logger.info("Executing: " + generatorName);
        String templateBaseDir = null;
        for (String dirToSearch : this.templateLocations) {
            Path fullGeneratorPath;
            if (generatorName.indexOf(".") > 0) {
                generatorName = generatorName.substring(0, generatorName.lastIndexOf("."));
            }
            if (!this.isTemplateOnDiskOrInJar((fullGeneratorPath = Paths.get(dirToSearch, generatorName)).toString()).booleanValue()) continue;
            templateBaseDir = dirToSearch;
            break;
        }
        if (templateBaseDir == null) {
            StringBuilder templateLocationsAsString = new StringBuilder();
            templateLocationsAsString.append('\n');
            this.templateLocations.forEach(name -> {
                templateLocationsAsString.append((String)name);
                templateLocationsAsString.append('\n');
            });
            throw new SingleFileCompilerException(String.format("Template %1$s does not exist. Make sure a directory called %1$s exists in one of the template locations. See the --template-location option for more information.\\nThe templateLocation is currently set to: %2$s", generatorName, templateLocationsAsString.toString()));
        }
        logger.info("Executing generator [{}] found in [{}]", (Object)generatorName, (Object)templateBaseDir);
        PathHelpers.createOutputDirectory(generatorDirectory, logger);
        generatorDirectory = PathHelpers.addTrailingSlash(generatorDirectory);
        File templateLocationFile = Paths.get(templateBaseDir, new String[0]).toFile();
        try {
            FreeMarker fm = new FreeMarker();
            fm.generateTemplate(database, table, templateLocationFile.getAbsolutePath(), generatorName, new File(generatorDirectory));
            database.addGeneratedOutputFiles(fm.getGeneratedOutputFiles());
        }
        catch (Exception e) {
            logger.error("Error executing {}", (Object)generatorName, (Object)e);
            return false;
        }
        return true;
    }

    private boolean ExecuteBuiltinGenerator(Database database, Table table, String generator) throws Exception {
        IBuiltInGenerator instanceOfC;
        GeneratorParameters generatorParameters = new GeneratorParameters(generator).extractParametersFromOption();
        String generatorName = generatorParameters.getGeneratorName();
        String generatorDirectory = generatorParameters.getGeneratorDirectory();
        logger.info("Executing: " + generatorName);
        PathHelpers.createOutputDirectory(generatorDirectory, logger);
        generatorDirectory = PathHelpers.addTrailingSlash(generatorDirectory);
        try {
            Class<?> c = Class.forName("bbd.jportal2.generators." + generatorName);
            instanceOfC = (IBuiltInGenerator)c.newInstance();
        }
        catch (ClassNotFoundException cnf) {
            logger.error("Could not find generator {}. Make sure there is a class bbd.jportal2.generators.{}", (Object)generatorName);
            return false;
        }
        instanceOfC.generate(database, generatorDirectory);
        database.addGeneratedOutputFiles(instanceOfC.getGeneratedOutputFiles());
        return true;
    }

    private Boolean isTemplateOnDiskOrInJar(String fullGeneratorPath) throws Exception {
        if (Files.exists(Paths.get(fullGeneratorPath, new String[0]), new LinkOption[0])) {
            return true;
        }
        fullGeneratorPath = fullGeneratorPath.replace(File.separator, "/");
        URL url = this.getClass().getResource(fullGeneratorPath);
        if (url != null) {
            return true;
        }
        return false;
    }

    private class GeneratorParameters {
        private final String generator;
        private String generatorName;
        private String generatorDirectory;

        GeneratorParameters(String generator) {
            this.generator = generator;
        }

        String getGeneratorName() {
            return this.generatorName;
        }

        String getGeneratorDirectory() {
            return this.generatorDirectory;
        }

        GeneratorParameters extractParametersFromOption() {
            int strchr = this.generator.indexOf(58);
            if (strchr != -1) {
                this.generatorName = this.generator.substring(0, strchr);
                this.generatorDirectory = this.generator.substring(strchr + 1, this.generator.length());
                return this;
            }
            throw new RuntimeException();
        }
    }
}

