/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2;

import bbd.jportal2.Const;
import bbd.jportal2.Database;
import bbd.jportal2.Field;
import bbd.jportal2.Grant;
import bbd.jportal2.Key;
import bbd.jportal2.Line;
import bbd.jportal2.Link;
import bbd.jportal2.Misc;
import bbd.jportal2.Parameter;
import bbd.jportal2.Proc;
import bbd.jportal2.View;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Table.class);
    private static final long serialVersionUID = 1L;
    public Database database;
    public String literalName = "";
    public String name = "";
    public String alias = "";
    public String check = "";
    public Vector<Field> fields = new Vector();
    public Vector<Key> keys = new Vector();
    public Vector<Link> links = new Vector();
    public Vector<Grant> grants = new Vector();
    public Vector<View> views = new Vector();
    public Vector<Proc> procs = new Vector();
    public Vector<String> comments = new Vector();
    public Vector<String> options = new Vector();
    public Vector<String> allUsers = new Vector();
    public Vector<Parameter> parameters = new Vector();
    public Vector<Const> consts = new Vector();
    public boolean hasPrimaryKey = false;
    public boolean hasSequence = false;
    public boolean hasTimeStamp = false;
    public boolean hasAutoTimeStamp = false;
    public boolean hasUserStamp = false;
    public boolean hasExecute = false;
    public boolean hasSelect = false;
    public boolean hasInsert = false;
    public boolean hasDelete = false;
    public boolean hasUpdate = false;
    public boolean hasStdProcs = false;
    public boolean hasIdentity = false;
    public boolean hasSequenceReturning = false;
    public boolean hasBigXML = false;
    public boolean hasBigJSON = false;
    public boolean isStoredProc = false;
    public boolean isLiteral = false;
    public int start = 0;

    static boolean isIdentity(Field field) {
        return field.type == 25 || field.type == 10;
    }

    static boolean isSequence(Field field) {
        return field.type == 24 || field.type == 14;
    }

    static String varType(Field field) {
        switch (field.type) {
            case 3: {
                return "SMALLINT";
            }
            case 15: {
                return "SMALLINT";
            }
            case 10: 
            case 11: 
            case 14: {
                return "INT";
            }
            case 12: 
            case 24: 
            case 25: {
                return "BIGINT";
            }
            case 4: {
                if (field.length > 32762) {
                    return "CLOB(" + String.valueOf(field.length) + ")";
                }
                return "VARCHAR(" + String.valueOf(field.length) + ")";
            }
            case 21: {
                return "CHAR(" + String.valueOf(field.length) + ")";
            }
            case 5: {
                return "DATE";
            }
            case 6: {
                return "TIMESTAMP";
            }
            case 17: {
                return "TIME";
            }
            case 18: 
            case 26: {
                return "TIMESTAMP";
            }
            case 7: 
            case 9: {
                if (field.scale != 0) {
                    return "DECIMAL(" + String.valueOf(field.precision) + ", " + String.valueOf(field.scale) + ")";
                }
                if (field.precision != 0) {
                    return "DECIMAL(" + String.valueOf(field.precision) + ", 0)";
                }
                return "DOUBLE";
            }
            case 1: {
                return "BLOB(" + String.valueOf(field.length) + ")";
            }
            case 19: {
                return "CLOB(" + String.valueOf(field.length) + ")";
            }
            case 13: {
                return "DECIMAL(18,2)";
            }
            case 20: {
                return "VARCHAR(50)";
            }
            case 23: {
                return "XML";
            }
            case 31: 
            case 32: {
                return "JSON";
            }
        }
        return "unknown";
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getLiteralName() {
        return this.literalName;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getCheck() {
        return this.check;
    }

    public Vector<Field> getFields() {
        return this.fields;
    }

    public Link getLinkForField(Field field) {
        for (Link link : this.getLinks()) {
            if (link.fields.size() < 1) {
                System.out.println("ERR");
                continue;
            }
            if (link.getFields().get(0).compareTo(field.name) != 0) continue;
            return link;
        }
        return null;
    }

    public Field getFieldForLink(Link link) {
        for (Field field : this.getFields()) {
            if (link.getFields().get(0).compareTo(field.name) != 0) continue;
            return field;
        }
        return null;
    }

    public Vector<Key> getKeys() {
        return this.keys;
    }

    public Vector<Link> getLinks() {
        return this.links;
    }

    public Vector<Grant> getGrants() {
        return this.grants;
    }

    public Vector<View> getViews() {
        return this.views;
    }

    public Vector<Proc> getProcs() {
        return this.procs;
    }

    public Vector<String> getComments() {
        return this.comments;
    }

    public Vector<String> getOptions() {
        return this.options;
    }

    public Vector<String> getAllUsers() {
        return this.allUsers;
    }

    public Vector<Parameter> getParameters() {
        return this.parameters;
    }

    public Vector<Const> getConsts() {
        return this.consts;
    }

    public boolean isHasPrimaryKey() {
        return this.hasPrimaryKey;
    }

    public boolean isHasSequence() {
        return this.hasSequence;
    }

    public boolean isHasTimeStamp() {
        return this.hasTimeStamp;
    }

    public boolean isHasAutoTimeStamp() {
        return this.hasAutoTimeStamp;
    }

    public boolean isHasUserStamp() {
        return this.hasUserStamp;
    }

    public boolean isHasExecute() {
        return this.hasExecute;
    }

    public boolean isHasSelect() {
        return this.hasSelect;
    }

    public boolean isHasInsert() {
        return this.hasInsert;
    }

    public boolean isHasDelete() {
        return this.hasDelete;
    }

    public boolean isHasUpdate() {
        return this.hasUpdate;
    }

    public boolean isHasStdProcs() {
        return this.hasStdProcs;
    }

    public boolean isHasIdentity() {
        return this.hasIdentity;
    }

    public boolean isHasSequenceReturning() {
        return this.hasSequenceReturning;
    }

    public boolean hasBigXML() {
        return this.hasBigXML;
    }

    public boolean hasBigJSON() {
        return this.hasBigJSON;
    }

    public boolean isStoredProc() {
        return this.isStoredProc;
    }

    public boolean isLiteral() {
        return this.isLiteral;
    }

    public void reader(DataInputStream ids) throws IOException {
        this.reader(ids, null);
    }

    public void reader(DataInputStream ids, Vector<?> useProcs) throws IOException {
        Object value;
        int i;
        int signature = ids.readInt();
        if (signature != 195797005) {
            return;
        }
        this.name = ids.readUTF();
        this.literalName = ids.readUTF();
        this.alias = ids.readUTF();
        this.check = ids.readUTF();
        int noOf = ids.readInt();
        for (i = 0; i < noOf; ++i) {
            value = new Field();
            ((Field)value).reader(ids);
            this.fields.addElement((Field)value);
        }
        noOf = ids.readInt();
        for (i = 0; i < noOf; ++i) {
            value = new Key();
            ((Key)value).reader(ids);
            this.keys.addElement((Key)value);
        }
        noOf = ids.readInt();
        for (i = 0; i < noOf; ++i) {
            value = new Link();
            ((Link)value).reader(ids);
            this.links.addElement((Link)value);
        }
        noOf = ids.readInt();
        for (i = 0; i < noOf; ++i) {
            value = new Grant();
            ((Grant)value).reader(ids);
            this.grants.addElement((Grant)value);
        }
        noOf = ids.readInt();
        for (i = 0; i < noOf; ++i) {
            value = new View();
            ((View)value).reader(ids);
            this.views.addElement((View)value);
        }
        noOf = ids.readInt();
        block5: for (i = 0; i < noOf; ++i) {
            value = new Proc();
            ((Proc)value).reader(ids);
            if (useProcs == null) {
                this.procs.addElement((Proc)value);
                continue;
            }
            for (int p = 0; p < useProcs.size(); ++p) {
                String name = (String)useProcs.elementAt(p);
                if (((Proc)value).name.compareToIgnoreCase(name) != 0) continue;
                this.procs.addElement((Proc)value);
                continue block5;
            }
        }
        noOf = ids.readInt();
        for (i = 0; i < noOf; ++i) {
            value = ids.readUTF();
            this.comments.addElement((String)value);
        }
        noOf = ids.readInt();
        for (i = 0; i < noOf; ++i) {
            value = ids.readUTF();
            this.options.addElement((String)value);
        }
        noOf = ids.readInt();
        for (i = 0; i < noOf; ++i) {
            value = new Parameter();
            ((Parameter)value).table = this;
            ((Parameter)value).reader(ids);
            this.parameters.addElement((Parameter)value);
        }
        noOf = ids.readInt();
        for (i = 0; i < noOf; ++i) {
            value = new Const();
            ((Const)value).reader(ids);
            this.consts.addElement((Const)value);
        }
        this.hasExecute = ids.readBoolean();
        this.hasSelect = ids.readBoolean();
        this.hasInsert = ids.readBoolean();
        this.hasDelete = ids.readBoolean();
        this.hasUpdate = ids.readBoolean();
        this.hasPrimaryKey = ids.readBoolean();
        this.hasSequence = ids.readBoolean();
        this.hasTimeStamp = ids.readBoolean();
        this.hasAutoTimeStamp = ids.readBoolean();
        this.hasUserStamp = ids.readBoolean();
        this.hasStdProcs = ids.readBoolean();
        this.hasIdentity = ids.readBoolean();
        this.hasSequenceReturning = ids.readBoolean();
        this.isStoredProc = ids.readBoolean();
        this.isLiteral = ids.readBoolean();
        this.start = ids.readInt();
    }

    public void writer(DataOutputStream ods) throws IOException {
        Object value;
        int i;
        Serializable value2;
        int i2;
        ods.writeInt(195797005);
        ods.writeUTF(this.name);
        ods.writeUTF(this.literalName);
        ods.writeUTF(this.alias);
        ods.writeUTF(this.check);
        ods.writeInt(this.fields.size());
        for (i2 = 0; i2 < this.fields.size(); ++i2) {
            value2 = this.fields.elementAt(i2);
            ((Field)value2).writer(ods);
        }
        ods.writeInt(this.keys.size());
        for (i2 = 0; i2 < this.keys.size(); ++i2) {
            value2 = this.keys.elementAt(i2);
            ((Key)value2).writer(ods);
        }
        ods.writeInt(this.links.size());
        for (i2 = 0; i2 < this.links.size(); ++i2) {
            value2 = this.links.elementAt(i2);
            ((Link)value2).writer(ods);
        }
        ods.writeInt(this.grants.size());
        for (i2 = 0; i2 < this.grants.size(); ++i2) {
            value2 = this.grants.elementAt(i2);
            ((Grant)value2).writer(ods);
        }
        ods.writeInt(this.views.size());
        for (i2 = 0; i2 < this.views.size(); ++i2) {
            value2 = this.views.elementAt(i2);
            ((View)value2).writer(ods);
        }
        int noProcs = 0;
        for (i = 0; i < this.procs.size(); ++i) {
            value = this.procs.elementAt(i);
            if (((Proc)value).isData) continue;
            ++noProcs;
        }
        ods.writeInt(noProcs);
        for (i = 0; i < this.procs.size(); ++i) {
            value = this.procs.elementAt(i);
            if (((Proc)value).isData) continue;
            ((Proc)value).writer(ods);
        }
        ods.writeInt(this.comments.size());
        for (i = 0; i < this.comments.size(); ++i) {
            value = this.comments.elementAt(i);
            ods.writeUTF((String)value);
        }
        ods.writeInt(this.options.size());
        for (i = 0; i < this.options.size(); ++i) {
            value = this.options.elementAt(i);
            ods.writeUTF((String)value);
        }
        ods.writeInt(this.parameters.size());
        for (i = 0; i < this.parameters.size(); ++i) {
            value = this.parameters.elementAt(i);
            ((Parameter)value).table = this;
            ((Parameter)value).writer(ods);
        }
        ods.writeInt(this.consts.size());
        for (i = 0; i < this.consts.size(); ++i) {
            value = this.consts.elementAt(i);
            ((Const)value).writer(ods);
        }
        ods.writeBoolean(this.hasExecute);
        ods.writeBoolean(this.hasSelect);
        ods.writeBoolean(this.hasInsert);
        ods.writeBoolean(this.hasDelete);
        ods.writeBoolean(this.hasUpdate);
        ods.writeBoolean(this.hasPrimaryKey);
        ods.writeBoolean(this.hasSequence);
        ods.writeBoolean(this.hasTimeStamp);
        ods.writeBoolean(this.hasAutoTimeStamp);
        ods.writeBoolean(this.hasUserStamp);
        ods.writeBoolean(this.hasStdProcs);
        ods.writeBoolean(this.hasIdentity);
        ods.writeBoolean(this.hasSequenceReturning);
        ods.writeBoolean(this.isStoredProc);
        ods.writeBoolean(this.isLiteral);
        ods.writeInt(this.start);
    }

    public String useLiteral() {
        if (this.isLiteral) {
            return this.literalName;
        }
        return this.name;
    }

    public String useName() {
        if (this.alias.length() > 0) {
            return this.alias;
        }
        return this.name;
    }

    public boolean hasField(String s2) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.elementAt(i);
            if (!field.name.equalsIgnoreCase(s2)) continue;
            return true;
        }
        return false;
    }

    public Field getField(String s2) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.elementAt(i);
            if (!field.name.equalsIgnoreCase(s2)) continue;
            return field;
        }
        return null;
    }

    public int getFieldIndex(String s2) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.elementAt(i);
            if (!field.name.equalsIgnoreCase(s2)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasFieldAsNull(String s2) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.elementAt(i);
            if (!field.name.equalsIgnoreCase(s2)) continue;
            return field.isNull;
        }
        return false;
    }

    public boolean hasProc(Proc p) {
        for (int i = 0; i < this.procs.size(); ++i) {
            Proc proc = this.procs.elementAt(i);
            if (!proc.name.equalsIgnoreCase(p.name)) continue;
            return true;
        }
        return false;
    }

    public Proc getProc(String name) {
        for (int i = 0; i < this.procs.size(); ++i) {
            Proc proc = this.procs.elementAt(i);
            if (!proc.name.equalsIgnoreCase(name)) continue;
            return proc;
        }
        return null;
    }

    public boolean hasCursorStdProc() {
        for (int i = 0; i < this.procs.size(); ++i) {
            Proc proc = this.procs.elementAt(i);
            if (!proc.isStd || proc.isSingle || proc.outputs.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public void setPrimary(String s2) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.elementAt(i);
            if (!field.name.equalsIgnoreCase(s2)) continue;
            field.isPrimaryKey = true;
            return;
        }
    }

    public String tableName() {
        if (this.database.schema.length() == 0) {
            if (this.isLiteral) {
                return this.literalName;
            }
            return this.name;
        }
        if (this.isLiteral) {
            return this.database.schema + "." + this.literalName;
        }
        return this.database.schema + "." + this.name;
    }

    public void buildMerge(Proc proc) {
        Field field;
        int i;
        String name = this.tableName();
        String comma = "  ";
        String front = "  ";
        proc.isStd = true;
        proc.isSql = true;
        proc.lines.addElement(new Line(Misc.generateProcNameComment(proc)));
        proc.lines.addElement(new Line("merge into " + name));
        proc.lines.addElement(new Line("using table"));
        proc.lines.addElement(new Line("      ("));
        proc.lines.addElement(new Line("        values"));
        proc.lines.addElement(new Line("        ("));
        for (i = 0; i < this.fields.size(); ++i) {
            field = this.fields.elementAt(i);
            proc.lines.addElement(new Line("        " + comma + "cast(" + field.useLiteral() + " as " + Table.varType(field) + ")"));
            proc.inputs.addElement(field);
            comma = ", ";
        }
        proc.lines.addElement(new Line("        )"));
        proc.lines.addElement(new Line("      )"));
        proc.lines.addElement(new Line("      temp_" + proc.table.name));
        proc.lines.addElement(new Line("      ("));
        comma = "  ";
        for (i = 0; i < this.fields.size(); ++i) {
            field = this.fields.elementAt(i);
            proc.lines.addElement(new Line("      " + comma + field.useLiteral()));
            comma = ", ";
        }
        proc.lines.addElement(new Line("      )"));
        front = "on  ";
        for (i = 0; i < this.fields.size(); ++i) {
            field = this.fields.elementAt(i);
            if (!field.isPrimaryKey) continue;
            proc.lines.addElement(new Line(front + name + "" + field.useLiteral() + " = temp_" + proc.table.name + "." + field.useLiteral()));
            front = "and ";
        }
        proc.lines.addElement(new Line("when matched then"));
        proc.lines.addElement(new Line("  update set"));
        comma = "    ";
        for (i = 0; i < this.fields.size(); ++i) {
            field = this.fields.elementAt(i);
            if (field.isPrimaryKey) continue;
            proc.lines.addElement(new Line(comma + name + "" + field.useLiteral() + " = temp_" + proc.table.name + "." + field.useLiteral()));
            comma = "  , ";
        }
        proc.lines.addElement(new Line("when not matched then"));
        proc.lines.addElement(new Line("  insert"));
        proc.lines.addElement(new Line("  ("));
        comma = "    ";
        for (i = 0; i < this.fields.size(); ++i) {
            field = this.fields.elementAt(i);
            proc.lines.addElement(new Line(comma + field.useLiteral()));
            comma = "  , ";
        }
        proc.lines.addElement(new Line("  )"));
        proc.lines.addElement(new Line("  values"));
        proc.lines.addElement(new Line("  ("));
        comma = "    ";
        for (i = 0; i < this.fields.size(); ++i) {
            field = this.fields.elementAt(i);
            proc.lines.addElement(new Line(comma + "temp_" + proc.table.name + "" + field.useLiteral()));
            comma = "  , ";
        }
        proc.lines.addElement(new Line("  )"));
    }

    public void buildInsert(Proc proc) {
        Field field;
        String comma;
        int i;
        String name = this.tableName();
        String line = "  ";
        proc.isStd = true;
        proc.isSql = true;
        proc.isInsert = true;
        String identityName = "";
        proc.lines.addElement(new Line(Misc.generateProcNameComment(proc)));
        proc.lines.addElement(new Line("insert into " + name + " ("));
        for (i = 0; i < this.fields.size(); ++i) {
            comma = i + 1 < this.fields.size() ? "," : "";
            field = this.fields.elementAt(i);
            if (field.isCalc) continue;
            if (Table.isIdentity(field)) {
                this.hasIdentity = true;
                identityName = field.name;
                if (!proc.hasReturning) continue;
                proc.hasUpdates = true;
                proc.isSingle = true;
                proc.outputs.addElement(field);
                continue;
            }
            if (Table.isSequence(field)) {
                if (proc.hasReturning) {
                    proc.lines.addElement(new Line(line + field.name + comma));
                }
                if (!proc.hasReturning) continue;
                proc.hasUpdates = true;
                proc.isSingle = true;
                proc.outputs.addElement(field);
                continue;
            }
            proc.inputs.addElement(field);
            proc.lines.addElement(new Line(line + field.useLiteral() + comma));
        }
        proc.lines.addElement(new Line(" ) "));
        if (this.hasIdentity) {
            proc.lines.addElement(new Line("_ret.output", true));
        } else if (proc.hasReturning) {
            proc.lines.addElement(new Line("_ret.output", true));
        }
        proc.lines.addElement(new Line(" values ("));
        for (i = 0; i < this.fields.size(); ++i) {
            comma = i + 1 < this.fields.size() ? "," : "";
            field = this.fields.elementAt(i);
            if (Table.isIdentity(field) || field.isCalc) continue;
            if (Table.isSequence(field)) {
                if (!proc.hasReturning) continue;
                proc.lines.addElement(new Line("_ret.sequence", true));
                continue;
            }
            proc.lines.addElement(new Line(line + ":" + field.useLiteral() + comma));
        }
        proc.lines.addElement(new Line(" )"));
        if (proc.hasReturning) {
            proc.lines.add(new Line("_ret.tail", true));
        }
    }

    public void buildBulkInsert(Proc proc) {
        proc.isMultipleInput = true;
        this.buildInsert(proc);
    }

    public void buildIdentity(Proc proc) {
        String name = this.tableName();
        proc.isSql = true;
        proc.isSingle = true;
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.elementAt(i);
            if (field.type != 10) continue;
            proc.outputs.addElement(field);
            String line = "select max(" + field.useLiteral() + ") " + field.useLiteral() + " from " + name;
            proc.lines.addElement(new Line(line));
        }
    }

    public void buildUpdate(Proc proc) {
        String line;
        Field field;
        int i;
        String name = this.tableName();
        proc.isStd = true;
        proc.isSql = true;
        proc.lines.addElement(new Line("update " + name));
        proc.lines.addElement(new Line(" set"));
        int j = 0;
        for (i = 0; i < this.fields.size(); ++i) {
            field = this.fields.elementAt(i);
            if (field.isPrimaryKey || field.isCalc || field.isSequence) continue;
            proc.inputs.addElement(field);
            line = j == 0 ? "  " : ", ";
            ++j;
            proc.lines.addElement(new Line(line + field.useLiteral() + " = :" + field.useLiteral()));
        }
        j = 0;
        for (i = 0; i < this.fields.size(); ++i) {
            field = this.fields.elementAt(i);
            if (!field.isPrimaryKey) continue;
            proc.inputs.addElement(field);
            line = j == 0 ? " where " : "   and ";
            ++j;
            line = line + field.useLiteral() + " = :" + field.useLiteral();
            proc.lines.addElement(new Line(line));
        }
        if (proc.hasReturning) {
            proc.lines.add(new Line("_ret.tail", true));
        }
    }

    public void buildUpdateFor(Proc proc) {
        String line;
        int i;
        String name = this.tableName();
        proc.isStd = true;
        proc.isSql = true;
        proc.lines.addElement(new Line(Misc.generateProcNameComment(proc)));
        proc.lines.addElement(new Line("update " + name));
        proc.lines.addElement(new Line(" set"));
        int j = 0;
        for (i = 0; i < proc.fields.size(); ++i) {
            String fieldName = proc.fields.elementAt(i);
            for (int k = 0; k < this.fields.size(); ++k) {
                Field field = this.fields.elementAt(k);
                if (field.isPrimaryKey || field.isCalc || field.isSequence || !field.name.equalsIgnoreCase(fieldName)) continue;
                proc.inputs.addElement(field);
                line = j == 0 ? "  " : ", ";
                ++j;
                proc.lines.addElement(new Line(line + field.useLiteral() + " = :" + field.useLiteral()));
            }
        }
        this.AddTimeStampUserStamp(proc);
        j = 0;
        for (i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.elementAt(i);
            if (!field.isPrimaryKey) continue;
            proc.inputs.addElement(field);
            line = j == 0 ? " where " : "   and ";
            ++j;
            line = line + field.useLiteral() + " = :" + field.useLiteral();
            proc.lines.addElement(new Line(line));
        }
        if (proc.hasReturning) {
            proc.lines.add(new Line("_ret.tail", true));
        }
    }

    public void buildUpdateBy(Proc proc) {
        String line;
        Field field;
        int i;
        int j;
        String fieldName;
        int k;
        String name = this.tableName();
        proc.isStd = true;
        proc.isSql = true;
        proc.lines.addElement(new Line(Misc.generateProcNameComment(proc)));
        proc.lines.addElement(new Line("update " + name));
        proc.lines.addElement(new Line(" set"));
        if (proc.fields.size() == 0) {
            for (k = 0; k < proc.updateFields.size(); ++k) {
                fieldName = proc.updateFields.elementAt(k);
                j = 0;
                for (i = 0; i < this.fields.size(); ++i) {
                    field = this.fields.elementAt(i);
                    if (field.isPrimaryKey || field.isCalc || field.name.equalsIgnoreCase(fieldName) || field.isSequence) continue;
                    proc.inputs.addElement(field);
                    line = j == 0 ? "  " : ", ";
                    ++j;
                    proc.lines.addElement(new Line(line + field.useLiteral() + " = :" + field.useLiteral()));
                }
            }
        } else {
            j = 0;
            for (i = 0; i < proc.fields.size(); ++i) {
                fieldName = proc.fields.elementAt(i);
                for (k = 0; k < this.fields.size(); ++k) {
                    field = this.fields.elementAt(k);
                    if (!field.name.equalsIgnoreCase(fieldName)) continue;
                    proc.inputs.addElement(field);
                    line = j == 0 ? "  " : ", ";
                    ++j;
                    proc.lines.addElement(new Line(line + field.useLiteral() + " = :" + field.useLiteral()));
                }
            }
        }
        this.AddTimeStampUserStamp(proc);
        j = 0;
        for (i = 0; i < proc.updateFields.size(); ++i) {
            fieldName = proc.updateFields.elementAt(i);
            for (k = 0; k < this.fields.size(); ++k) {
                field = this.fields.elementAt(k);
                if (!field.name.equalsIgnoreCase(fieldName)) continue;
                proc.inputs.addElement(field);
                line = j == 0 ? " where " : "   and ";
                ++j;
                line = line + field.useLiteral() + " = :" + field.useLiteral();
                proc.lines.addElement(new Line(line));
            }
        }
        if (proc.hasReturning) {
            proc.lines.add(new Line("_ret.tail", true));
        }
    }

    private void AddTimeStampUserStamp(Proc proc) {
        boolean unAdded = false;
        boolean tmAdded = false;
        for (int k = 0; k < this.fields.size(); ++k) {
            String line;
            Field field = this.fields.elementAt(k);
            if (field.type == 20 && !unAdded) {
                unAdded = true;
                if (proc.inputs.contains(field)) continue;
                proc.inputs.addElement(field);
                line = ", ";
                proc.lines.addElement(new Line(line + field.useLiteral() + " = :" + field.useLiteral()));
                continue;
            }
            if (field.type != 18 || tmAdded) continue;
            tmAdded = true;
            if (proc.inputs.contains(field)) continue;
            proc.inputs.addElement(field);
            line = ", ";
            proc.lines.addElement(new Line(line + field.useLiteral() + " = :" + field.useLiteral()));
        }
    }

    public void buildBulkUpdate(Proc proc) {
        proc.isMultipleInput = true;
        this.buildUpdate(proc);
    }

    public void buildDeleteOne(Proc proc) {
        String name = this.tableName();
        proc.isSql = true;
        proc.lines.addElement(new Line(Misc.generateProcNameComment(proc)));
        proc.lines.addElement(new Line("delete from " + name));
        int j = 0;
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.elementAt(i);
            if (!field.isPrimaryKey) continue;
            proc.inputs.addElement(field);
            String line = j == 0 ? " where " : "   and ";
            ++j;
            line = line + field.useLiteral() + " = :" + field.useLiteral();
            proc.lines.addElement(new Line(line));
        }
        if (proc.hasReturning) {
            proc.lines.add(new Line("_ret.tail", true));
        }
    }

    public void buildDeleteAll(Proc proc) {
        String name = this.tableName();
        proc.isSql = true;
        proc.lines.addElement(new Line(Misc.generateProcNameComment(proc)));
        proc.lines.addElement(new Line("delete from " + name));
        if (proc.hasReturning) {
            proc.lines.add(new Line("_ret.tail", true));
        }
    }

    public void buildCount(Proc proc) {
        String name = this.tableName();
        proc.isSql = true;
        proc.isSingle = true;
        Field field = new Field();
        field.name = "noOf";
        field.type = (byte)11;
        field.length = 4;
        proc.outputs.addElement(field);
        proc.lines.addElement(new Line(Misc.generateProcNameComment(proc)));
        proc.lines.addElement(new Line("select count(*) noOf from " + name));
    }

    public void buildExists(Proc proc) {
        String name = this.tableName();
        proc.isSql = true;
        proc.isSingle = true;
        Field count = new Field();
        count.name = "noOf";
        count.type = (byte)11;
        count.length = 4;
        proc.outputs.addElement(count);
        proc.lines.addElement(new Line(Misc.generateProcNameComment(proc)));
        proc.lines.addElement(new Line("select count(*) noOf from " + name));
        int j = 0;
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.elementAt(i);
            if (!field.isPrimaryKey) continue;
            proc.inputs.addElement(field);
            String line = j == 0 ? " where " : "   and ";
            ++j;
            line = line + field.useLiteral() + " = :" + field.useLiteral();
            proc.lines.addElement(new Line(line));
        }
    }

    public void buildSelectOne(Proc proc, boolean update, boolean readonly) {
        String line;
        Field field;
        int i;
        String name = this.tableName();
        proc.isStd = true;
        proc.isSql = true;
        proc.isSingle = true;
        proc.lines.addElement(new Line(Misc.generateProcNameComment(proc)));
        proc.lines.addElement(new Line("select"));
        int j = 0;
        for (i = 0; i < this.fields.size(); ++i) {
            field = this.fields.elementAt(i);
            if (field.isPrimaryKey) continue;
            proc.outputs.addElement(field);
            line = j == 0 ? "  " : ", ";
            ++j;
            proc.lines.addElement(new Line(line + field.useLiteral()));
        }
        proc.lines.addElement(new Line(" from " + name));
        j = 0;
        for (i = 0; i < this.fields.size(); ++i) {
            field = this.fields.elementAt(i);
            if (!field.isPrimaryKey) continue;
            proc.inputs.addElement(field);
            line = j == 0 ? " where " : "   and ";
            ++j;
            line = line + field.useLiteral() + " = :" + field.useLiteral();
            proc.lines.addElement(new Line(line));
        }
        if (update) {
            proc.lines.addElement(new Line(" for update"));
        } else if (readonly) {
            proc.lines.addElement(new Line(" for read only"));
        }
    }

    public void buildMaxTmStamp(Proc proc) {
        String name = this.tableName();
        proc.isStd = true;
        proc.isSql = true;
        proc.isSingle = true;
        proc.lines.addElement(new Line("select"));
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.elementAt(i);
            if (field.type != 18) continue;
            proc.outputs.addElement(field);
            proc.lines.addElement(new Line("max(" + field.useLiteral() + ")"));
        }
        proc.lines.addElement(new Line(" from " + name));
    }

    public void buildSelectAll(Proc proc, boolean update, boolean readonly, boolean inOrder, boolean descending) {
        String name = this.tableName();
        proc.isStd = true;
        proc.isSql = true;
        proc.lines.addElement(new Line(Misc.generateProcNameComment(proc)));
        proc.lines.addElement(new Line("select"));
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.elementAt(i);
            proc.outputs.addElement(field);
            String line = i == 0 ? "  " : ", ";
            proc.lines.addElement(new Line(line + field.useLiteral()));
        }
        proc.lines.addElement(new Line(" from " + name));
        this.selectFor(proc, update, readonly);
        this.selectOrderBy(proc, inOrder, descending);
    }

    private void selectOrderBy(Proc proc, boolean inOrder, boolean descending) {
        int i;
        if (!inOrder) {
            return;
        }
        if (proc.orderFields.size() == 0) {
            for (i = 0; i < this.fields.size(); ++i) {
                Field field = this.fields.elementAt(i);
                if (!field.isPrimaryKey) continue;
                proc.orderFields.addElement(field.useLiteral());
            }
        }
        int n = proc.orderFields.size();
        for (i = 0; i < n; ++i) {
            String fieldName = proc.orderFields.elementAt(i);
            String line = i == 0 ? " order by " : ", ";
            String tail = descending && i + 1 == n ? " desc" : "";
            proc.lines.addElement(new Line(line + fieldName + tail));
        }
    }

    private void selectFor(Proc proc, boolean update, boolean readonly) {
        if (update) {
            proc.lines.addElement(new Line(" for update"));
        } else if (readonly) {
            proc.lines.addElement(new Line(" for read only"));
        }
    }

    public void buildDeleteBy(Proc proc) {
        String name = this.tableName();
        proc.isStd = true;
        proc.isSql = true;
        proc.lines.addElement(new Line(Misc.generateProcNameComment(proc)));
        proc.lines.addElement(new Line("Delete from " + name));
        int j = 0;
        for (int i = 0; i < proc.fields.size(); ++i) {
            String fieldName = proc.fields.elementAt(i);
            for (int k = 0; k < this.fields.size(); ++k) {
                Field field = this.fields.elementAt(k);
                if (!field.name.equalsIgnoreCase(fieldName)) continue;
                proc.inputs.addElement(field);
                String line = j == 0 ? " where " : "   and ";
                ++j;
                line = line + field.useLiteral() + " = :" + field.useLiteral();
                proc.lines.addElement(new Line(line));
            }
        }
        if (proc.hasReturning) {
            proc.lines.add(new Line("_ret.tail", true));
        }
        if (j == 0) {
            throw new Error("Error generating buildDeleteBy");
        }
    }

    public void buildSelectBy(Proc proc, boolean forUpdate, boolean forReadOnly, boolean inOrder, boolean descending) {
        String line;
        Field field;
        int k;
        int i;
        String name = this.tableName();
        proc.isStd = true;
        proc.isSql = true;
        proc.lines.addElement(new Line(Misc.generateProcNameComment(proc)));
        proc.lines.addElement(new Line("select"));
        if (proc.outputs.size() > 0) {
            for (i = 0; i < proc.outputs.size(); ++i) {
                Field fieldOut = proc.outputs.elementAt(i);
                for (k = 0; k < this.fields.size(); ++k) {
                    field = this.fields.elementAt(k);
                    if (!field.name.equalsIgnoreCase(fieldOut.name)) continue;
                    line = i == 0 ? "  " : ", ";
                    proc.lines.addElement(new Line(line + field.useLiteral()));
                }
            }
        } else {
            for (i = 0; i < this.fields.size(); ++i) {
                Field field2 = this.fields.elementAt(i);
                proc.outputs.addElement(field2);
                line = i == 0 ? "  " : ", ";
                proc.lines.addElement(new Line(line + field2.useLiteral()));
            }
        }
        proc.lines.addElement(new Line(" from " + name));
        this.selectFor(proc, forUpdate, forReadOnly);
        int j = 0;
        for (i = 0; i < proc.fields.size(); ++i) {
            String fieldName = proc.fields.elementAt(i);
            for (k = 0; k < this.fields.size(); ++k) {
                field = this.fields.elementAt(k);
                if (!field.name.equalsIgnoreCase(fieldName)) continue;
                proc.inputs.addElement(field);
                line = j == 0 ? " where " : "   and ";
                ++j;
                line = line + field.useLiteral() + " = :" + field.useLiteral();
                proc.lines.addElement(new Line(line));
            }
        }
        if (j == 0) {
            throw new Error("Error in SelectBy");
        }
        this.selectOrderBy(proc, inOrder, descending);
    }

    public void buildSelectFrom(Proc proc, Table table) {
        int k;
        Line first;
        String name = this.tableName();
        proc.extendsStd = false;
        proc.isSql = true;
        String preFix = "";
        boolean doSelect = true;
        if (proc.lines.size() > 0) {
            first = proc.lines.elementAt(0);
            for (k = 0; k < proc.lines.size(); ++k) {
                first = proc.lines.elementAt(k);
                if (first.line.toLowerCase().indexOf("select ") <= -1 || first.line.toLowerCase().indexOf("select ") >= 5) continue;
                doSelect = false;
                logger.warn("Select found not generating SELECT." + first.line.toLowerCase().indexOf("select "));
                break;
            }
        }
        if (doSelect) {
            if (preFix == "") {
                for (k = 0; k < proc.lines.size(); ++k) {
                    first = proc.lines.elementAt(k);
                    if (first.line.toLowerCase().indexOf(name.toLowerCase()) <= -1) continue;
                    preFix = first.line.substring(first.line.toLowerCase().indexOf(name.toLowerCase()) + name.length()).trim();
                    int n = preFix.indexOf(32);
                    if (n > 0) {
                        preFix = preFix.substring(0, n).trim();
                    }
                    if (name.toLowerCase().startsWith(preFix.toLowerCase().substring(0, 1))) break;
                    logger.warn("PREFIX mismatch. Dropping PREFIX");
                    preFix = "";
                    break;
                }
            }
            if (preFix.equals("")) {
                logger.warn("Unable to determine PREFIX for table");
            }
            proc.lines.insertElementAt(new Line("SELECT "), 0);
            for (int j = 0; j < proc.outputs.size(); ++j) {
                String line;
                Field fieldName = proc.outputs.elementAt(j);
                if (table.hasField(fieldName.name)) {
                    line = j == 0 ? (preFix.length() > 0 ? "  " + preFix + "" : "  ") : (preFix.length() > 0 ? ", " + preFix + "" : ", ");
                } else {
                    fieldName.isExtStd = true;
                    fieldName.isExtStdOut = true;
                    line = j == 0 ? "  " : ", ";
                }
                proc.lines.insertElementAt(new Line(line + fieldName.useLiteral() + " "), j + 1);
            }
            if (proc.isStd) {
                proc.isStd = false;
                proc.extendsStd = true;
                proc.useStd = true;
            }
        }
    }

    public String toString() {
        return this.name;
    }

    private String set(String a, String b, String what) {
        if (a.length() == 0) {
            a = b;
        } else if (!a.equalsIgnoreCase(b)) {
            logger.warn("Import " + what + " name :" + a + " not the same as :" + b);
        }
        return a;
    }

    private boolean set(boolean a, boolean b, String what) {
        if (!a) {
            a = b;
        } else if (!b) {
            logger.warn("Import " + what + " is already true and is not set to false.");
        }
        return a;
    }

    private void copy(Table addin) {
        this.name = addin.name;
        this.alias = addin.alias;
        this.check = addin.check;
        this.fields = addin.fields;
        this.keys = addin.keys;
        this.links = addin.links;
        this.grants = addin.grants;
        this.views = addin.views;
        this.procs = addin.procs;
        this.comments = addin.comments;
        this.options = addin.options;
        this.allUsers = addin.allUsers;
        this.hasPrimaryKey = addin.hasPrimaryKey;
        this.hasSequence = addin.hasSequence;
        this.hasTimeStamp = addin.hasTimeStamp;
        this.hasAutoTimeStamp = addin.hasAutoTimeStamp;
        this.hasUserStamp = addin.hasUserStamp;
        this.hasExecute = addin.hasExecute;
        this.hasSelect = addin.hasSelect;
        this.hasInsert = addin.hasInsert;
        this.hasDelete = addin.hasDelete;
        this.hasUpdate = addin.hasUpdate;
        this.hasStdProcs = addin.hasStdProcs;
        this.hasIdentity = addin.hasIdentity;
        this.start = addin.start;
    }

    private void merge(Table addin) {
        this.alias = this.set(this.alias, addin.alias, "alias");
        this.check = this.set(this.check, addin.check, "check");
        this.hasPrimaryKey = this.set(this.hasPrimaryKey, addin.hasPrimaryKey, "hasPrimaryKey");
        this.hasSequence = this.set(this.hasSequence, addin.hasSequence, "hasSequence");
        this.hasTimeStamp = this.set(this.hasTimeStamp, addin.hasTimeStamp, "hasTimeStamp");
        this.hasAutoTimeStamp = this.set(this.hasAutoTimeStamp, addin.hasAutoTimeStamp, "hasAutoTimeStamp");
        this.hasUserStamp = this.set(this.hasUserStamp, addin.hasUserStamp, "hasUserStamp");
        this.hasExecute = this.set(this.hasExecute, addin.hasExecute, "hasExecute");
        this.hasSelect = this.set(this.hasSelect, addin.hasSelect, "hasSelect");
        this.hasInsert = this.set(this.hasInsert, addin.hasInsert, "hasInsert");
        this.hasDelete = this.set(this.hasDelete, addin.hasDelete, "hasDelete");
        this.hasUpdate = this.set(this.hasUpdate, addin.hasUpdate, "hasUpdate");
        this.hasStdProcs = this.set(this.hasStdProcs, addin.hasStdProcs, "hasStdProcs");
        this.hasIdentity = this.set(this.hasIdentity, addin.hasIdentity, "hasIdentity");
    }

    public Table add(Table addin) {
        Table table = new Table();
        table.copy(this);
        table.merge(addin);
        return table;
    }

    public boolean hasOption(String value) {
        for (int i = 0; i < this.options.size(); ++i) {
            String option = this.options.elementAt(i);
            if (option.toLowerCase().compareTo(value.toLowerCase()) != 0) continue;
            return true;
        }
        return false;
    }
}

