/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2.generators;

import bbd.jportal2.BaseGenerator;
import bbd.jportal2.Database;
import bbd.jportal2.IBuiltInSIProcessor;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

public class YamlOutput
extends BaseGenerator
implements IBuiltInSIProcessor {
    private final Logger logger = LoggerFactory.getLogger(YamlOutput.class);

    @Override
    public String description() {
        return "Generate a YAML representation of the database definition";
    }

    @Override
    public String documentation() {
        return "Generate a YAML representation of the database definition.";
    }

    public YamlOutput() {
        super(YamlOutput.class);
    }

    @Override
    public void generate(Database database, String output) {
        String fileName = database.output.length() > 0 ? database.output : database.name;
        fileName = output + fileName + ".yaml";
        this.logger.info("YAML: {}", (Object)fileName);
        try (PrintWriter outData = this.openOutputFileForGeneration("yaml", fileName);){
            Representer representer = new Representer();
            representer.getPropertyUtils().setSkipMissingProperties(true);
            Yaml yaml = new Yaml(representer);
            yaml.dump(database, outData);
            outData.flush();
        }
        catch (IOException e1) {
            this.logger.error("Generate YamlOutput IO Error", e1);
        }
    }
}

