/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.AbstractCompatibilityTransformer;

public class ServicesResourceTransformer
extends AbstractCompatibilityTransformer {
    private static final String SERVICES_PATH = "META-INF/services";
    private Map<String, ServiceStream> serviceEntries = new HashMap<String, ServiceStream>();
    private List<Relocator> relocators;
    private long time = Long.MIN_VALUE;

    @Override
    public boolean canTransformResource(String resource) {
        return resource.startsWith(SERVICES_PATH);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        String line;
        ServiceStream out = this.serviceEntries.get(resource);
        if (out == null) {
            out = new ServiceStream();
            this.serviceEntries.put(resource, out);
        }
        String content = IOUtils.toString(is, StandardCharsets.UTF_8);
        StringReader reader = new StringReader(content);
        BufferedReader lineReader = new BufferedReader(reader);
        while ((line = lineReader.readLine()) != null) {
            String relContent = line;
            for (Relocator relocator : relocators) {
                if (!relocator.canRelocateClass(relContent)) continue;
                relContent = relocator.applyToSourceContent(relContent);
            }
            out.append(relContent + "\n");
        }
        if (this.relocators == null) {
            this.relocators = relocators;
        }
        if (time > this.time) {
            this.time = time;
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return this.serviceEntries.size() > 0;
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        for (Map.Entry<String, ServiceStream> entry : this.serviceEntries.entrySet()) {
            String className;
            String key = entry.getKey();
            ServiceStream data = entry.getValue();
            if (this.relocators != null) {
                key = key.substring(SERVICES_PATH.length() + 1);
                for (Relocator relocator : this.relocators) {
                    if (!relocator.canRelocateClass(key)) continue;
                    key = relocator.relocateClass(key);
                    break;
                }
                key = "META-INF/services/" + key;
            }
            JarEntry jarEntry = new JarEntry(key);
            jarEntry.setTime(this.time);
            jos.putNextEntry(jarEntry);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)jos, StandardCharsets.UTF_8);
            InputStreamReader streamReader = new InputStreamReader(data.toInputStream());
            BufferedReader reader = new BufferedReader(streamReader);
            while ((className = reader.readLine()) != null) {
                writer.write(className);
                writer.write(System.lineSeparator());
                ((Writer)writer).flush();
            }
            reader.close();
            data.reset();
        }
    }

    static class ServiceStream
    extends ByteArrayOutputStream {
        ServiceStream() {
            super(1024);
        }

        public void append(String content) throws IOException {
            if (this.count > 0 && this.buf[this.count - 1] != 10 && this.buf[this.count - 1] != 13) {
                this.write(10);
            }
            byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
            this.write(contentBytes);
        }

        public InputStream toInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

