/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2;

import bbd.jportal2.Enum;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class Field
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String name = "";
    public String alias = "";
    public String defaultValue = "";
    public String checkValue = "";
    public byte type = 0;
    public int length = 0;
    public int precision = 0;
    public int scale = 0;
    public int bindPos = 0;
    public int definePos = 0;
    public Vector<String> comments = new Vector();
    public Vector<Enum> enums = new Vector();
    public Vector<String> valueList = new Vector();
    public String enumLink = "";
    public String enumType;
    public boolean isPrimaryKey = false;
    public boolean isSequence = false;
    public boolean isNull = false;
    public boolean isLiteral = false;
    public boolean isCalc = false;
    public boolean isIn = false;
    public boolean isOut = false;
    public boolean isExtStd = false;
    public boolean isExtStdOut = false;
    public String literalName = "";
    public static final byte BLOB = 1;
    public static final byte BOOLEAN = 2;
    public static final byte BYTE = 3;
    public static final byte CHAR = 4;
    public static final byte DATE = 5;
    public static final byte DATETIME = 6;
    public static final byte DOUBLE = 7;
    public static final byte DYNAMIC = 8;
    public static final byte FLOAT = 9;
    public static final byte IDENTITY = 10;
    public static final byte INT = 11;
    public static final byte LONG = 12;
    public static final byte MONEY = 13;
    public static final byte SEQUENCE = 14;
    public static final byte SHORT = 15;
    public static final byte STATUS = 16;
    public static final byte TIME = 17;
    public static final byte TIMESTAMP = 18;
    public static final byte TLOB = 19;
    public static final byte USERSTAMP = 20;
    public static final byte ANSICHAR = 21;
    public static final byte UID = 22;
    public static final byte XML = 23;
    public static final byte BIGSEQUENCE = 24;
    public static final byte BIGIDENTITY = 25;
    public static final byte AUTOTIMESTAMP = 26;
    public static final byte WCHAR = 27;
    public static final byte WANSICHAR = 28;
    public static final byte UTF8 = 29;
    public static final byte BIGXML = 30;
    public static final byte JSON = 31;
    public static final byte BIGJSON = 32;
    public static final int DEFAULT_XML = 4096;
    public static final int DEFAULT_BIG_XML = 0x400000;
    public static final int DEFAULT_JSON = 4096;
    public static final int DEFAULT_BIG_JSON = 0x400000;

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getCheckValue() {
        return this.checkValue;
    }

    public byte getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getBindPos() {
        return this.bindPos;
    }

    public int getDefinePos() {
        return this.definePos;
    }

    public Vector<String> getComments() {
        return this.comments;
    }

    public Vector<Enum> getEnums() {
        return this.enums;
    }

    public Vector<String> getValueList() {
        return this.valueList;
    }

    public String getEnumLink() {
        return this.enumLink;
    }

    public String getEnumType() {
        return this.enumType;
    }

    public void setEnumType(String enumType) {
        this.enumType = enumType;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean isSequence() {
        return this.isSequence;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public boolean isLiteral() {
        return this.isLiteral;
    }

    public boolean isCalc() {
        return this.isCalc;
    }

    public boolean isIn() {
        return this.isIn;
    }

    public boolean isOut() {
        return this.isOut;
    }

    public boolean isExtStd() {
        return this.isExtStd;
    }

    public boolean isExtStdOut() {
        return this.isExtStdOut;
    }

    public String getLiteralName() {
        return this.literalName;
    }

    public void reader(DataInputStream ids) throws IOException {
        Object value;
        int i;
        this.name = ids.readUTF();
        this.literalName = ids.readUTF();
        this.alias = ids.readUTF();
        this.checkValue = ids.readUTF();
        this.defaultValue = ids.readUTF();
        this.enumLink = ids.readUTF();
        this.type = ids.readByte();
        this.length = ids.readInt();
        this.precision = ids.readInt();
        this.scale = ids.readInt();
        this.bindPos = ids.readInt();
        this.definePos = ids.readInt();
        int noOf = ids.readInt();
        for (i = 0; i < noOf; ++i) {
            value = ids.readUTF();
            this.comments.addElement((String)value);
        }
        noOf = ids.readInt();
        for (i = 0; i < noOf; ++i) {
            value = new Enum();
            ((Enum)value).reader(ids);
            this.enums.addElement((Enum)value);
        }
        noOf = ids.readInt();
        for (i = 0; i < noOf; ++i) {
            value = ids.readUTF();
            this.valueList.addElement((String)value);
        }
        this.isPrimaryKey = ids.readBoolean();
        this.isSequence = ids.readBoolean();
        this.isNull = ids.readBoolean();
        this.isLiteral = ids.readBoolean();
        this.isCalc = ids.readBoolean();
        this.isIn = ids.readBoolean();
        this.isExtStd = ids.readBoolean();
        this.isExtStdOut = ids.readBoolean();
        this.isOut = ids.readBoolean();
    }

    public void writer(DataOutputStream ods) throws IOException {
        Object value;
        int i;
        ods.writeUTF(this.name);
        ods.writeUTF(this.literalName);
        ods.writeUTF(this.alias);
        ods.writeUTF(this.checkValue);
        ods.writeUTF(this.defaultValue);
        ods.writeUTF(this.enumLink);
        ods.writeByte(this.type);
        ods.writeInt(this.length);
        ods.writeInt(this.precision);
        ods.writeInt(this.scale);
        ods.writeInt(this.bindPos);
        ods.writeInt(this.definePos);
        ods.writeInt(this.comments.size());
        for (i = 0; i < this.comments.size(); ++i) {
            value = this.comments.elementAt(i);
            ods.writeUTF((String)value);
        }
        ods.writeInt(this.enums.size());
        for (i = 0; i < this.enums.size(); ++i) {
            value = this.enums.elementAt(i);
            ((Enum)value).writer(ods);
        }
        ods.writeInt(this.valueList.size());
        for (i = 0; i < this.valueList.size(); ++i) {
            value = this.valueList.elementAt(i);
            ods.writeUTF((String)value);
        }
        ods.writeBoolean(this.isPrimaryKey);
        ods.writeBoolean(this.isSequence);
        ods.writeBoolean(this.isNull);
        ods.writeBoolean(this.isLiteral);
        ods.writeBoolean(this.isCalc);
        ods.writeBoolean(this.isIn);
        ods.writeBoolean(this.isExtStd);
        ods.writeBoolean(this.isExtStdOut);
        ods.writeBoolean(this.isOut);
    }

    public String useName() {
        if (this.alias.length() > 0) {
            return this.alias;
        }
        return this.name;
    }

    public String useLiteral() {
        if (this.isLiteral) {
            return this.literalName;
        }
        return this.name;
    }

    public String useLowerName() {
        String n = this.useName();
        if (n.length() <= 2) {
            return n.toLowerCase();
        }
        String f = n.substring(0, 1);
        if (this.isExtStd) {
            n = this.replaceAll(n, "", "");
        }
        return f.toLowerCase() + n.substring(1);
    }

    public String useUpperName() {
        String n = this.useName();
        String f = n.substring(0, 1);
        if (this.isExtStd) {
            n = this.replaceAll(n, "", "");
        }
        return f.toUpperCase() + n.substring(1);
    }

    public String replaceAll(String haystack, String needle, String replacement) {
        int i = haystack.lastIndexOf(needle);
        if (i != -1) {
            StringBuffer buffer = new StringBuffer(haystack);
            buffer.replace(i, i + needle.length(), replacement);
            while ((i = haystack.lastIndexOf(needle, i - 1)) != -1) {
                buffer.replace(i, i + needle.length(), replacement);
            }
            haystack = buffer.toString();
        }
        return haystack;
    }

    public boolean isEmptyAsNull() {
        if (!this.isNull) {
            return false;
        }
        switch (this.type) {
            case 21: {
                if (this.length == 1) break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public boolean isCharEmptyAsNull() {
        if (!this.isNull) {
            return false;
        }
        switch (this.type) {
            case 21: {
                if (this.length == 1) break;
            }
            case 4: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public boolean ansiIsNull() {
        if (!this.isNull) {
            return false;
        }
        return this.type == 21 && this.length == 1;
    }

    public boolean isEmptyOrAnsiAsNull() {
        return this.isEmptyAsNull() || this.ansiIsNull();
    }

    public boolean isCharEmptyOrAnsiAsNull() {
        return this.isCharEmptyAsNull() || this.ansiIsNull();
    }
}

