/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2;

import bbd.jportal2.JPortal2ArgumentParser;
import bbd.jportal2.JPortal2Arguments;
import bbd.jportal2.ProjectCompiler;
import bbd.jportal2.ProjectCompilerBuilder;
import bbd.jportal2.TemplateDownloader;
import ch.qos.logback.classic.Level;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        JPortal2Arguments arguments = JPortal2ArgumentParser.parse(args);
        if (arguments == null) {
            System.exit(0);
        }
        if (arguments.mustDebug()) {
            ((ch.qos.logback.classic.Logger)logger).setLevel(Level.DEBUG);
        }
        if (arguments.getLogFileName() != null) {
            System.setProperty("log.name", arguments.getLogFileName());
        }
        try {
            ProjectCompiler pj;
            int downloadRC = new TemplateDownloader().downloadTemplates(arguments);
            if (downloadRC > 0) {
                System.exit(downloadRC);
            }
            if (Objects.nonNull(pj = ProjectCompilerBuilder.build(arguments))) {
                int rc = pj.compileAll();
                System.exit(rc);
            } else {
                System.exit(1);
            }
        }
        catch (Exception e) {
            logger.error("General Exception caught", e);
            System.exit(3);
        }
    }
}

