/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2.generators;

import bbd.jportal2.BaseGenerator;
import bbd.jportal2.Database;
import bbd.jportal2.Enum;
import bbd.jportal2.Field;
import bbd.jportal2.IBuiltInSIProcessor;
import bbd.jportal2.PlaceHolder;
import bbd.jportal2.PlaceHolderPairs;
import bbd.jportal2.Proc;
import bbd.jportal2.Table;
import java.io.PrintWriter;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliCCode2
extends BaseGenerator
implements IBuiltInSIProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CliCCode2.class);
    PlaceHolder placeHolder;
    Vector<String> nullVector = new Vector();
    String structName = "";

    public CliCCode2() {
        super(CliCCode2.class);
    }

    @Override
    public String description() {
        return "Generate CLI C++ Code for DB2";
    }

    @Override
    public String documentation() {
        return "Generate CLI C++ Code for DB2";
    }

    @Override
    public void generate(Database database, String output) throws Exception {
        for (int i = 0; i < database.tables.size(); ++i) {
            Table table = database.tables.elementAt(i);
            this.generate(table, output);
        }
    }

    void generate(Table table, String output) throws Exception {
        try (PrintWriter outData = this.openOutputFileForGeneration("sh", this.fileName(output, table.useName().toLowerCase(), ".sh"));){
            outData.println("// This code was generated, do not modify it, modify it at source and regenerate it.");
            outData.println("#ifndef _" + table.useName().toLowerCase() + "SH_MARSHAL_VERSION");
            outData.println("#define _" + table.useName().toLowerCase() + "SH_MARSHAL_VERSION");
            outData.println();
            outData.println("#include <stddef.h>");
            outData.println("#include \"padgen.h\"");
            outData.println("#include \"cliapi.h\"");
            outData.println("#include \"foldbuilder.h\"");
            outData.println();
            if (table.hasStdProcs) {
                this.generateStdOutputRec(table, outData);
            }
            this.generateUserOutputRecs(table, outData);
            this.generateInterface(table, outData);
            outData.println("#endif");
            outData.flush();
        }
        outData = this.openOutputFileForGeneration("cpp", this.fileName(output, table.useName().toLowerCase(), ".cpp"));
        try {
            outData.println("// This code was generated, do not modify it, modify it at source and regenerate it.");
            outData.println();
            outData.println("#include \"" + this.fileName("", table.useName().toLowerCase(), ".sh") + "\"");
            outData.println();
            this.generateImplementation(table, outData);
        }
        finally {
            if (outData != null) {
                outData.close();
            }
        }
    }

    void generateStdOutputRec(Table table, PrintWriter outData) {
        for (int i = 0; i < table.comments.size(); ++i) {
            String s2 = table.comments.elementAt(i);
            outData.println("//" + s2);
        }
        int filler = 0;
        this.structName = "D" + table.useName();
        outData.println("struct D" + table.useName());
        outData.println("{");
        Vector<Field> fields = table.fields;
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.elementAt(i);
            if (field.comments.size() > 0) {
                for (int c = 0; c < field.comments.size(); ++c) {
                    String s3 = field.comments.elementAt(c);
                    outData.println("  //" + s3);
                }
            }
            outData.println("  " + this.padder(this.cppVar(field) + ";", 48) + this.generatePadding(field, filler++));
            if (!this.isNull(field)) continue;
            outData.println("  " + this.padder("int16  " + field.useName() + "IsNull;", 48) + this.generatePadding(filler++));
            ++filler;
        }
        outData.println();
        this.headerSwaps(outData, "", fields, null, false);
        String useName = table.useName();
        this.extendDataBuildHeader(outData, "", fields, useName, this.nullVector, null);
        outData.println("};");
        outData.println();
        outData.println("typedef D" + table.useName() + " O" + table.useName() + ";");
        outData.println();
        this.generateEnumOrdinals(table, outData);
    }

    void generateUserOutputRecs(Table table, PrintWriter outData) {
        for (int i = 0; i < table.procs.size(); ++i) {
            String useName;
            String s2;
            int c;
            Field field;
            Proc proc = table.procs.elementAt(i);
            if (proc.isData || proc.isStd || proc.hasNoData() || proc.isStdExtended()) continue;
            boolean needsFold = false;
            String work = "";
            String baseClass = "";
            Vector<Field> fields = proc.outputs;
            fields = proc.outputs;
            if (fields.size() > 0) {
                for (int j = 0; j < proc.comments.size(); ++j) {
                    String comment = proc.comments.elementAt(j);
                    outData.println("//" + comment);
                }
                String typeChar = "D";
                if (proc.hasDiscreteInput()) {
                    typeChar = "O";
                }
                work = " : public " + typeChar + table.useName() + proc.upperFirst();
                baseClass = typeChar + table.useName() + proc.upperFirst();
                this.structName = typeChar + table.useName() + proc.upperFirst();
                outData.println("struct " + typeChar + table.useName() + proc.upperFirst());
                outData.println("{");
                int filler = 0;
                for (int j = 0; j < fields.size(); ++j) {
                    field = fields.elementAt(j);
                    for (c = 0; c < field.comments.size(); ++c) {
                        s2 = field.comments.elementAt(c);
                        outData.println("  //" + s2);
                    }
                    outData.println("  " + this.padder(this.cppVar(field) + ";", 48) + this.generatePadding(field, filler++));
                    if (!this.isNull(field)) continue;
                    outData.println("  " + this.padder("int16  " + field.useName() + "IsNull;", 48) + this.generatePadding(filler++));
                }
                outData.println();
                needsFold = this.headerSwaps(outData, "", fields, null, needsFold);
                useName = table.useName() + proc.upperFirst();
                this.extendDataBuildHeader(outData, "", fields, useName, this.nullVector, null);
                outData.println("};");
                outData.println();
            }
            if (proc.hasDiscreteInput()) {
                int j;
                this.structName = "D" + table.useName() + proc.upperFirst();
                outData.println("struct D" + table.useName() + proc.upperFirst() + work);
                outData.println("{");
                int filler = 0;
                Vector<Field> inputs = proc.inputs;
                for (j = 0; j < inputs.size(); ++j) {
                    field = inputs.elementAt(j);
                    if (proc.hasOutput(field.name)) continue;
                    for (c = 0; c < field.comments.size(); ++c) {
                        s2 = field.comments.elementAt(c);
                        outData.println("  //" + s2);
                    }
                    outData.println("  " + this.padder(this.cppVar(field) + ";", 48) + this.generatePadding(field, filler++));
                    if (!this.isNull(field)) continue;
                    outData.println("  " + this.padder("int16  " + field.useName() + "IsNull;", 48) + this.generatePadding(filler++));
                }
                outData.println();
                for (j = 0; j < proc.dynamics.size(); ++j) {
                    String s3 = proc.dynamics.elementAt(j);
                    Integer n = proc.dynamicSizes.elementAt(j);
                    outData.println("  " + this.padder("char " + s3 + "[" + (n + 1) + "];", 48) + this.charPadding(n + 1, filler++));
                }
                this.headerSwaps(outData, baseClass, inputs, proc, needsFold);
                useName = table.useName() + proc.upperFirst();
                this.extendDataBuildHeader(outData, baseClass, inputs, useName, proc.dynamics, proc);
                outData.println("};");
                outData.println();
                continue;
            }
            if (fields.size() <= 0) continue;
            outData.println("typedef D" + table.useName() + proc.upperFirst() + " O" + table.useName() + proc.upperFirst() + ";");
            outData.println();
        }
    }

    private boolean headerSwaps(PrintWriter outData, String baseClass, Vector<Field> inputs, Proc proc, boolean setFold) {
        Field field;
        int j;
        outData.println("  void Clear()");
        outData.println("  {");
        if (baseClass.length() > 0) {
            outData.println("    " + baseClass + "::Clear();");
        }
        boolean needsFold = setFold;
        block4: for (j = 0; j < inputs.size(); ++j) {
            field = inputs.elementAt(j);
            if (proc != null && proc.hasOutput(field.name)) continue;
            outData.println("    " + this.cppInit(field));
            switch (field.type) {
                case 1: 
                case 19: 
                case 23: 
                case 31: {
                    needsFold = true;
                    continue block4;
                }
                case 4: {
                    if (!this.isCLOB(field)) continue block4;
                    needsFold = true;
                }
            }
        }
        if (proc != null) {
            for (j = 0; j < proc.dynamics.size(); ++j) {
                String s2 = proc.dynamics.elementAt(j);
                outData.println("    memset(" + s2 + ", 0, sizeof(" + s2 + "));");
            }
        }
        outData.println("  }");
        outData.println("  " + this.structName + "() { Clear(); }");
        outData.println("  void Swaps()");
        outData.println("  {");
        if (baseClass.length() > 0) {
            outData.println("    " + baseClass + "::Swaps();");
        }
        for (j = 0; j < inputs.size(); ++j) {
            field = inputs.elementAt(j);
            if (proc != null && proc.hasOutput(field.name) || !this.notString(field)) continue;
            if (!this.isStruct(field)) {
                outData.println("    SwapBytes(" + field.useName() + ");");
            } else {
                outData.println("    " + field.useName() + ".Swaps();");
            }
            if (!this.isNull(field)) continue;
            outData.println("    SwapBytes(" + field.useName() + "IsNull);");
        }
        outData.println("  }");
        outData.println("  static bool NeedsFold() { return " + (needsFold ? "true" : "false") + "; }");
        return needsFold;
    }

    private String nullAdd(Field field) {
        if (this.isNull(field)) {
            return ", " + field.useName() + "IsNull";
        }
        return "";
    }

    private String nullSet(Field field) {
        if (this.isNull(field)) {
            return ", " + field.useName() + "IsNull";
        }
        return "";
    }

    private String maxlenAdd(Field field) {
        switch (field.type) {
            case 2: 
            case 3: 
            case 15: {
                return ", 2";
            }
            case 10: 
            case 11: 
            case 14: {
                return ", 4";
            }
            case 12: 
            case 24: 
            case 25: {
                return ", 8";
            }
            case 19: {
                return ", " + field.length;
            }
            case 23: 
            case 31: {
                return ", " + field.length;
            }
            case 4: {
                if (this.isCLOB(field)) {
                    return ", " + field.length;
                }
                return ", " + (field.length + 1);
            }
            case 20: 
            case 21: {
                return ", " + (field.length + 1);
            }
            case 1: {
                return ", " + field.length;
            }
            case 5: {
                return ", 9";
            }
            case 17: {
                return ", 7";
            }
            case 6: 
            case 18: 
            case 26: {
                return ", 15";
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return ", " + (field.precision + 3);
                }
                return ", 8";
            }
            case 13: {
                return ", 21";
            }
        }
        return "";
    }

    private void extendDataBuildHeader(PrintWriter outData, String baseClass, Vector<Field> inputs, String useName, Vector<String> dynamics, Proc proc) {
        String str;
        Field field;
        int j;
        int inputNo = 0;
        if (baseClass.length() > 0) {
            for (j = 0; j < inputs.size(); ++j) {
                field = inputs.elementAt(j);
                if (proc != null && proc.hasOutput(field.name)) continue;
                ++inputNo;
            }
            outData.println("  static int NoBuildFields() {return " + baseClass + "::NoBuildFields()+" + (inputNo + dynamics.size()) + ";}");
        } else {
            outData.println("  static int NoBuildFields() {return " + (inputs.size() + dynamics.size()) + ";}");
        }
        outData.println("  void _buildAdds(DataBuilder &dBuild)");
        outData.println("  {");
        if (baseClass.length() > 0) {
            outData.println("    " + baseClass + "::_buildAdds(dBuild);");
        }
        for (j = 0; j < inputs.size(); ++j) {
            field = inputs.elementAt(j);
            if (proc != null && proc.hasOutput(field.name)) continue;
            if (field.type == 1) {
                outData.println("    dBuild.add(\"" + field.useName() + "\"" + this.maxlenAdd(field) + ", " + field.useName() + ".len, " + field.useName() + ".data" + this.nullAdd(field) + ");");
                continue;
            }
            outData.println("    dBuild.add(\"" + field.useName() + "\"" + this.maxlenAdd(field) + ", " + field.useName() + this.nullAdd(field) + ");");
        }
        for (j = 0; j < dynamics.size(); ++j) {
            str = dynamics.elementAt(j);
            Integer n = proc.dynamicSizes.elementAt(j);
            outData.println("    dBuild.add(\"" + str + "\", " + (n + 1) + ", " + str + ");");
        }
        outData.println("  }");
        outData.println("  void BuildData(DataBuilder &dBuild, char *name)");
        outData.println("  {");
        outData.println("    dBuild.name(name);");
        outData.println("    _buildAdds(dBuild);");
        outData.println("  }");
        outData.println("  void BuildData(DataBuilder &dBuild) {BuildData(dBuild, \"" + useName + "\");}");
        outData.println("  void _buildSets(DataBuilder &dBuild)");
        outData.println("  {");
        if (baseClass.length() > 0) {
            outData.println("    " + baseClass + "::_buildSets(dBuild);");
        }
        for (j = 0; j < inputs.size(); ++j) {
            field = inputs.elementAt(j);
            if (proc != null && proc.hasOutput(field.name)) continue;
            if (field.type == 1) {
                outData.println("    dBuild.set(\"" + field.useName() + "\", " + field.useName() + ".len, " + field.useName() + ".data, " + field.length + this.nullSet(field) + ");");
                continue;
            }
            outData.println("    dBuild.set(\"" + field.useName() + "\", " + field.useName() + ", sizeof(" + field.useName() + ")" + this.nullSet(field) + ");");
        }
        for (j = 0; j < dynamics.size(); ++j) {
            str = dynamics.elementAt(j);
            outData.println("    dBuild.set(\"" + str + "\", " + str + ", sizeof(" + str + "));");
        }
        outData.println("  }");
        outData.println("  void SetData(DataBuilder &dBuild, char *name)");
        outData.println("  {");
        outData.println("    dBuild.name(name);");
        outData.println("    _buildSets(dBuild);");
        outData.println("  }");
        outData.println("  void SetData(DataBuilder &dBuild) {SetData(dBuild, \"" + useName + "\");}");
    }

    void generateInterface(Table table, PrintWriter outData) {
        for (int i = 0; i < table.procs.size(); ++i) {
            Proc proc = table.procs.elementAt(i);
            if (proc.isData) continue;
            this.generateInterface(table, proc, outData);
        }
    }

    void generateInterface(Table table, Proc proc, PrintWriter outData) {
        if (proc.comments.size() > 0) {
            for (int i = 0; i < proc.comments.size(); ++i) {
                String comment = proc.comments.elementAt(i);
                outData.println("  //" + comment);
            }
        }
        if (proc.hasNoData()) {
            outData.println("struct T" + table.useName() + proc.upperFirst());
            outData.println("{");
            outData.println("  TJQuery q_;");
            outData.println("  void Exec();");
            outData.println("  T" + table.useName() + proc.upperFirst() + "(TJConnector &conn, char *aFile=__FILE__, long aLine=__LINE__)");
            outData.println("  : q_(conn)");
            outData.println("  {q_.FileAndLine(aFile,aLine);}");
            outData.println("};");
            outData.println();
        } else {
            String dataStruct = proc.isStdExtended() || proc.isStd ? "D" + table.useName() : "D" + table.useName() + proc.upperFirst();
            outData.println("struct T" + table.useName() + proc.upperFirst() + " : public " + dataStruct);
            outData.println("{");
            this.generateInterface(table, proc, dataStruct, outData);
            outData.println("};");
            outData.println();
        }
    }

    void generateImplementation(Table table, PrintWriter outData) {
        for (int i = 0; i < table.procs.size(); ++i) {
            Proc proc = table.procs.elementAt(i);
            if (proc.isData) continue;
            if (proc.isMultipleInput) {
                this.generateMultipleImplementation(table, proc, outData);
                continue;
            }
            this.generateImplementation(table, proc, outData);
        }
    }

    boolean isCLOB(Field field) {
        return field.type == 4 && field.length > 32762;
    }

    String useNull(Field field) {
        if (this.isNull(field)) {
            return ", " + field.useName() + "IsNull);";
        }
        return ");";
    }

    void generateMultipleImplementation(Table table, Proc proc, PrintWriter outData) {
        Field field;
        int i;
        this.placeHolder = new PlaceHolder(proc, 1, "");
        String dataStruct = proc.isStdExtended() || proc.isStd ? "D" + table.useName() : "D" + table.useName() + proc.upperFirst();
        this.placeHolder = new PlaceHolder(proc, 1, "");
        String fullName = table.useName() + proc.upperFirst();
        outData.println("void T" + fullName + "::Exec(int32 noOf, " + dataStruct + " *Recs)");
        outData.println("{");
        this.generateCommand(proc, outData);
        outData.println("  q_.OpenArray(q_.command, NOBINDS, NONULLS, noOf, ROWSIZE);");
        int n = 0;
        for (i = 0; i < proc.inputs.size(); ++i) {
            field = proc.inputs.elementAt(i);
            outData.println("  " + this.cppArrayPointer(field));
            if (this.isNull(field)) {
                outData.println("  SQLINTEGER* " + field.useName() + "IsNull = &q_.indicators[noOf*" + n++ + "];");
                continue;
            }
            if (this.isCLOB(field) && field.isNull) {
                outData.println("  SQLINTEGER* " + field.useName() + "IsNull = &q_.indicators[noOf*" + n++ + "];");
                continue;
            }
            if (field.type != 21 || !field.isNull) continue;
            outData.println("  SQLINTEGER* " + field.useName() + "IsNull = &q_.indicators[noOf*" + n++ + "];");
        }
        outData.println("  for (int i=0; i<noOf; i++)");
        outData.println("  {");
        for (i = 0; i < proc.inputs.size(); ++i) {
            Field field2 = proc.inputs.elementAt(i);
            outData.println("    " + this.cppArrayCopy(field2));
            if (this.isNull(field2)) {
                outData.println("    " + field2.useName() + "IsNull[i] = Recs[i]." + field2.useName() + "IsNull;");
                continue;
            }
            if (this.isCLOB(field2) && field2.isNull) {
                outData.println("    " + field2.useName() + "IsNull[i] = Recs[i]." + field2.useName() + ".length() == 0 ? JP_NULL : SQL_NTS;");
                continue;
            }
            if (field2.type != 21 || !field2.isNull) continue;
            outData.println("    " + field2.useName() + "IsNull[i] = strlen(Recs[i]." + field2.useName() + ") == 0 ? JP_NULL : SQL_NTS;");
        }
        outData.println("  }");
        block15: for (i = 0; i < this.placeHolder.pairs.size(); ++i) {
            PlaceHolderPairs pair = this.placeHolder.pairs.elementAt(i);
            field = pair.field;
            String size = field.useName().toUpperCase() + "_SIZE";
            switch (field.type) {
                case 21: {
                    outData.println("  q_.BindAnsiCharArray(" + i + ", " + field.useName() + ", " + size + this.useNull(field));
                    continue block15;
                }
                case 4: 
                case 19: 
                case 20: 
                case 23: 
                case 31: {
                    outData.println("  q_.BindCharArray(" + i + ", " + field.useName() + ", " + size + this.useNull(field));
                    continue block15;
                }
                case 12: 
                case 24: 
                case 25: {
                    outData.println("  q_.BindInt64Array(" + i + ", " + field.useName() + this.useNull(field));
                    continue block15;
                }
                case 10: 
                case 11: 
                case 14: {
                    outData.println("  q_.BindInt32Array(" + i + ", " + field.useName() + this.useNull(field));
                    continue block15;
                }
                case 2: 
                case 3: 
                case 15: {
                    outData.println("  q_.BindInt16Array(" + i + ", " + field.useName() + this.useNull(field));
                    continue block15;
                }
                case 7: 
                case 9: {
                    if (field.precision <= 15) {
                        outData.println("  q_.BindDoubleArray(" + i + ", " + field.useName() + ", " + field.precision + ", " + field.scale + this.useNull(field));
                        continue block15;
                    }
                    outData.println("  q_.BindMoneyArray(" + i + ", " + field.useName() + ", " + field.precision + ", " + field.scale + this.useNull(field));
                    continue block15;
                }
                case 13: {
                    outData.println("  q_.BindMoneyArray(" + i + ", " + field.useName() + ", 18, 2" + this.useNull(field));
                    continue block15;
                }
                case 5: {
                    outData.println("  q_.BindDateArray(" + i + ", " + field.useName() + this.useNull(field));
                    continue block15;
                }
                case 17: {
                    outData.println("  q_.BindTimeArray(" + i + ", " + field.useName() + this.useNull(field));
                    continue block15;
                }
                case 6: 
                case 18: {
                    outData.println("  q_.BindDateTimeArray(" + i + ", " + field.useName() + this.useNull(field));
                    continue block15;
                }
                case 26: {
                    outData.println("  //q_.BindDateTimeArray(" + i + ", " + field.useName() + this.useNull(field));
                }
            }
        }
        outData.println("  q_.Exec();");
        outData.println("}");
        outData.println();
    }

    boolean isIdentity(Field field) {
        return field.type == 25 || field.type == 10;
    }

    boolean isSequence(Field field) {
        return field.type == 24 || field.type == 14;
    }

    void generateImplementation(Table table, Proc proc, PrintWriter outData) {
        int j;
        Field field;
        Field field2;
        int j2;
        this.placeHolder = new PlaceHolder(proc, 1, "");
        String fullName = table.useName() + proc.upperFirst();
        outData.println("void T" + fullName + "::Exec()");
        outData.println("{");
        this.generateCommand(proc, outData);
        if (proc.outputs.size() > 0) {
            outData.println("  q_.Open(q_.command, NOBINDS, NODEFINES, NOROWS, ROWSIZE);");
        } else if (proc.inputs.size() > 0) {
            outData.println("  q_.Open(q_.command, " + proc.inputs.size() + ");");
        } else {
            outData.println("  q_.Open(q_.command);");
        }
        for (j2 = 0; j2 < proc.inputs.size(); ++j2) {
            field2 = proc.inputs.elementAt(j2);
            this.generateCppBind(field2, outData);
        }
        for (j2 = 0; j2 < this.placeHolder.pairs.size(); ++j2) {
            PlaceHolderPairs pair = this.placeHolder.pairs.elementAt(j2);
            field = pair.field;
            String tablename = table.tableName();
            if (field.type == 1) {
                outData.println("  q_.BindBlob(" + this.padder("" + j2 + ",", 4) + this.cppBind(field, tablename, proc.isInsert) + this.padder(", " + this.cppDirection(field), 4) + (this.isNull(field) ? ", &" + field.useName() + "IsNull" : "") + this.charFieldFlag(field) + ");");
                continue;
            }
            outData.println("  q_.Bind(" + this.padder("" + j2 + ",", 4) + this.cppBind(field, tablename, proc.isInsert) + this.padder(", " + this.cppDirection(field), 4) + (this.isNull(field) ? ", &" + field.useName() + "IsNull" : "") + this.charFieldFlag(field) + ");");
        }
        for (j2 = 0; j2 < proc.outputs.size(); ++j2) {
            field2 = proc.outputs.elementAt(j2);
            if (field2.type == 1) {
                outData.println("  q_.DefineBlob(" + this.padder("" + j2 + ",", 4) + this.cppDefine(field2) + ");");
                continue;
            }
            outData.println("  q_.Define(" + this.padder("" + j2 + ",", 4) + this.cppDefine(field2) + ");");
        }
        outData.println("  q_.Exec();");
        outData.println("}");
        outData.println();
        boolean skipExecWithParms = false;
        for (j = 0; j < proc.inputs.size(); ++j) {
            field = proc.inputs.elementAt(j);
            if (field.type != 1) continue;
            skipExecWithParms = true;
            break;
        }
        if (!(skipExecWithParms || proc.inputs.size() <= 0 && proc.dynamics.size() <= 0)) {
            outData.println("void T" + fullName + "::Exec(");
            this.generateWithParms(proc, outData, "");
            outData.println(")");
            outData.println("{");
            for (j = 0; j < proc.inputs.size(); ++j) {
                field = proc.inputs.elementAt(j);
                if (this.isSequence(field) && proc.isInsert || this.isIdentity(field) || field.type == 18 || field.type == 26 || field.type == 20) continue;
                outData.println("  " + this.cppCopy(field));
            }
            for (j = 0; j < proc.dynamics.size(); ++j) {
                String s2 = proc.dynamics.elementAt(j);
                outData.println("  strncpy(" + s2 + ", a" + s2 + ", sizeof(" + s2 + ")-1);");
            }
            outData.println("  Exec();");
            outData.println("}");
            outData.println();
        }
        if (proc.outputs.size() > 0) {
            outData.println("bool T" + fullName + "::Fetch()");
            outData.println("{");
            outData.println("  if (q_.Fetch() == false)");
            outData.println("    return false;");
            for (j = 0; j < proc.outputs.size(); ++j) {
                field = proc.outputs.elementAt(j);
                outData.println("  q_.Get(" + this.cppGet(field) + ");");
                if (!this.isNull(field)) continue;
                outData.println("  q_.GetNull(" + field.useName() + "IsNull, " + j + ");");
            }
            outData.println("  return true;");
            outData.println("}");
            outData.println();
        }
    }

    String check(String value) {
        return value;
    }

    void generateCommand(Proc proc, PrintWriter outData) {
        boolean isReturning = false;
        boolean isBulkSequence = false;
        String front = "";
        String back = "";
        String sequencer = "";
        Vector<String> lines = this.placeHolder.getLines();
        int size = 1;
        if (proc.isInsert && proc.hasReturning && proc.outputs.size() == 1) {
            Field field = proc.outputs.elementAt(0);
            if (field.isSequence) {
                isReturning = true;
                front = "select " + field.useName() + " from new table(";
                back = ")";
                sequencer = "nextval for " + proc.table.tableName() + "seq";
                size += front.length();
                size += back.length();
                size += sequencer.length();
            }
        }
        if (proc.isMultipleInput && proc.isInsert) {
            isBulkSequence = true;
            sequencer = "nextval for " + proc.table.tableName() + "seq";
            size += sequencer.length();
        }
        for (int i = 0; i < lines.size(); ++i) {
            String l = lines.elementAt(i);
            if (l.charAt(0) == '\"') {
                size += l.length() + 2;
                continue;
            }
            String var = l.trim();
            for (int j = 0; j < proc.dynamics.size(); ++j) {
                String s2 = proc.dynamics.elementAt(j);
                if (var.compareTo(s2) != 0) continue;
                Integer n = proc.dynamicSizes.elementAt(j);
                size += n + 2;
            }
        }
        outData.println("  if (q_.command == 0)");
        outData.println("    q_.command = new char [" + size + "];");
        outData.println("  memset(q_.command, 0, " + size + ");");
        if (isReturning) {
            outData.println("  struct cpp_ret {char* head; char *output; char *sequence; char* tail; cpp_ret(){head = output = sequence = tail = \"\";}} _ret;");
            outData.println("  _ret.sequence = \"" + sequencer + ",\";");
            outData.println("  _ret.head = \"" + front + "\";");
            outData.println("  _ret.tail = \"" + back + "\";");
        }
        if (isBulkSequence) {
            outData.println("  struct cpp_ret {char* head; char *output; char *sequence; char* tail; cpp_ret(){head = output = sequence = tail = \"\";}} _ret;");
            outData.println("  _ret.sequence = \"" + sequencer + ",\";");
        }
        String strcat = "  strcat(q_.command, ";
        String terminate = "";
        if (lines.size() > 0) {
            for (int i = 0; i < lines.size(); ++i) {
                String l = lines.elementAt(i);
                if (l.charAt(0) != '\"') {
                    terminate = ");";
                    strcat = "  strcat(q_.command, ";
                    if (i != 0) {
                        outData.println(terminate);
                    }
                } else if (i != 0) {
                    outData.println(terminate);
                }
                if (l.charAt(0) != '\"') {
                    outData.print(strcat + this.check(l));
                } else {
                    outData.print(strcat + l);
                }
                if (l.charAt(0) != '\"') continue;
                terminate = "\"\\n\"";
                strcat = "                     ";
            }
            outData.println(");");
        }
    }

    void generateCppBind(Field field, PrintWriter outData) {
        switch (field.type) {
            case 5: {
                outData.println("  DATE_STRUCT " + field.useName() + "_CLIDate;");
                break;
            }
            case 17: {
                outData.println("  TIME_STRUCT " + field.useName() + "_CLITime;");
                break;
            }
            case 6: {
                outData.println("  TIMESTAMP_STRUCT " + field.useName() + "_CLIDateTime;");
                break;
            }
            case 18: {
                outData.println("  TIMESTAMP_STRUCT " + field.useName() + "_CLITimeStamp;");
                break;
            }
            case 26: {
                outData.println("  //TIMESTAMP_STRUCT " + field.useName() + "_CLITimeStamp;");
            }
        }
    }

    void generateWithParms(Proc proc, PrintWriter outData, String pad) {
        int j;
        String comma = "  ";
        for (j = 0; j < proc.inputs.size(); ++j) {
            Field field = proc.inputs.elementAt(j);
            if (this.isSequence(field) && proc.isInsert || this.isIdentity(field) || field.type == 18 || field.type == 26 || field.type == 20) continue;
            outData.println(pad + comma + "const " + this.cppParm(field));
            comma = ", ";
        }
        for (j = 0; j < proc.dynamics.size(); ++j) {
            String s2 = proc.dynamics.elementAt(j);
            outData.println(pad + comma + "const char*   a" + s2);
            comma = ", ";
        }
    }

    void generateInterface(Table table, Proc proc, String dataStruct, PrintWriter outData) {
        String front = "  { ";
        boolean standardExec = true;
        if (proc.outputs.size() > 0) {
            int j;
            String thisOne;
            outData.println("  enum");
            Field field = proc.outputs.elementAt(0);
            String lastOne = thisOne = field.useName().toUpperCase() + "_OFFSET";
            String lastSize = this.cppLength(field);
            outData.println(front + this.padder(thisOne, 24) + "= 0");
            front = "  , ";
            for (j = 1; j < proc.outputs.size(); ++j) {
                field = proc.outputs.elementAt(j);
                thisOne = field.useName().toUpperCase() + "_OFFSET";
                outData.println("  , " + this.padder(thisOne, 24) + "= (" + lastOne + "+" + lastSize + ")");
                lastOne = thisOne;
                lastSize = this.cppLength(field);
            }
            outData.println("  , " + this.padder("ROWSIZE", 24) + "= (" + lastOne + "+" + lastSize + ")");
            if (proc.isSingle) {
                outData.println("  , " + this.padder("NOROWS", 24) + "= 1");
            } else if (proc.noRows > 0) {
                outData.println("  , " + this.padder("NOROWS", 24) + "= " + proc.noRows);
            } else {
                outData.println("  , " + this.padder("NOROWS", 24) + "= (24576 / ROWSIZE) + 1");
            }
            outData.println("  , " + this.padder("NOBINDS", 24) + "= " + proc.inputs.size());
            outData.println("  , " + this.padder("NODEFINES", 24) + "= " + proc.outputs.size());
            field = proc.outputs.elementAt(0);
            thisOne = field.useName().toUpperCase();
            outData.println("  , " + this.padder(thisOne + "_POS", 24) + "= 0");
            for (j = 1; j < proc.outputs.size(); ++j) {
                field = proc.outputs.elementAt(j);
                thisOne = field.useName().toUpperCase();
                outData.println("  , " + this.padder(thisOne + "_POS", 24) + "= " + this.padder(thisOne + "_OFFSET", 24) + "* NOROWS");
            }
            outData.println("  };");
        } else if (proc.isMultipleInput) {
            String thisSize;
            String thisOne;
            int noNulls = 0;
            standardExec = false;
            outData.println("  enum");
            Field field = proc.inputs.elementAt(0);
            if (this.isNull(field) || this.isCLOB(field) && field.isNull || field.type == 21 && field.isNull) {
                ++noNulls;
            }
            String lastOne = thisOne = field.useName().toUpperCase() + "_OFFSET";
            String lastSize = thisSize = field.useName().toUpperCase() + "_SIZE";
            outData.println(front + this.padder(thisOne, 24) + "= 0");
            front = "  , ";
            outData.println(front + this.padder(thisSize, 24) + "= " + this.cppLength(field));
            for (int j = 1; j < proc.inputs.size(); ++j) {
                field = proc.inputs.elementAt(j);
                if (this.isNull(field) || this.isCLOB(field) && field.isNull || field.type == 21 && field.isNull) {
                    ++noNulls;
                }
                thisOne = field.useName().toUpperCase() + "_OFFSET";
                thisSize = field.useName().toUpperCase() + "_SIZE";
                outData.println("  , " + this.padder(thisOne, 24) + "= (" + lastOne + "+" + lastSize + ")");
                outData.println("  , " + this.padder(thisSize, 24) + "= " + this.cppLength(field));
                lastOne = thisOne;
                lastSize = thisSize;
            }
            outData.println("  , " + this.padder("ROWSIZE", 24) + "= (" + lastOne + "+" + lastSize + ")");
            outData.println("  , " + this.padder("NOBINDS", 24) + "= " + proc.inputs.size());
            outData.println("  , " + this.padder("NONULLS", 24) + "= " + noNulls);
            outData.println("  };");
            outData.println("  void Exec(int32 noOf, " + dataStruct + "* Recs);");
        }
        outData.println("  TJQuery q_;");
        if (standardExec) {
            outData.println("  void Exec();");
            outData.println("  void Exec(" + dataStruct + "& Rec) {*DRec() = Rec;Exec();}");
            boolean skipExecWithParms = false;
            for (int j = 0; j < proc.inputs.size(); ++j) {
                Field field = proc.inputs.elementAt(j);
                if (field.type != 1) continue;
                skipExecWithParms = true;
                break;
            }
            if (!(skipExecWithParms || proc.inputs.size() <= 0 && proc.dynamics.size() <= 0)) {
                outData.println("  void Exec(");
                this.generateWithParms(proc, outData, "  ");
                outData.println("  );");
            }
        }
        if (proc.outputs.size() > 0) {
            outData.println("  bool Fetch();");
        }
        outData.println("  T" + table.useName() + proc.upperFirst() + "(TJConnector &conn, char *aFile=__FILE__, long aLine=__LINE__)");
        outData.println("  : q_(conn)");
        outData.println("  {Clear();q_.FileAndLine(aFile,aLine);}");
        outData.println("  " + dataStruct + "* DRec() {return this;}");
        if (proc.outputs.size() > 0) {
            outData.println("  O" + dataStruct.substring(1) + "* ORec() {return this;}");
        }
        if (!proc.isStdExtended() && proc.extendsStd) {
            outData.println("  D" + table.useName() + "* DStd() {return (D" + table.useName() + "*)this;}");
            if (proc.outputs.size() > 0) {
                outData.println("  O" + table.useName() + "* OStd() {return (O" + table.useName() + "*)this;}");
            }
        }
    }

    String padder(String s2, int length) {
        for (int i = s2.length(); i < length - 1; ++i) {
            s2 = s2 + " ";
        }
        return s2 + " ";
    }

    public void generateEnumOrdinals(Table table, PrintWriter outData) {
        for (int i = 0; i < table.fields.size(); ++i) {
            Object element;
            int j;
            String start;
            Field field = table.fields.elementAt(i);
            if (field.enums.size() > 0) {
                String evalue;
                outData.println("enum e" + table.useName() + field.useName());
                start = "{";
                for (j = 0; j < field.enums.size(); ++j) {
                    element = field.enums.elementAt(j);
                    evalue = "" + ((Enum)element).value;
                    if (field.type == 21 && field.length == 1) {
                        evalue = "'" + (char)((Enum)element).value + "'";
                    }
                    outData.println(start + " " + table.useName() + field.useName() + ((Enum)element).name + " = " + evalue);
                    start = ",";
                }
                outData.println("};");
                outData.println();
                outData.println("inline char *" + table.useName() + field.useName() + "Lookup(int no)");
                outData.println("{");
                outData.println("  switch(no)");
                outData.println("  {");
                for (j = 0; j < field.enums.size(); ++j) {
                    element = field.enums.elementAt(j);
                    evalue = "" + ((Enum)element).value;
                    if (field.type == 21 && field.length == 1) {
                        evalue = "'" + (char)((Enum)element).value + "'";
                    }
                    outData.println("  case " + evalue + ": return \"" + ((Enum)element).name + "\";");
                }
                outData.println("  default: return \"<unknown value>\";");
                outData.println("  }");
                outData.println("}");
                outData.println();
                continue;
            }
            if (field.valueList.size() <= 0) continue;
            outData.println("enum e" + table.useName() + field.useName());
            start = "{";
            for (j = 0; j < field.valueList.size(); ++j) {
                element = field.valueList.elementAt(j);
                outData.println(start + " " + table.useName() + field.useName() + (String)element);
                start = ",";
            }
            outData.println("};");
            outData.println();
            outData.println("inline char *" + table.useName() + field.useName() + "Lookup(int no)");
            outData.println("{");
            outData.println("  switch(no)");
            outData.println("  {");
            for (j = 0; j < field.valueList.size(); ++j) {
                element = field.valueList.elementAt(j);
                outData.println("  case " + j + ": return \"" + (String)element + "\";");
            }
            outData.println("  default: return \"<unknown value>\";");
            outData.println("  }");
            outData.println("}");
            outData.println();
        }
    }

    String fileName(String output, String node, String ext) {
        return output + node + ext;
    }

    private String charPadding(int no, int fillerNo) {
        int n = 8 - no % 8;
        if (n != 8) {
            return "IDL2_CHAR_PAD(" + fillerNo + "," + n + ");";
        }
        return "";
    }

    private String generatePadding(Field field, int fillerNo) {
        switch (field.type) {
            case 2: 
            case 3: 
            case 15: {
                return "IDL2_INT16_PAD(" + fillerNo + ");";
            }
            case 10: 
            case 11: 
            case 14: {
                return "IDL2_INT32_PAD(" + fillerNo + ");";
            }
            case 19: 
            case 23: 
            case 31: {
                return "";
            }
            case 4: {
                if (this.isCLOB(field)) {
                    return "";
                }
            }
            case 5: 
            case 6: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 26: {
                return this.charPadding(field.length + 1, fillerNo);
            }
            case 7: 
            case 9: {
                if (field.precision <= 15) break;
                return this.charPadding(field.precision + 3, fillerNo);
            }
            case 13: {
                return this.charPadding(21, fillerNo);
            }
        }
        return "";
    }

    public String generatePadding(int fillerNo) {
        return "IDL2_INT16_PAD(" + fillerNo + ");";
    }

    int getLength(Field field) {
        switch (field.type) {
            case 2: 
            case 3: 
            case 15: {
                return 2;
            }
            case 10: 
            case 11: 
            case 14: {
                return 4;
            }
            case 12: 
            case 24: 
            case 25: {
                return 8;
            }
            case 19: 
            case 23: 
            case 31: {
                return 8;
            }
            case 4: {
                if (this.isCLOB(field)) {
                    return 8;
                }
            }
            case 20: 
            case 21: {
                return field.length + 1;
            }
            case 1: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 17: {
                return 7;
            }
            case 6: 
            case 18: 
            case 26: {
                return 15;
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return field.precision + 3;
                }
                return 8;
            }
            case 13: {
                return 21;
            }
        }
        return 4;
    }

    String charFieldFlag(Field field) {
        if (this.isCLOB(field) || field.type == 19 || field.type == 23 || field.type == 31) {
            return ", 0, 1";
        }
        if (field.type != 4 && field.type != 21 && field.type != 19 && field.type != 23 && field.type != 31) {
            return "";
        }
        if ((field.type == 4 || field.type == 19 || field.type == 23 || field.type == 31) && field.isNull) {
            return ", 0, 1";
        }
        if (field.type == 21) {
            if (field.isNull) {
                return ", 1, 1";
            }
            return ", 1, 0";
        }
        return ", 0, 0";
    }

    boolean isNull(Field field) {
        if (!field.isNull) {
            return false;
        }
        switch (field.type) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    boolean notString(Field field) {
        switch (field.type) {
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                return true;
            }
            case 7: 
            case 9: {
                return field.precision <= 15;
            }
        }
        return false;
    }

    boolean isStruct(Field field) {
        return field.type == 1;
    }

    boolean isLob(Field field) {
        return field.type == 1;
    }

    String cppInit(Field field) {
        switch (field.type) {
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                return field.useName() + " = 0;";
            }
            case 19: 
            case 23: 
            case 31: {
                return field.useName() + " = \"\";";
            }
            case 4: {
                if (this.isCLOB(field)) {
                    return field.useName() + " = \"\";";
                }
            }
            case 5: 
            case 6: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 26: {
                return "memset(" + field.useName() + ", 0, sizeof(" + field.useName() + "));";
            }
            case 1: {
                return field.useName() + ".len = 0, memset(" + field.useName() + ".data, 0, " + field.length + "-sizeof(int));";
            }
            case 7: 
            case 9: {
                if (field.precision <= 15) {
                    return field.useName() + " = 0.0;";
                }
                return "memset(" + field.useName() + ", 0, sizeof(" + field.useName() + "));";
            }
            case 13: {
                return "memset(" + field.useName() + ", 0, sizeof(" + field.useName() + "));";
            }
        }
        return field.useName() + " <unsupported>";
    }

    String cppVar(Field field) {
        switch (field.type) {
            case 2: 
            case 3: 
            case 15: {
                return "int16  " + field.useName();
            }
            case 10: 
            case 11: 
            case 14: {
                return "int32  " + field.useName();
            }
            case 12: 
            case 24: 
            case 25: {
                return "int64  " + field.useName();
            }
            case 19: 
            case 23: 
            case 31: {
                return "string " + field.useName();
            }
            case 4: {
                if (this.isCLOB(field)) {
                    return "string " + field.useName();
                }
            }
            case 21: {
                return "char   " + field.useName() + "[" + (field.length + 1) + "]";
            }
            case 20: {
                return "char   " + field.useName() + "[9]";
            }
            case 1: {
                return "TJBlob<" + field.length + "> " + field.useName();
            }
            case 5: {
                return "char   " + field.useName() + "[9]";
            }
            case 17: {
                return "char   " + field.useName() + "[7]";
            }
            case 6: 
            case 18: 
            case 26: {
                return "char   " + field.useName() + "[15]";
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return "char   " + field.useName() + "[" + (field.precision + 3) + "]";
                }
                return "double " + field.useName();
            }
            case 13: {
                return "char   " + field.useName() + "[21]";
            }
        }
        return field.useName() + " <unsupported>";
    }

    String cppLength(Field field) {
        switch (field.type) {
            case 2: 
            case 3: 
            case 15: {
                return "sizeof(int16)";
            }
            case 10: 
            case 11: 
            case 14: {
                return "sizeof(int32)";
            }
            case 12: 
            case 24: 
            case 25: {
                return "sizeof(int64)";
            }
            case 4: 
            case 19: 
            case 21: 
            case 23: 
            case 31: {
                return "" + (field.length + 1);
            }
            case 1: {
                return "" + field.length;
            }
            case 20: {
                return "9";
            }
            case 5: {
                return "sizeof(DATE_STRUCT)";
            }
            case 17: {
                return "sizeof(TIME_STRUCT)";
            }
            case 6: 
            case 18: 
            case 26: {
                return "sizeof(TIMESTAMP_STRUCT)";
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return "" + (field.precision + 3);
                }
                return "sizeof(double)";
            }
            case 13: {
                return "21";
            }
        }
        return "0";
    }

    String cppDirection(Field field) {
        if (field.isIn && field.isOut) {
            return "SQL_PARAM_INPUT_OUTPUT";
        }
        if (field.isOut) {
            return "SQL_PARAM_OUTPUT";
        }
        return "SQL_PARAM_INPUT";
    }

    String cppArrayPointer(Field field) {
        String offset = field.useName().toUpperCase() + "_OFFSET";
        switch (field.type) {
            case 2: 
            case 3: 
            case 15: {
                return "int16 *" + field.useName() + " = (int16 *)(q_.data + " + offset + " * noOf);";
            }
            case 11: {
                return "int32 *" + field.useName() + " = (int32 *)(q_.data + " + offset + " * noOf);";
            }
            case 12: 
            case 24: 
            case 25: {
                return "int64 *" + field.useName() + " = (int64 *)(q_.data + " + offset + " * noOf);";
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return "char *" + field.useName() + " = (char *)(q_.data + " + offset + " * noOf);";
                }
                return "double *" + field.useName() + " = (double *)(q_.data + " + offset + " * noOf);";
            }
            case 13: {
                return "char *" + field.useName() + " = (char *)(q_.data + " + offset + " * noOf);";
            }
            case 14: {
                return "int32 *" + field.useName() + " = (int32 *)(q_.data + " + offset + " * noOf);";
            }
            case 4: 
            case 19: 
            case 21: 
            case 23: 
            case 31: {
                return "char *" + field.useName() + " = (char *)(q_.data + " + offset + " * noOf);";
            }
            case 20: {
                return "char *" + field.useName() + " = (char *)(q_.data + " + offset + " * noOf);";
            }
            case 5: {
                return "DATE_STRUCT* " + field.useName() + " = (DATE_STRUCT *)(q_.data + " + offset + " * noOf);";
            }
            case 17: {
                return "TIME_STRUCT* " + field.useName() + " = (TIME_STRUCT *)(q_.data + " + offset + " * noOf);";
            }
            case 6: 
            case 18: 
            case 26: {
                return "TIMESTAMP_STRUCT* " + field.useName() + " = (TIMESTAMP_STRUCT *)(q_.data + " + offset + " * noOf);";
            }
            case 1: {
                return "// Blobs are not handled here";
            }
        }
        return "// not handled here";
    }

    String cppBind(Field field, String tableName, boolean isInsert) {
        switch (field.type) {
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 15: {
                return field.useName();
            }
            case 7: 
            case 9: {
                return field.useName() + ", " + field.precision + ", " + field.scale;
            }
            case 13: {
                return field.useName() + ", 18, 2";
            }
            case 14: 
            case 24: {
                if (isInsert) {
                    return "q_.Sequence(" + field.useName() + ", \"" + tableName + "Seq\")";
                }
                return field.useName();
            }
            case 19: 
            case 23: 
            case 31: {
                return "(char *)" + field.useName() + ".c_str(), " + field.length;
            }
            case 4: {
                if (this.isCLOB(field)) {
                    return "(char *)" + field.useName() + ".c_str(), " + field.length;
                }
                return field.useName() + ", " + field.length;
            }
            case 21: {
                return field.useName() + ", " + field.length;
            }
            case 20: {
                return "q_.UserStamp(" + field.useName() + "), 8";
            }
            case 5: {
                return "q_.Date(" + field.useName() + "_CLIDate, " + field.useName() + ")";
            }
            case 17: {
                return "q_.Time(" + field.useName() + "_CLITime, " + field.useName() + ")";
            }
            case 6: {
                return "q_.DateTime(" + field.useName() + "_CLIDateTime, " + field.useName() + ")";
            }
            case 18: {
                return "q_.TimeStamp(" + field.useName() + "_CLITimeStamp, " + field.useName() + ")";
            }
            case 26: {
                return "q_.TimeStamp(" + field.useName() + "_CLITimeStamp, " + field.useName() + ")";
            }
            case 1: {
                return "(char *)" + field.useName() + ".buffer, " + field.useName() + ".size";
            }
        }
        return field.useName() + ", <unsupported>";
    }

    String cppDefine(Field field) {
        switch (field.type) {
            case 2: 
            case 3: 
            case 15: {
                return "(int16*) (q_.data+" + field.useName().toUpperCase() + "_POS)";
            }
            case 10: 
            case 11: 
            case 14: {
                return "(int32*) (q_.data+" + field.useName().toUpperCase() + "_POS)";
            }
            case 12: 
            case 24: 
            case 25: {
                return "(int64*) (q_.data+" + field.useName().toUpperCase() + "_POS)";
            }
            case 4: 
            case 19: 
            case 23: 
            case 31: {
                return "(char*)  (q_.data+" + field.useName().toUpperCase() + "_POS), " + (field.length + 1);
            }
            case 21: {
                return "(char*)  (q_.data+" + field.useName().toUpperCase() + "_POS), " + (field.length + 1) + ", 1";
            }
            case 20: {
                return "(char*)  (q_.data+" + field.useName().toUpperCase() + "_POS), 9";
            }
            case 1: {
                return "(char*)  (q_.data+" + field.useName().toUpperCase() + "_POS), " + field.useName() + ".size";
            }
            case 5: {
                return "(DATE_STRUCT*)(q_.data+" + field.useName().toUpperCase() + "_POS)";
            }
            case 17: {
                return "(TIME_STRUCT*)(q_.data+" + field.useName().toUpperCase() + "_POS)";
            }
            case 6: 
            case 18: 
            case 26: {
                return "(TIMESTAMP_STRUCT*)(q_.data+" + field.useName().toUpperCase() + "_POS)";
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return "(char*)  (q_.data+" + field.useName().toUpperCase() + "_POS), " + (field.precision + 3);
                }
                return "(double*)(q_.data+" + field.useName().toUpperCase() + "_POS)";
            }
            case 13: {
                return "(char*)  (q_.data+" + field.useName().toUpperCase() + "_POS), 21";
            }
        }
        return field.useName() + " <unsupported>";
    }

    String cppGet(Field field) {
        switch (field.type) {
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                return this.padder(field.useName() + ",", 32) + " q_.data+" + field.useName().toUpperCase() + "_POS";
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return this.padder(field.useName() + ",", 32) + " q_.data+" + field.useName().toUpperCase() + "_POS, " + (field.precision + 3);
                }
                return this.padder(field.useName() + ",", 32) + " q_.data+" + field.useName().toUpperCase() + "_POS";
            }
            case 13: {
                return this.padder(field.useName() + ",", 32) + " q_.data+" + field.useName().toUpperCase() + "_POS, 21";
            }
            case 4: 
            case 19: 
            case 21: 
            case 23: 
            case 31: {
                return this.padder(field.useName() + ",", 32) + " q_.data+" + field.useName().toUpperCase() + "_POS, " + (field.length + 1);
            }
            case 20: {
                return this.padder(field.useName() + ",", 32) + " q_.data+" + field.useName().toUpperCase() + "_POS, 9";
            }
            case 1: {
                return this.padder(field.useName() + ".len, " + field.useName() + ".data,", 32) + " q_.data+" + field.useName().toUpperCase() + "_POS, " + field.length;
            }
            case 5: {
                return this.padder("TJDate(" + field.useName() + "),", 32) + " q_.data+" + field.useName().toUpperCase() + "_POS";
            }
            case 17: {
                return this.padder("TJTime(" + field.useName() + "),", 32) + " q_.data+" + field.useName().toUpperCase() + "_POS";
            }
            case 6: 
            case 18: 
            case 26: {
                return this.padder("TJDateTime(" + field.useName() + "),", 32) + " q_.data+" + field.useName().toUpperCase() + "_POS";
            }
        }
        return field.useName() + " <unsupported>";
    }

    String cppCopy(Field field) {
        switch (field.type) {
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 24: {
                return field.useName() + " = a" + field.useName() + ";";
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return "strncpy(" + field.useName() + ", a" + field.useName() + ", sizeof(" + field.useName() + ")-1);";
                }
                return field.useName() + " = a" + field.useName() + ";";
            }
            case 13: {
                return "strncpy(" + field.useName() + ", a" + field.useName() + ", sizeof(" + field.useName() + ")-1);";
            }
            case 19: 
            case 23: 
            case 31: {
                return field.useName() + " = a" + field.useName() + ";";
            }
            case 4: {
                if (this.isCLOB(field)) {
                    return field.useName() + " = a" + field.useName() + ";";
                }
            }
            case 5: 
            case 6: 
            case 17: {
                return "strncpy(" + field.useName() + ", a" + field.useName() + ", sizeof(" + field.useName() + ")-1);";
            }
            case 21: {
                return "memcpy(" + field.useName() + ", a" + field.useName() + ", sizeof(" + field.useName() + "));";
            }
            case 1: {
                return field.useName() + " = a" + field.useName() + ";";
            }
            case 10: 
            case 18: 
            case 20: {
                return "// " + field.useName() + " -- generated";
            }
            case 26: {
                return "// " + field.useName() + " -- generated";
            }
        }
        return field.useName() + " <unsupported>";
    }

    String cppArrayCopy(Field field) {
        String size = field.useName().toUpperCase() + "_SIZE";
        switch (field.type) {
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 24: {
                return field.useName() + "[i] = Recs[i]." + field.useName() + ";";
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return "strncpy(&" + field.useName() + "[i*" + size + "], Recs[i]." + field.useName() + ", " + size + "-1);";
                }
                return field.useName() + "[i] = Recs[i]." + field.useName() + ";";
            }
            case 13: {
                return "strncpy(&" + field.useName() + "[i*" + size + "], Recs[i]." + field.useName() + ", " + size + "-1);";
            }
            case 19: 
            case 23: 
            case 31: {
                return "strncpy(&" + field.useName() + "[i*" + size + "], Recs[i]." + field.useName() + ".c_str(), " + size + "-1);";
            }
            case 4: {
                if (this.isCLOB(field)) {
                    return "strncpy(&" + field.useName() + "[i*" + size + "], Recs[i]." + field.useName() + ".c_str(), " + size + "-1);";
                }
                return "strncpy(&" + field.useName() + "[i*" + size + "], Recs[i]." + field.useName() + ", " + size + "-1);";
            }
            case 5: {
                return "q_.Date(" + field.useName() + "[i], Recs[i]." + field.useName() + ");";
            }
            case 17: {
                return "q_.Time(" + field.useName() + "[i], Recs[i]." + field.useName() + ");";
            }
            case 6: {
                return "q_.DateTime(" + field.useName() + "[i], Recs[i]." + field.useName() + ");";
            }
            case 21: {
                return "memcpy(&" + field.useName() + "[i*" + size + "], a" + field.useName() + ", " + size + ");";
            }
            case 1: {
                return field.useName() + "[i] = Recs[i]." + field.useName() + ";";
            }
            case 20: {
                return field.useName() + " -- generated";
            }
            case 10: {
                return field.useName() + " -- generated";
            }
            case 18: {
                return "q_.TimeStamp(" + field.useName() + "[i], Recs[i]." + field.useName() + ");";
            }
            case 26: {
                return "// " + field.useName() + " -- generated";
            }
        }
        return field.useName() + " <unsupported>";
    }

    String cppParm(Field field) {
        switch (field.type) {
            case 2: 
            case 3: 
            case 15: {
                return "int16  a" + field.useName();
            }
            case 10: 
            case 11: 
            case 14: {
                return "int32   a" + field.useName();
            }
            case 12: 
            case 24: 
            case 25: {
                return "int64  a" + field.useName();
            }
            case 19: 
            case 23: 
            case 31: {
                return "string a" + field.useName();
            }
            case 4: {
                if (this.isCLOB(field)) {
                    return "string a" + field.useName();
                }
            }
            case 21: {
                return "char*  a" + field.useName();
            }
            case 20: {
                return "char*  a" + field.useName();
            }
            case 5: {
                return "char*  a" + field.useName();
            }
            case 17: {
                return "char*  a" + field.useName();
            }
            case 6: 
            case 18: 
            case 26: {
                return "char*  a" + field.useName();
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return "char*  a" + field.useName();
                }
                return "double a" + field.useName();
            }
            case 13: {
                return "char*  a" + field.useName();
            }
        }
        return field.useName() + " <unsupported>";
    }

    String fromXMLFormat(Field field) {
        switch (field.type) {
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: {
                return "memcpy(" + field.useName() + ", work.data, sizeof(" + field.useName() + ")-1);";
            }
            case 2: 
            case 3: {
                return field.useName() + " = (int8)atol(work.data);";
            }
            case 15: {
                return field.useName() + " = (int16)atol(work.data);";
            }
            case 10: 
            case 11: 
            case 14: {
                return field.useName() + " = (int32)atol(work.data);";
            }
            case 12: 
            case 24: 
            case 25: {
                return field.useName() + " = (int64)atoint64(work.data);";
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return "memcpy(" + field.useName() + ", work.data, sizeof(" + field.useName() + ")-1);";
                }
                return field.useName() + " = atof(work.data);";
            }
            case 13: {
                return "memcpy(" + field.useName() + ", work.data, sizeof(" + field.useName() + ")-1);";
            }
        }
        return "// " + field.useName() + " <unsupported>";
    }

    String toXMLFormat(Field field) {
        String front = "XRec.append(\"  <" + field.useName() + ">\");";
        String back = "XRec.append(\"</" + field.useName() + ">\");";
        switch (field.type) {
            case 4: 
            case 5: 
            case 6: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: {
                return front + "XRec.ampappend(" + field.useName() + ");" + back;
            }
            case 2: 
            case 3: 
            case 11: 
            case 15: {
                return front + "XRec.ampappend(JP_XML_FORMAT((int32)" + field.useName() + ").result);" + back;
            }
            case 12: {
                return front + "XRec.ampappend(JP_XML_FORMAT((int64)" + field.useName() + ").result);" + back;
            }
            case 7: 
            case 9: {
                if (field.precision > 15) {
                    return front + "XRec.ampappend(" + field.useName() + ");" + back;
                }
                return front + "XRec.ampappend(JP_XML_FORMAT((double)" + field.useName() + ").result);" + back;
            }
            case 13: {
                return front + "XRec.ampappend(" + field.useName() + ");" + back;
            }
        }
        return "// " + field.useName() + " <unsupported>";
    }
}

