/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.transport.AmazonS3;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkFetchConnection;
import org.eclipse.jgit.transport.WalkPushConnection;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;

public class TransportAmazonS3
extends HttpTransport
implements WalkTransport {
    static final String S3_SCHEME = "amazon-s3";
    static final TransportProtocol PROTO_S3 = new TransportProtocol(){

        @Override
        public String getName() {
            return "Amazon S3";
        }

        @Override
        public Set<String> getSchemes() {
            return Collections.singleton(TransportAmazonS3.S3_SCHEME);
        }

        @Override
        public Set<TransportProtocol.URIishField> getRequiredFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.USER, TransportProtocol.URIishField.HOST, TransportProtocol.URIishField.PATH));
        }

        @Override
        public Set<TransportProtocol.URIishField> getOptionalFields() {
            return Collections.unmodifiableSet(EnumSet.of(TransportProtocol.URIishField.PASS));
        }

        @Override
        public Transport open(URIish uri, Repository local, String remoteName) throws NotSupportedException {
            return new TransportAmazonS3(local, uri);
        }
    };
    private final AmazonS3 s3 = new AmazonS3(this.loadProperties());
    private final String bucket;
    private final String keyPrefix;

    TransportAmazonS3(Repository local, URIish uri) throws NotSupportedException {
        super(local, uri);
        this.bucket = uri.getHost();
        String p = uri.getPath();
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        if (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        this.keyPrefix = p;
    }

    private Properties loadProperties() throws NotSupportedException {
        File propsFile;
        if (this.local.getDirectory() != null && (propsFile = new File(this.local.getDirectory(), this.uri.getUser())).isFile()) {
            return TransportAmazonS3.loadPropertiesFile(propsFile);
        }
        propsFile = new File(this.local.getFS().userHome(), this.uri.getUser());
        if (propsFile.isFile()) {
            return TransportAmazonS3.loadPropertiesFile(propsFile);
        }
        Properties props = new Properties();
        String user = this.uri.getUser();
        String pass = this.uri.getPass();
        if (user == null || pass == null) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().cannotReadFile, propsFile));
        }
        props.setProperty("accesskey", user);
        props.setProperty("secretkey", pass);
        return props;
    }

    private static Properties loadPropertiesFile(File propsFile) throws NotSupportedException {
        try {
            return AmazonS3.properties(propsFile);
        }
        catch (IOException e) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().cannotReadFile, propsFile), e);
        }
    }

    public FetchConnection openFetch() throws TransportException {
        DatabaseS3 c = new DatabaseS3(this.bucket, this.keyPrefix + "/objects");
        WalkFetchConnection r = new WalkFetchConnection(this, c);
        r.available(c.readAdvertisedRefs());
        return r;
    }

    public PushConnection openPush() throws TransportException {
        DatabaseS3 c = new DatabaseS3(this.bucket, this.keyPrefix + "/objects");
        WalkPushConnection r = new WalkPushConnection(this, c);
        r.available(c.readAdvertisedRefs());
        return r;
    }

    public void close() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DatabaseS3
    extends WalkRemoteObjectDatabase {
        private final String bucketName;
        private final String objectsKey;

        DatabaseS3(String b, String o) {
            this.bucketName = b;
            this.objectsKey = o;
        }

        private String resolveKey(String subpath) {
            if (subpath.endsWith("/")) {
                subpath = subpath.substring(0, subpath.length() - 1);
            }
            String k = this.objectsKey;
            while (subpath.startsWith("../")) {
                k = k.substring(0, k.lastIndexOf(47));
                subpath = subpath.substring(3);
            }
            return k + "/" + subpath;
        }

        @Override
        URIish getURI() {
            URIish u = new URIish();
            u = u.setScheme(TransportAmazonS3.S3_SCHEME);
            u = u.setHost(this.bucketName);
            u = u.setPath("/" + this.objectsKey);
            return u;
        }

        @Override
        Collection<WalkRemoteObjectDatabase> getAlternates() throws IOException {
            try {
                return this.readAlternates("info/alternates");
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }

        @Override
        WalkRemoteObjectDatabase openAlternate(String location) throws IOException {
            return new DatabaseS3(this.bucketName, this.resolveKey(location));
        }

        @Override
        Collection<String> getPackNames() throws IOException {
            HashSet<String> have = new HashSet<String>();
            have.addAll(TransportAmazonS3.this.s3.list(TransportAmazonS3.this.bucket, this.resolveKey("pack")));
            ArrayList<String> packs = new ArrayList<String>();
            for (String n : have) {
                String in;
                if (!n.startsWith("pack-") || !n.endsWith(".pack") || !have.contains(in = n.substring(0, n.length() - 5) + ".idx")) continue;
                packs.add(n);
            }
            return packs;
        }

        @Override
        WalkRemoteObjectDatabase.FileStream open(String path) throws IOException {
            URLConnection c = TransportAmazonS3.this.s3.get(TransportAmazonS3.this.bucket, this.resolveKey(path));
            InputStream raw = c.getInputStream();
            InputStream in = TransportAmazonS3.this.s3.decrypt(c);
            int len = c.getContentLength();
            return new WalkRemoteObjectDatabase.FileStream(in, raw == in ? (long)len : -1L);
        }

        @Override
        void deleteFile(String path) throws IOException {
            TransportAmazonS3.this.s3.delete(TransportAmazonS3.this.bucket, this.resolveKey(path));
        }

        @Override
        OutputStream writeFile(String path, ProgressMonitor monitor, String monitorTask) throws IOException {
            return TransportAmazonS3.this.s3.beginPut(TransportAmazonS3.this.bucket, this.resolveKey(path), monitor, monitorTask);
        }

        @Override
        void writeFile(String path, byte[] data) throws IOException {
            TransportAmazonS3.this.s3.put(TransportAmazonS3.this.bucket, this.resolveKey(path), data);
        }

        Map<String, Ref> readAdvertisedRefs() throws TransportException {
            TreeMap<String, Ref> avail = new TreeMap<String, Ref>();
            this.readPackedRefs(avail);
            this.readLooseRefs(avail);
            this.readRef(avail, "HEAD");
            return avail;
        }

        private void readLooseRefs(TreeMap<String, Ref> avail) throws TransportException {
            try {
                for (String n : TransportAmazonS3.this.s3.list(TransportAmazonS3.this.bucket, this.resolveKey("../refs"))) {
                    this.readRef(avail, "refs/" + n);
                }
            }
            catch (IOException e) {
                throw new TransportException(this.getURI(), JGitText.get().cannotListRefs, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Ref readRef(TreeMap<String, Ref> avail, String rn) throws TransportException {
            String s2;
            String ref = "../" + rn;
            try {
                BufferedReader br = this.openReader(ref);
                try {
                    s2 = br.readLine();
                }
                finally {
                    br.close();
                }
            }
            catch (FileNotFoundException noRef) {
                return null;
            }
            catch (IOException err) {
                throw new TransportException(this.getURI(), MessageFormat.format(JGitText.get().transportExceptionReadRef, ref), err);
            }
            if (s2 == null) {
                throw new TransportException(this.getURI(), MessageFormat.format(JGitText.get().transportExceptionEmptyRef, rn));
            }
            if (s2.startsWith("ref: ")) {
                String target = s2.substring("ref: ".length());
                Ref r = avail.get(target);
                if (r == null) {
                    r = this.readRef(avail, target);
                }
                if (r == null) {
                    r = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null);
                }
                r = new SymbolicRef(rn, r);
                avail.put(r.getName(), r);
                return r;
            }
            if (ObjectId.isId(s2)) {
                ObjectIdRef.Unpeeled r = new ObjectIdRef.Unpeeled(this.loose(avail.get(rn)), rn, ObjectId.fromString(s2));
                avail.put(r.getName(), r);
                return r;
            }
            throw new TransportException(this.getURI(), MessageFormat.format(JGitText.get().transportExceptionBadRef, rn, s2));
        }

        private Ref.Storage loose(Ref r) {
            if (r != null && r.getStorage() == Ref.Storage.PACKED) {
                return Ref.Storage.LOOSE_PACKED;
            }
            return Ref.Storage.LOOSE;
        }

        @Override
        void close() {
        }
    }
}

