/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.basetype.BaseTypeChecker;
import checkers.basetype.BaseTypeValidator;
import checkers.basetype.BaseTypeVisitor;
import checkers.nullness.KeyForAnnotatedTypeFactory;
import checkers.nullness.quals.KeyFor;
import checkers.source.Result;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.List;
import javacutils.AnnotationUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;

public class KeyForVisitor
extends BaseTypeVisitor<KeyForAnnotatedTypeFactory> {
    public KeyForVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    protected BaseTypeValidator createTypeValidator() {
        return new KeyForTypeValidator(this.checker, this, this.atypeFactory);
    }

    private static final class KeyForTypeValidator
    extends BaseTypeValidator {
        public KeyForTypeValidator(BaseTypeChecker checker, BaseTypeVisitor<?> visitor, AnnotatedTypeFactory atypeFactory) {
            super(checker, visitor, atypeFactory);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Tree p) {
            AnnotationMirror kf = type.getAnnotation(KeyFor.class);
            if (kf != null) {
                ModifiersTree mt;
                List<String> maps = AnnotationUtils.getElementValueArray(kf, "value", String.class, false);
                boolean inStatic = false;
                if (p.getKind() == Tree.Kind.VARIABLE && (mt = ((VariableTree)p).getModifiers()).getFlags().contains((Object)Modifier.STATIC)) {
                    inStatic = true;
                }
                for (String map : maps) {
                    if (map.equals("this")) {
                        if (!inStatic) continue;
                        this.checker.report(Result.failure("keyfor.type.invalid", type.getAnnotations(), type.toString()), p);
                        continue;
                    }
                    if (!map.matches("#(\\d+)")) continue;
                }
            }
            return super.visitDeclared(type, p);
        }
    }
}

