/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.Tree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.LinkedList;
import javacutils.InternalUtils;

public class LeftShiftNode
extends Node {
    protected Tree tree;
    protected Node left;
    protected Node right;

    public LeftShiftNode(Tree tree, Node left, Node right) {
        super(InternalUtils.typeOf(tree));
        assert (tree.getKind() == Tree.Kind.LEFT_SHIFT);
        this.tree = tree;
        this.left = left;
        this.right = right;
    }

    public Node getLeftOperand() {
        return this.left;
    }

    public Node getRightOperand() {
        return this.right;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitLeftShift(this, p);
    }

    public String toString() {
        return "(" + this.getLeftOperand() + " << " + this.getRightOperand() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LeftShiftNode)) {
            return false;
        }
        LeftShiftNode other = (LeftShiftNode)obj;
        return this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getLeftOperand(), this.getRightOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list = new LinkedList<Node>();
        list.add(this.getLeftOperand());
        list.add(this.getRightOperand());
        return list;
    }
}

