/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2.generators;

import bbd.jportal2.BaseGenerator;
import bbd.jportal2.Database;
import bbd.jportal2.Field;
import bbd.jportal2.Grant;
import bbd.jportal2.IBuiltInSIProcessor;
import bbd.jportal2.Key;
import bbd.jportal2.Link;
import bbd.jportal2.Proc;
import bbd.jportal2.Table;
import bbd.jportal2.View;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresDDL
extends BaseGenerator
implements IBuiltInSIProcessor {
    private final Logger logger = LoggerFactory.getLogger(PostgresDDL.class);
    private String tableOwner;

    @Override
    public String description() {
        return "Generate PostgreSQL DDL";
    }

    @Override
    public String documentation() {
        return "Generate PostgreSQL DDL.";
    }

    public PostgresDDL() {
        super(PostgresDDL.class);
    }

    @Override
    public void generate(Database database, String output) {
        String fileName = database.output.length() > 0 ? database.output : database.name;
        fileName = output + fileName + ".sql";
        this.logger.info("DDL: {}", (Object)fileName);
        try (PrintWriter outData = this.openOutputFileForGeneration("sql", fileName);){
            for (int i = 0; i < database.tables.size(); ++i) {
                this.generateTable(database, database.tables.elementAt(i), outData);
            }
            outData.flush();
        }
        catch (IOException e1) {
            this.logger.error("Generate PosgreSQL IO Error", e1);
        }
    }

    private void generateTable(Database database, Table table, PrintWriter outData) {
        int i;
        this.tableOwner = database.schema.length() > 0 ? database.schema + "." : "";
        String comma = "( ";
        boolean hasNotNull = false;
        if (!table.getFields().isEmpty()) {
            outData.println("DROP TABLE IF EXISTS " + this.tableOwner + table.name + " CASCADE;");
            outData.println();
            outData.println("CREATE TABLE " + this.tableOwner + table.name);
            for (i = 0; i < table.fields.size(); ++i) {
                Field field = table.fields.elementAt(i);
                outData.println(comma + field.name + " " + this.varType(field));
                if (field.defaultValue.length() > 0) {
                    hasNotNull = true;
                }
                if (field.checkValue.length() > 0) {
                    hasNotNull = true;
                } else if (!field.isNull) {
                    hasNotNull = true;
                }
                comma = ", ";
            }
            outData.print(")");
            for (i = 0; i < table.options.size(); ++i) {
                String option = table.options.elementAt(i);
                if (option.toLowerCase().indexOf("tablespace") != 0) continue;
                outData.println();
                outData.print(option);
            }
            outData.println(";");
            outData.println();
            for (i = 0; i < table.grants.size(); ++i) {
                Grant grant = table.grants.elementAt(i);
                this.generateGrant(grant, outData, this.tableOwner + table.name);
            }
            for (i = 0; i < table.keys.size(); ++i) {
                Key key = table.keys.elementAt(i);
                if (key.isPrimary || key.isUnique) continue;
                this.generateIndex(table, key, outData);
            }
        }
        for (i = 0; i < table.views.size(); ++i) {
            View view = table.views.elementAt(i);
            this.generateView(view, outData, table.name, this.tableOwner);
        }
        if (hasNotNull) {
            String alterTable = "ALTER TABLE " + this.tableOwner + table.name;
            for (int i2 = 0; i2 < table.fields.size(); ++i2) {
                Field field = table.fields.elementAt(i2);
                if (field.isNull && field.defaultValue.length() == 0 && field.checkValue.length() == 0) continue;
                outData.print(alterTable + " ALTER " + field.name + " SET");
                if (field.defaultValue.length() > 0) {
                    outData.print(" DEFAULT " + field.defaultValue);
                }
                if (field.checkValue.length() > 0) {
                    outData.print(" CHECK (" + field.checkValue + ")");
                } else {
                    outData.print(" NOT NULL");
                }
                outData.println(";");
            }
            outData.println();
        }
        if (table.keys.size() > 0) {
            for (int i3 = 0; i3 < table.keys.size(); ++i3) {
                Key key = table.keys.elementAt(i3);
                if (key.isPrimary) {
                    outData.println("ALTER TABLE " + this.tableOwner + table.name);
                    this.generatePrimary(table, key, outData);
                    outData.println(";");
                    continue;
                }
                if (!key.isUnique) continue;
                outData.println("ALTER TABLE " + this.tableOwner + table.name);
                this.generateUnique(table, key, outData);
                outData.println(";");
            }
            outData.println();
        }
        if (table.links.size() > 0) {
            for (int i4 = 0; i4 < table.links.size(); ++i4) {
                Link link = table.links.elementAt(i4);
                outData.println("ALTER TABLE " + this.tableOwner + table.name);
                if (link.linkName.length() == 0) {
                    link.linkName = table.name.toUpperCase() + "_FK" + this.bSO(i4);
                }
                this.generateLink(link, this.tableOwner, outData);
                outData.println(";");
            }
            outData.println();
        }
        for (int i5 = 0; i5 < table.procs.size(); ++i5) {
            Proc proc = table.procs.elementAt(i5);
            if (!proc.isData) continue;
            this.generateProc(proc, outData);
        }
    }

    private void generateProc(Proc proc, PrintWriter outData) {
        for (int i = 0; i < proc.lines.size(); ++i) {
            String l = proc.lines.elementAt((int)i).line;
            outData.println(l);
        }
        outData.println();
    }

    private void generateLink(Link link, String tableOwner, PrintWriter outData) {
        String comma = "  ( ";
        outData.println(" ADD CONSTRAINT " + link.linkName + " FOREIGN KEY");
        for (int i = 0; i < link.fields.size(); ++i) {
            String name = link.fields.elementAt(i);
            outData.println(comma + name);
            comma = "  , ";
        }
        outData.println("  ) REFERENCES " + tableOwner + link.name + " MATCH FULL");
    }

    private void generateUnique(Table table, Key key, PrintWriter outData) {
        String comma = "  ( ";
        String keyname = key.name.toUpperCase();
        if (keyname.indexOf(table.name.toUpperCase()) == -1) {
            keyname = table.name.toUpperCase() + "_" + keyname;
        }
        outData.println(" ADD CONSTRAINT " + keyname + " UNIQUE");
        for (int i = 0; i < key.fields.size(); ++i) {
            String name = key.fields.elementAt(i);
            outData.println(comma + name);
            comma = "  , ";
        }
        outData.println("  )");
    }

    private void generatePrimary(Table table, Key key, PrintWriter outData) {
        int i;
        String comma = "  ( ";
        String keyname = key.name.toUpperCase();
        if (keyname.indexOf(table.name.toUpperCase()) == -1) {
            keyname = table.name.toUpperCase() + "_" + keyname;
        }
        outData.println(" ADD CONSTRAINT " + keyname + " PRIMARY KEY");
        for (i = 0; i < key.fields.size(); ++i) {
            String name = key.fields.elementAt(i);
            outData.println(comma + name);
            comma = "  , ";
        }
        outData.print("  )");
        for (i = 0; i < key.options.size(); ++i) {
            String option = key.options.elementAt(i);
            if (option.toLowerCase().indexOf("tablespace") != 0) continue;
            outData.print(" USING INDEX " + option);
        }
        outData.println();
    }

    private String bSO(int i) {
        String x = "" + (101 + i);
        return x.substring(1);
    }

    private void generateView(View view, PrintWriter outData, String tableName, String tableOwner) {
        int i;
        outData.println("CREATE OR REPLACE VIEW " + tableOwner + tableName + view.name);
        if (view.aliases.size() > 0) {
            String comma = "( ";
            for (int i2 = 0; i2 < view.aliases.size(); ++i2) {
                String alias = view.aliases.elementAt(i2);
                outData.println(comma + alias);
                comma = ", ";
            }
            outData.println(")");
        }
        outData.println("AS (");
        for (i = 0; i < view.lines.size(); ++i) {
            String line = view.lines.elementAt(i);
            outData.println(line);
        }
        outData.println(");");
        outData.println();
        for (i = 0; i < view.users.size(); ++i) {
            String user = view.users.elementAt(i);
            outData.println("GRANT SELECT ON " + tableOwner + tableName + view.name + " TO " + user + ";");
        }
        outData.println();
    }

    private void generateIndex(Table table, Key key, PrintWriter outData) {
        int i;
        String comma = "( ";
        String keyname = key.name.toUpperCase();
        if (keyname.indexOf(table.name.toUpperCase()) == -1) {
            keyname = table.name.toUpperCase() + "_" + keyname;
        }
        outData.println("-- DROP INDEX " + keyname + ";");
        outData.println("");
        outData.println("CREATE INDEX " + keyname + " ON " + this.tableOwner + table.name);
        for (i = 0; i < key.fields.size(); ++i) {
            String name = key.fields.elementAt(i);
            outData.println(comma + name);
            comma = ", ";
        }
        outData.print(")");
        for (i = 0; i < key.options.size(); ++i) {
            String option = key.options.elementAt(i);
            if (option.toLowerCase().indexOf("tablespace") != 0) continue;
            outData.println();
            outData.print(option);
        }
        outData.println(";");
        outData.println();
    }

    private void generateGrant(Grant grant, PrintWriter outData, String on) {
        for (int i = 0; i < grant.perms.size(); ++i) {
            String perm = grant.perms.elementAt(i);
            for (int j = 0; j < grant.users.size(); ++j) {
                String user = grant.users.elementAt(j);
                outData.println("GRANT " + perm + " ON " + on + " TO " + user + ";");
                outData.println();
            }
        }
    }

    private String varType(Field field) {
        switch (field.type) {
            case 3: {
                return "smallint";
            }
            case 15: {
                return "smallint";
            }
            case 11: {
                return "integer";
            }
            case 24: {
                return "bigserial";
            }
            case 14: {
                return "serial";
            }
            case 12: {
                return "bigint";
            }
            case 4: {
                return "varchar(" + field.length + ")";
            }
            case 21: {
                return "character(" + field.length + ") -- beware char to varchar morph";
            }
            case 5: {
                return "date";
            }
            case 6: 
            case 18: {
                return "timestamp";
            }
            case 17: {
                return "time";
            }
            case 7: 
            case 9: {
                if (field.precision == 0 && field.scale == 0) {
                    return "float8";
                }
                return "numeric(" + field.precision + ", " + field.scale + ")";
            }
            case 1: {
                return "bytea";
            }
            case 19: {
                return "text";
            }
            case 13: {
                return "numeric(24,6)";
            }
            case 20: {
                return "VARCHAR(16)";
            }
            case 2: {
                return "boolean";
            }
            case 10: {
                return "int generated by default as identity";
            }
            case 25: {
                return "bigint generated by default as identity";
            }
        }
        return "unknown";
    }
}

