/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.graph;

import java.util.LinkedList;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;

public class FilteringDependencyVisitor
implements DependencyVisitor {
    private final DependencyFilter filter;
    private final DependencyVisitor visitor;
    private final LinkedList<Boolean> accepts;
    private final LinkedList<DependencyNode> parents;

    public FilteringDependencyVisitor(DependencyVisitor visitor, DependencyFilter filter) {
        if (visitor == null) {
            throw new IllegalArgumentException("dependency visitor not specified");
        }
        this.visitor = visitor;
        this.filter = filter;
        this.accepts = new LinkedList();
        this.parents = new LinkedList();
    }

    public DependencyVisitor getVisitor() {
        return this.visitor;
    }

    public DependencyFilter getFilter() {
        return this.filter;
    }

    public boolean visitEnter(DependencyNode node) {
        boolean accept = this.filter == null || this.filter.accept(node, this.parents);
        this.accepts.addFirst(accept);
        this.parents.addFirst(node);
        if (accept) {
            return this.visitor.visitEnter(node);
        }
        return true;
    }

    public boolean visitLeave(DependencyNode node) {
        this.parents.removeFirst();
        Boolean accept = this.accepts.removeFirst();
        if (accept.booleanValue()) {
            return this.visitor.visitLeave(node);
        }
        return true;
    }
}

