/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.request;

import com.pengrad.telegrambot.request.AbstractSendRequest;
import java.io.File;

public abstract class AbstractMultipartRequest<T extends AbstractMultipartRequest<T>>
extends AbstractSendRequest<T> {
    private boolean isMultipart;
    private String fileName;

    public AbstractMultipartRequest(Object chatId, Object file) {
        super(chatId);
        if (file instanceof String) {
            this.isMultipart = false;
        } else if (file instanceof File) {
            this.isMultipart = true;
            this.fileName = ((File)file).getName();
        } else if (file instanceof byte[]) {
            this.isMultipart = true;
        } else {
            throw new IllegalArgumentException("Sending data should be String, File or byte[]");
        }
        this.add(this.getFileParamName(), file);
    }

    public T fileName(String fileName) {
        this.fileName = fileName;
        return (T)((AbstractMultipartRequest)this.thisAsT);
    }

    protected T thumb(Object thumb) {
        this.isMultipart = true;
        return (T)((AbstractMultipartRequest)this.add("thumb", thumb));
    }

    @Override
    public boolean isMultipart() {
        return this.isMultipart;
    }

    @Override
    public String getFileName() {
        if (this.fileName != null && !this.fileName.isEmpty()) {
            return this.fileName;
        }
        return this.getDefaultFileName();
    }

    @Override
    public abstract String getContentType();

    protected abstract String getDefaultFileName();

    protected abstract String getFileParamName();
}

