/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.requests.restaction.interactions;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.requests.restaction.interactions.InteractionCallbackAction;
import net.dv8tion.jda.api.utils.AttachmentOption;
import net.dv8tion.jda.internal.utils.Checks;

public interface MessageEditCallbackAction
extends InteractionCallbackAction<InteractionHook> {
    @Nonnull
    public MessageEditCallbackAction setContent(@Nullable String var1);

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction setEmbeds(MessageEmbed ... embeds) {
        Checks.noneNull(embeds, "MessageEmbed");
        return this.setEmbeds(Arrays.asList(embeds));
    }

    @Nonnull
    @CheckReturnValue
    public MessageEditCallbackAction setEmbeds(@Nonnull Collection<? extends MessageEmbed> var1);

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction setActionRows(@Nonnull Collection<? extends ActionRow> rows) {
        Checks.noneNull(rows, "ActionRows");
        return this.setActionRows(rows.toArray(new ActionRow[0]));
    }

    @Nonnull
    @CheckReturnValue
    public MessageEditCallbackAction setActionRows(ActionRow ... var1);

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction setActionRow(ItemComponent ... components) {
        return this.setActionRows(ActionRow.of(components));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction setActionRow(@Nonnull Collection<? extends ItemComponent> components) {
        return this.setActionRows(ActionRow.of(components));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction addFile(@Nonnull File file, AttachmentOption ... options) {
        Checks.notNull(file, "File");
        return this.addFile(file, file.getName(), options);
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction addFile(@Nonnull File file, @Nonnull String name, AttachmentOption ... options) {
        try {
            Checks.notNull(file, "File");
            Checks.check(file.exists() && file.canRead(), "Provided file either does not exist or cannot be read from!");
            return this.addFile(new FileInputStream(file), name, options);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction addFile(@Nonnull byte[] data, @Nonnull String name, AttachmentOption ... options) {
        Checks.notNull(data, "Data");
        return this.addFile(new ByteArrayInputStream(data), name, options);
    }

    @Nonnull
    @CheckReturnValue
    public MessageEditCallbackAction addFile(@Nonnull InputStream var1, @Nonnull String var2, AttachmentOption ... var3);

    @Nonnull
    @CheckReturnValue
    public MessageEditCallbackAction retainFilesById(@Nonnull Collection<String> var1);

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction retainFilesById(String ... ids) {
        Checks.notNull(ids, "IDs");
        return this.retainFilesById(Arrays.asList(ids));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction retainFilesById(long ... ids) {
        Checks.notNull(ids, "IDs");
        return this.retainFilesById(Arrays.stream(ids).mapToObj(Long::toUnsignedString).collect(Collectors.toList()));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction retainFiles(@Nonnull Collection<? extends Message.Attachment> attachments) {
        Checks.noneNull(attachments, "Attachments");
        return this.retainFilesById(attachments.stream().map(ISnowflake::getId).collect(Collectors.toList()));
    }

    @Nonnull
    @CheckReturnValue
    default public MessageEditCallbackAction retainFiles(Message.Attachment ... attachments) {
        Checks.noneNull(attachments, "Attachments");
        return this.retainFiles(Arrays.asList(attachments));
    }
}

