/*
 * Decompiled with CFR 0.152.
 */
package za.co.knonchalant.candogram;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import za.co.knonchalant.candogram.Bots;
import za.co.knonchalant.candogram.HandlerBot;
import za.co.knonchalant.candogram.IBot;
import za.co.knonchalant.candogram.IBotAPI;
import za.co.knonchalant.candogram.ShutdownNotify;
import za.co.knonchalant.candogram.handlers.IUpdate;

@Singleton
@Lock(value=LockType.READ)
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class PollBot
implements ShutdownNotify,
IBot {
    private static final Logger LOGGER = Logger.getLogger(PollBot.class.getName());
    private volatile boolean running = true;
    @EJB
    HandlerBot handlerBot;
    private List<Bots> bots;

    public PollBot(HandlerBot handlerBot) {
        this.handlerBot = handlerBot;
    }

    public PollBot() {
    }

    @Override
    @Asynchronous
    public void start(List<Bots> bots) {
        this.bots = bots;
        while (this.running) {
            for (Bots bot : bots) {
                if (bot == null) continue;
                this.processBot(bot);
            }
            this.sleep();
        }
        LOGGER.info("Received a shutdown, shutting down.");
    }

    @Override
    public void shutdown() {
        this.notifyShutdown();
    }

    private void processBot(Bots bots) {
        try {
            for (IBotAPI bot : bots.getApis()) {
                if (bot.supportsUpdateListener()) {
                    bot.registerUpdateListener(updates -> this.process(bot, updates));
                    continue;
                }
                Collection<IUpdate> updates2 = this.onlyLast(bot.getUpdates(100));
                this.process(bot, updates2);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Update exception", ex);
        }
    }

    private void process(IBotAPI bot, Collection<IUpdate> updates) {
        for (IUpdate update : updates) {
            bot.setOffset((int)(update.getId() + 1L));
            this.handlerBot.handle(bot, update);
        }
    }

    private Collection<IUpdate> onlyLast(List<IUpdate> updates) {
        HashMap<Long, IUpdate> mostRecent = new HashMap<Long, IUpdate>();
        for (IUpdate update : updates) {
            if (update.skip()) continue;
            mostRecent.put(update.getUser().getId(), update);
        }
        return mostRecent.values();
    }

    @Override
    public Bots find(String name) {
        for (Bots bot : this.bots) {
            if (!name.equals(bot.getName())) continue;
            return bot;
        }
        System.out.println("Couldn't find " + name + " in " + this.bots);
        return null;
    }

    private void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void notifyShutdown() {
        LOGGER.info("Telegram server is shutting down.");
        this.running = false;
        for (Bots bot : this.bots) {
            for (IBotAPI api : bot.getApis()) {
                api.unregisterUpdateListener();
            }
        }
    }
}

