/*
 * Decompiled with CFR 0.152.
 */
package za.co.knonchalant.candogram;

import com.google.gson.Gson;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import za.co.knonchalant.candogram.IBotAPI;
import za.co.knonchalant.candogram.dao.PendingResponseDAO;
import za.co.knonchalant.candogram.domain.BaseDetail;
import za.co.knonchalant.candogram.domain.PendingResponse;
import za.co.knonchalant.candogram.handlers.IInlineHandler;
import za.co.knonchalant.candogram.handlers.IMessageHandler;
import za.co.knonchalant.candogram.handlers.IResponseHandler;
import za.co.knonchalant.candogram.handlers.IResponseMessageHandler;
import za.co.knonchalant.candogram.handlers.IUpdate;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
public class HandlerBot {
    private static final Logger LOGGER = Logger.getLogger(HandlerBot.class.getName());
    @EJB
    PendingResponseDAO telegramDAO;

    public HandlerBot() {
    }

    public HandlerBot(PendingResponseDAO telegramDAO) {
        this.telegramDAO = telegramDAO;
    }

    @Asynchronous
    public void handle(IBotAPI bot, IUpdate update) {
        if (update.isInline()) {
            IInlineHandler inlineHandler = bot.getInlineHandler();
            if (inlineHandler != null) {
                inlineHandler.handle(update);
            }
            return;
        }
        List<IMessageHandler> iMessageHandlers = bot.getHandlers();
        String text = this.getText(update);
        if ((text == null || !text.startsWith("/")) && this.tryHandleAsResponse(update, iMessageHandlers, bot)) {
            return;
        }
        for (IMessageHandler iMessageHandler : iMessageHandlers) {
            try {
                this.handle(iMessageHandler, update);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Handler " + iMessageHandler.toString() + " broke", ex);
            }
        }
    }

    private void clearPending(IUpdate update) {
        List<PendingResponse> pendingResponses = this.telegramDAO.getPendingResponses(update.getUser().getId(), update.getChatId());
        for (PendingResponse pendingResponse : pendingResponses) {
            this.telegramDAO.delete(pendingResponse);
        }
    }

    private boolean tryHandleAsResponse(IUpdate update, List<IMessageHandler> iMessageHandlers, IBotAPI bot) {
        List<PendingResponse> pendingResponses = this.telegramDAO.getPendingResponses(update.getUser().getId(), update.getChatId());
        for (PendingResponse pendingResponse : pendingResponses) {
            for (IMessageHandler iMessageHandler : iMessageHandlers) {
                try {
                    if (!this.processHandler(update, pendingResponse, iMessageHandler, bot)) continue;
                    return true;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, iMessageHandler.getClass().toString() + " failed on message: " + ex.toString());
                }
            }
        }
        return false;
    }

    private boolean processHandler(IUpdate update, PendingResponse pendingResponse, IMessageHandler iMessageHandler, IBotAPI bot) {
        if (!(iMessageHandler instanceof IResponseMessageHandler)) {
            return false;
        }
        IResponseMessageHandler handler = (IResponseMessageHandler)((Object)iMessageHandler);
        List handlers = handler.getHandlers();
        for (IResponseHandler iResponseHandler : handlers) {
            if (!this.tryHandle(update, pendingResponse, iResponseHandler, bot)) continue;
            return true;
        }
        return false;
    }

    private boolean tryHandle(IUpdate update, PendingResponse pendingResponse, IResponseHandler iResponseHandler, IBotAPI bot) {
        try {
            Gson gson = new Gson();
            BaseDetail details = (BaseDetail)gson.fromJson(pendingResponse.getDetails(), iResponseHandler.getDetailsClass());
            if (details.getStep() == iResponseHandler.getStep() && pendingResponse.getIdentifier().equals(iResponseHandler.getIdentifier())) {
                iResponseHandler.setBot(bot);
                pendingResponse.setStepRetry(false);
                pendingResponse.setStepHandled(false);
                PendingResponse resultResponse = iResponseHandler.handleResponse(update, details, pendingResponse);
                if (resultResponse.isStepHandled()) {
                    details.nextStep();
                }
                resultResponse.setDetails(details);
                if (!resultResponse.isComplete()) {
                    this.telegramDAO.persistPendingResponse(resultResponse);
                } else {
                    this.clearPending(update);
                }
                return resultResponse.isComplete() || resultResponse.isStepHandled() || resultResponse.isStepRetry();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Handle response issue.", ex);
            return true;
        }
        return false;
    }

    public String getText(IUpdate update) {
        if (update == null || update.getText() == null) {
            return null;
        }
        return update.getText();
    }

    private void handle(IMessageHandler iMessageHandler, IUpdate update) {
        try {
            PendingResponse handle;
            if (iMessageHandler.matches(update) && (handle = iMessageHandler.handle(update)) != null) {
                this.telegramDAO.clearPending(update.getUser().getId(), update.getChatId());
                LOGGER.info(handle.getIdentifier() + " expecting a response");
                this.telegramDAO.persistPendingResponse(handle);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Command handler exception", ex);
        }
    }
}

