/*
 * Decompiled with CFR 0.152.
 */
package za.co.knonchalant.candogram.api;

import com.pengrad.telegrambot.TelegramBot;
import com.pengrad.telegrambot.model.Update;
import com.pengrad.telegrambot.model.request.ChatAction;
import com.pengrad.telegrambot.model.request.InlineKeyboardMarkup;
import com.pengrad.telegrambot.model.request.InlineQueryResult;
import com.pengrad.telegrambot.model.request.InlineQueryResultPhoto;
import com.pengrad.telegrambot.model.request.Keyboard;
import com.pengrad.telegrambot.model.request.ParseMode;
import com.pengrad.telegrambot.model.request.ReplyKeyboardMarkup;
import com.pengrad.telegrambot.request.AnswerInlineQuery;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.request.EditMessageReplyMarkup;
import com.pengrad.telegrambot.request.GetMe;
import com.pengrad.telegrambot.request.GetUpdates;
import com.pengrad.telegrambot.request.SendAnimation;
import com.pengrad.telegrambot.request.SendChatAction;
import com.pengrad.telegrambot.request.SendMessage;
import com.pengrad.telegrambot.request.SendPhoto;
import com.pengrad.telegrambot.response.BaseResponse;
import com.pengrad.telegrambot.response.GetUpdatesResponse;
import com.pengrad.telegrambot.response.SendResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import za.co.knonchalant.candogram.ChatBacklog;
import za.co.knonchalant.candogram.IBotAPI;
import za.co.knonchalant.candogram.handlers.IBotUpdatesHandler;
import za.co.knonchalant.candogram.handlers.IInlineHandler;
import za.co.knonchalant.candogram.handlers.IMessageHandler;
import za.co.knonchalant.candogram.handlers.IUpdate;
import za.co.knonchalant.candogram.handlers.User;
import za.co.knonchalant.candogram.handlers.update.TelegramUpdate;

public class TelegramBotAPI
implements IBotAPI<TelegramUpdate> {
    private TelegramBot bot;
    private List<IMessageHandler> iMessageHandlers = new ArrayList<IMessageHandler>();
    private int offset;
    private IInlineHandler inlineHandler;
    private String name;
    private boolean throttle;
    private boolean registeredForUpdates;
    private final Map<Long, ChatBacklog> backlog = new HashMap<Long, ChatBacklog>();

    public TelegramBotAPI(String name, String apiKey, boolean throttle) {
        this.name = name;
        this.throttle = throttle;
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).build();
        this.bot = new TelegramBot.Builder(apiKey).okHttpClient(client).build();
        this.bot.execute((BaseRequest)new GetMe());
    }

    public TelegramBotAPI(String name, String apiKey) {
        this(name, apiKey, true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean supportsUpdateListener() {
        return false;
    }

    @Override
    public void registerUpdateListener(IBotUpdatesHandler handler) {
        if (this.registeredForUpdates) {
            return;
        }
        this.registeredForUpdates = true;
        this.bot.setUpdatesListener(updates -> {
            handler.handle(updates.stream().map(TelegramUpdate::new).collect(Collectors.toList()));
            return -1;
        });
    }

    @Override
    public void unregisterUpdateListener() {
        this.registeredForUpdates = false;
        this.bot.removeGetUpdatesListener();
    }

    private TelegramBot getBot() {
        return this.bot;
    }

    @Override
    public List<IMessageHandler> getHandlers() {
        return this.iMessageHandlers;
    }

    @Override
    public void setInlineHandler(IInlineHandler handler) {
        this.inlineHandler = handler;
    }

    @Override
    public IInlineHandler getInlineHandler() {
        return this.inlineHandler;
    }

    @Override
    public void addHandler(IMessageHandler handler) {
        this.iMessageHandlers.add(handler);
    }

    @Override
    public void addHandlers(List<IMessageHandler> handler) {
        for (IMessageHandler iMessageHandler : handler) {
            this.addHandler(iMessageHandler);
        }
    }

    @Override
    public List<TelegramUpdate> getUpdates(Integer limit) {
        GetUpdatesResponse updates = (GetUpdatesResponse)this.bot.execute((BaseRequest)new GetUpdates().limit(limit.intValue()).offset(this.offset).timeout(0));
        ArrayList<TelegramUpdate> result = new ArrayList<TelegramUpdate>();
        if (updates == null || updates.updates() == null) {
            return result;
        }
        for (Update update : updates.updates()) {
            if (update.inlineQuery() != null) {
                System.out.println("Inline: " + update.inlineQuery().query());
            }
            result.add(new TelegramUpdate(update));
        }
        return result;
    }

    @Override
    public void sendMessage(TelegramUpdate message, String text, Object ... args) {
        this.sendTheMessage(new SendMessage((Object)message.getChatId(), String.format(text, args)).parseMode(ParseMode.Markdown));
    }

    @Override
    public void sendMessage(TelegramUpdate message, String text) {
        this.sendTheMessage(new SendMessage((Object)message.getChatId(), text).parseMode(ParseMode.Markdown));
    }

    @Override
    public void sendMessage(Long chatId, String message, ParseMode parseMode, boolean disableWebPagePreview, Integer messageId, Keyboard keyboard) {
        if (parseMode == null) {
            parseMode = ParseMode.Markdown;
        }
        SendMessage sendMessage = new SendMessage((Object)chatId, message).parseMode(parseMode).disableWebPagePreview(disableWebPagePreview);
        if (keyboard != null) {
            sendMessage = (SendMessage)sendMessage.replyMarkup(keyboard);
        }
        if (messageId != null) {
            sendMessage = (SendMessage)sendMessage.replyToMessageId(messageId.intValue());
        }
        this.sendTheMessage(sendMessage);
    }

    @Override
    public void updateMessage(Long chatId, String message, Integer messageId, InlineKeyboardMarkup keyboard) {
        BaseResponse execute;
        EditMessageReplyMarkup sendMessage = new EditMessageReplyMarkup((Object)chatId, messageId.intValue());
        if (keyboard != null) {
            sendMessage = sendMessage.replyMarkup(keyboard);
        }
        if (!(execute = this.bot.execute((BaseRequest)sendMessage)).isOk()) {
            System.out.println("Sending message failed: " + execute.errorCode() + " - " + execute.description());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTheMessage(SendMessage sendMessage) {
        ChatBacklog sendMessages;
        Object chat_idObj = sendMessage.getParameters().get("chat_id");
        Long chatId = Long.parseLong(chat_idObj.toString());
        if (!this.backlog.containsKey(chatId)) {
            Map<Long, ChatBacklog> map = this.backlog;
            synchronized (map) {
                if (!this.backlog.containsKey(chatId)) {
                    this.backlog.put(chatId, new ChatBacklog(this.throttle));
                }
            }
        }
        ChatBacklog chatBacklog = sendMessages = this.backlog.get(chatId);
        synchronized (chatBacklog) {
            sendMessages.add(sendMessage);
        }
        this.sendBacklog(chatId);
    }

    private void sendOneMessage(SendMessage sendMessage) {
        boolean sent = false;
        SendResponse execute = null;
        while (!sent) {
            try {
                execute = (SendResponse)this.bot.execute((BaseRequest)sendMessage);
                sent = true;
            }
            catch (Exception ex) {
                return;
            }
        }
        if (!execute.isOk()) {
            System.out.println("Sending message failed: " + execute.errorCode() + " - " + execute.description());
            return;
        }
        execute.message();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBacklog(Long chatId) {
        ArrayList<SendMessage> thisLog;
        ChatBacklog sendMessages = this.backlog.get(chatId);
        if (!this.backlog.containsKey(chatId) || sendMessages.isEmpty()) {
            return;
        }
        Object object = sendMessages;
        synchronized (object) {
            thisLog = new ArrayList<SendMessage>(sendMessages.getMessages());
            sendMessages.clear();
        }
        object = sendMessages.getSentLock();
        synchronized (object) {
            for (SendMessage sendMessage : thisLog) {
                long timeToWait = sendMessages.timeLeft();
                if (timeToWait > 0L) {
                    this.sleep(timeToWait);
                }
                sendMessages.reset();
                this.sendOneMessage(sendMessage);
            }
        }
    }

    private void sleep(long timeToWait) {
        try {
            Thread.sleep(timeToWait);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendMessageWithKeyboard(IUpdate message, List<List<String>> keyboardList, String text) {
        SendMessage sendMessage = (SendMessage)((SendMessage)new SendMessage((Object)message.getChatId(), text).parseMode(ParseMode.Markdown).replyMarkup(this.defaultKeyboard(keyboardList))).replyToMessageId((int)message.getId());
        this.sendTheMessage(sendMessage);
    }

    private Keyboard defaultKeyboard(List<List<String>> keyboardList) {
        return new ReplyKeyboardMarkup(this.getArrayFromKeyboard(keyboardList)).oneTimeKeyboard(true).resizeKeyboard(true).selective(true);
    }

    private String[][] getArrayFromKeyboard(List<List<String>> keyboardList) {
        String[][] array = new String[keyboardList.size()][];
        int j = 0;
        for (List<String> nestedList : keyboardList) {
            array[j++] = nestedList.toArray(new String[0]);
        }
        return array;
    }

    @Override
    public boolean typing(IUpdate update) {
        BaseResponse execute = this.getBot().execute((BaseRequest)new SendChatAction((Object)update.getChatId(), ChatAction.typing.name()));
        return execute.isOk();
    }

    @Override
    public void setOffset(int updateId) {
        this.offset = Math.max(updateId, this.offset);
    }

    @Override
    public List<User> getChatUsers(long chatId) {
        throw new RuntimeException("Doesn't seem possible.");
    }

    @Override
    public void sendInlinePhoto(String inlineId, String photoUrl, String thumbnailUrl, int width, int height) {
        InlineQueryResultPhoto inlineQueryResultPhoto = new InlineQueryResultPhoto(inlineId, photoUrl, thumbnailUrl);
        inlineQueryResultPhoto.photoHeight(Integer.valueOf(height));
        inlineQueryResultPhoto.photoWidth(Integer.valueOf(width));
        BaseResponse execute = this.getBot().execute((BaseRequest)new AnswerInlineQuery(inlineId, new InlineQueryResult[]{inlineQueryResultPhoto}));
        System.out.println(execute);
    }

    @Override
    public void sendPhoto(TelegramUpdate chat, byte[] photoBytes) {
        this.getBot().execute((BaseRequest)new SendPhoto((Object)chat.getChatId(), photoBytes));
    }

    @Override
    public void sendAnimation(String chatId, byte[] documentBytes) {
        this.getBot().execute((BaseRequest)new SendAnimation((Object)chatId, documentBytes));
    }
}

