/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.audit.AuditLogKey;

public enum ChannelField {
    TYPE("type", AuditLogKey.CHANNEL_TYPE),
    NAME("name", AuditLogKey.CHANNEL_NAME),
    PARENT("parent", AuditLogKey.CHANNEL_PARENT),
    POSITION("position", null),
    TOPIC("topic", AuditLogKey.CHANNEL_TOPIC),
    NSFW("nsfw", AuditLogKey.CHANNEL_NSFW),
    SLOWMODE("slowmode", AuditLogKey.CHANNEL_SLOWMODE),
    BITRATE("bitrate", AuditLogKey.CHANNEL_BITRATE),
    REGION("region", null),
    USER_LIMIT("userlimit", AuditLogKey.CHANNEL_USER_LIMIT),
    AUTO_ARCHIVE_DURATION("autoArchiveDuration", AuditLogKey.THREAD_AUTO_ARCHIVE_DURATION),
    ARCHIVED("archived", AuditLogKey.THREAD_ARCHIVED),
    ARCHIVED_TIMESTAMP("archiveTimestamp", null),
    LOCKED("locked", AuditLogKey.THREAD_LOCKED),
    INVITABLE("invitable", AuditLogKey.THREAD_INVITABLE);

    private final String fieldName;
    private final AuditLogKey auditLogKey;

    private ChannelField(String fieldName, AuditLogKey auditLogKey) {
        this.fieldName = fieldName;
        this.auditLogKey = auditLogKey;
    }

    @Nonnull
    public String getFieldName() {
        return this.fieldName;
    }

    @Nullable
    public AuditLogKey getAuditLogKey() {
        return this.auditLogKey;
    }

    public String toString() {
        return "ChannelField." + this.name() + '(' + this.fieldName + ')';
    }
}

